/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.data.utils;

import com.nukateam.nukacraft.common.registery.ModAttributes;
import com.nukateam.nukacraft.common.registery.ModEffect;
import java.util.Collection;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class RadiationUtils {
    public static void addRadiation(LivingEntity entity, float value) {
        Collection effects = entity.m_21220_();
        if (entity instanceof Player && value > 0.0f) {
            for (MobEffectInstance effect : effects) {
                if (effect.m_19544_() != ModEffect.RAD_RES.get()) continue;
                value = (float)((double)value / 1.5);
            }
        }
        RadiationUtils.handleAddedRadiation(entity, value);
    }

    private static void handleAddedRadiation(LivingEntity entity, double value) {
        boolean isRemovingRad;
        AttributeInstance radiationAtt = entity.m_21051_((Attribute)ModAttributes.RADIATION.get());
        AttributeInstance healthAtt = entity.m_21051_(Attributes.f_22276_);
        double maxHealth = healthAtt.m_22115_();
        double currentHealth = healthAtt.m_22135_();
        double currentRad = radiationAtt.m_22135_();
        double radMod = value;
        double healthMod = -value;
        boolean bl = isRemovingRad = value < 0.0;
        if (isRemovingRad) {
            if (currentHealth + healthMod > maxHealth) {
                healthMod = maxHealth - currentHealth;
            }
            if (currentRad + radMod < 0.0) {
                radMod = -currentRad;
            }
        } else {
            if (currentHealth + healthMod > maxHealth - 1.0) {
                healthMod = maxHealth - currentHealth - 1.0;
            }
            if (currentRad + radMod > maxHealth - 1.0) {
                radMod = Math.max(0.0, Math.min(radMod, currentHealth - 1.0));
            }
        }
        RadiationUtils.modifyAttribute(radiationAtt, radMod, 0.0, maxHealth - 1.0);
        RadiationUtils.modifyAttribute(healthAtt, healthMod, -maxHealth + 1.0, 0.0);
        entity.m_21153_(Math.min(entity.m_21233_(), entity.m_21223_()));
    }

    private static void modifyAttribute(AttributeInstance radiationAtt, double value, double minBound, double maxBound) {
        if (radiationAtt == null) {
            return;
        }
        double currentValue = 0.0;
        for (AttributeModifier mod : radiationAtt.m_22122_()) {
            if (!mod.m_22214_().equals("radiation")) continue;
            currentValue = mod.m_22218_();
            radiationAtt.m_22130_(mod);
        }
        double newValue = currentValue + value;
        if (newValue < minBound) {
            newValue = minBound;
        }
        if (newValue > maxBound) {
            newValue = maxBound;
        }
        radiationAtt.m_22125_(new AttributeModifier("radiation", newValue, AttributeModifier.Operation.ADDITION));
    }

    public static void setAddMaxHealth2(Player player, double value) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22276_);
        if (attribute == null) {
            return;
        }
        double currentValue = 0.0;
        for (AttributeModifier mod : attribute.m_22122_()) {
            if (!mod.m_22214_().equals("health")) continue;
            currentValue = mod.m_22218_();
            attribute.m_22130_(mod);
        }
        attribute.m_22125_(new AttributeModifier("health", currentValue + value, AttributeModifier.Operation.ADDITION));
    }
}

