/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.datagen.loot;

import com.nukateam.nukacraft.common.datagen.DataGenUtils;
import com.nukateam.nukacraft.common.datagen.utils.annotations.LootIgnored;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModBlockLootProvider
extends BlockLootSubProvider {
    private final Class<?>[] blockClasses;

    public ModBlockLootProvider(Class<?> ... blockClasses) {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        this.blockClasses = blockClasses;
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        ArrayList<Block> result = new ArrayList<Block>();
        for (Class<?> blocksClass : this.blockClasses) {
            result.addAll(ModBlockLootProvider.getBlocks(blocksClass));
        }
        return result;
    }

    protected void m_245660_() {
        for (Block block : this.getKnownBlocks()) {
            this.m_245724_(block);
        }
        this.overrideLoot();
    }

    protected void overrideLoot() {
    }

    protected void simpleDrop(Block block, Item item, int amount) {
        this.m_247577_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)amount))))));
    }

    protected void dropItemOre(Block block, Item drop) {
        this.m_246481_(block, b -> this.createCopperLikeOreDrops(block, drop));
    }

    protected LootTable.Builder createCopperLikeOreDrops(Block pBlock, Item item) {
        return ModBlockLootProvider.m_247502_((Block)pBlock, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)pBlock, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)))));
    }

    @NotNull
    private static ArrayList<Block> getBlocks(Class<?> blocksClass) {
        ArrayList<Block> result = new ArrayList<Block>();
        DataGenUtils.handleFields(blocksClass, (obj, field) -> {
            RegistryObject registry;
            if (obj instanceof RegistryObject && (registry = (RegistryObject)obj).get() instanceof Block) {
                Block block = (Block)registry.get();
                if (!field.isAnnotationPresent(LootIgnored.class)) {
                    result.add(block);
                }
            }
        });
        return result;
    }
}

