/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.datagen.providers;

import com.nukateam.nukacraft.common.data.interfaces.IAgeable;
import com.nukateam.nukacraft.common.datagen.DataGenConfig;
import com.nukateam.nukacraft.common.datagen.DataGenUtils;
import com.nukateam.nukacraft.common.datagen.utils.annotations.BlockStateGen;
import com.nukateam.nukacraft.common.datagen.utils.enums.ItemType;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModBlockStateProvider
extends BlockStateProvider {
    private final ExistingFileHelper existingFileHelper;

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "nukacraft", exFileHelper);
        this.existingFileHelper = exFileHelper;
    }

    protected void registerStatesAndModels() {
        for (Class clazz : DataGenConfig.dataGenClasses) {
            DataGenUtils.handleFields(clazz, BlockStateGen.class, this::handleDataGenField);
        }
    }

    private void handleDataGenField(Object obj, BlockStateGen annotation) {
        RegistryObject registry;
        if (obj instanceof RegistryObject && (registry = (RegistryObject)obj).get() instanceof Block) {
            RegistryObject block = registry;
            switch (annotation.type()) {
                case CUBE: {
                    this.blockWithItem((RegistryObject<Block>)block);
                    break;
                }
                case SAPLING: {
                    this.saplingBlock((RegistryObject<Block>)block);
                    break;
                }
                case STAIRS: {
                    this.stairsBlock((RegistryObject<StairBlock>)registry, annotation.blockModel());
                    break;
                }
                case SLAB: {
                    this.slabBlock((RegistryObject<SlabBlock>)registry);
                    break;
                }
                case DOOR: {
                    this.door((RegistryObject<DoorBlock>)registry, annotation.renderType(), annotation.itemModel());
                    break;
                }
                case LEAVES: {
                    this.leavesBlock((RegistryObject<Block>)block);
                    break;
                }
                case LOG: {
                    this.logBlock((RegistryObject<RotatedPillarBlock>)registry);
                    break;
                }
                case CUTOUT: {
                    this.cutoutBlock((RegistryObject<Block>)block);
                    break;
                }
                case BLOCKSTATE: {
                    this.simpleBlockState((RegistryObject<Block>)block, annotation);
                    break;
                }
                case FACING: {
                    this.facingBlock((RegistryObject<Block>)block, annotation);
                    break;
                }
                case BLOCK_ITEM: {
                    this.justBlockItem((RegistryObject<Block>)block);
                    break;
                }
                case ITEM: {
                    this.justItem((RegistryObject<Block>)block);
                    break;
                }
                case POTTED: {
                    this.pottedPlant((RegistryObject<Block>)block);
                    break;
                }
                case PANE: {
                    this.paneBlock((RegistryObject<IronBarsBlock>)registry);
                    break;
                }
                case AGING: {
                    this.ageBasedBlock((RegistryObject<Block>)block, annotation);
                    break;
                }
                case FACING_AGING: {
                    this.facingAgingBlock((RegistryObject<Block>)block, annotation);
                    break;
                }
                case STEM: {
                    this.stemBlock((RegistryObject<Block>)block, annotation);
                    break;
                }
                case ATTACHED_STEM: {
                    this.attachedStemBlock((RegistryObject<Block>)block, annotation);
                }
            }
        }
    }

    private void facingAgingBlock(RegistryObject<Block> registry, BlockStateGen annotation) {
        Block block = (Block)registry.get();
        String name = this.name(block);
        if (block instanceof IAgeable) {
            IAgeable ageable = (IAgeable)block;
            IntegerProperty ageProp = ageable.getAge();
            DirectionProperty facingProp = BlockStateProperties.f_61374_;
            this.getVariantBuilder(block).forAllStates(state -> {
                ModelFile.ExistingModelFile model;
                Integer age = (Integer)state.m_61143_((Property)ageProp);
                Direction facing = (Direction)state.m_61143_((Property)facingProp);
                ResourceLocation modelLocation = this.modLoc("block/" + name + age);
                Object object = model = annotation.blockModel() ? ((BlockModelBuilder)this.models().cross(name + age, modelLocation)).renderType("cutout") : this.models().getExistingFile(modelLocation);
                if (facing == Direction.NORTH && age == 0 && annotation.itemModel()) {
                    if (annotation.itemType() == ItemType.BLOCK) {
                        this.simpleBlockItem(block, (ModelFile)model);
                    } else {
                        this.simpleItem(block);
                    }
                }
                int yRotation = switch (facing) {
                    case Direction.EAST -> 270;
                    case Direction.NORTH -> 180;
                    case Direction.WEST -> 90;
                    default -> 0;
                };
                return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(yRotation).build();
            });
        }
    }

    private void paneBlock(RegistryObject<IronBarsBlock> block) {
        String name = this.name((Block)block.get());
        ResourceLocation texture = this.modLoc("block/" + name);
        ResourceLocation textureTop = this.modLoc("block/" + name + "_top");
        textureTop = this.checkTextureExists(textureTop) ? textureTop : texture;
        this.paneBlockWithRenderType((IronBarsBlock)block.get(), texture, textureTop, "cutout");
        this.simpleItem((Block)block.get(), texture);
    }

    private void pottedPlant(RegistryObject<Block> block) {
        String name = this.name((Block)block.get());
        ResourceLocation parent = new ResourceLocation("minecraft:block/flower_pot_cross");
        String textureName = name.replaceAll("potted_", "");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture("plant", this.modLoc("block/" + textureName))).renderType("cutout");
        this.getVariantBuilder((Block)block.get()).partialState().modelForState().modelFile((ModelFile)model).addModel();
    }

    private void ageBasedBlock(RegistryObject<Block> registry, BlockStateGen annotation) {
        Block block = (Block)registry.get();
        String name = this.name(block);
        if (block instanceof IAgeable) {
            IAgeable ageable = (IAgeable)block;
            IntegerProperty ageProp = ageable.getAge();
            this.getVariantBuilder(block).forAllStates(state -> {
                ModelFile.ExistingModelFile model;
                int age = (Integer)state.m_61143_((Property)ageProp);
                ResourceLocation modelLocation = this.modLoc("block/" + this.name(block) + age);
                Object object = model = annotation.blockModel() ? ((BlockModelBuilder)this.models().cross(name + age, modelLocation)).renderType("cutout") : this.models().getExistingFile(modelLocation);
                if (age == 0 && annotation.itemModel()) {
                    if (annotation.itemType() == ItemType.BLOCK) {
                        this.simpleBlockItem(block, (ModelFile)model);
                    } else {
                        this.simpleItem(block);
                    }
                }
                return ConfiguredModel.builder().modelFile((ModelFile)model).build();
            });
        }
    }

    private void simpleBlockState(RegistryObject<Block> registry, BlockStateGen annotation) {
        Block block = (Block)registry.get();
        ModelFile.ExistingModelFile model = this.getExistingModel(block);
        this.simpleBlock(block, (ModelFile)model);
        this.genItem(annotation, block, model);
    }

    private void facingBlock(RegistryObject<Block> registry, BlockStateGen annotation) {
        Block block = (Block)registry.get();
        ModelFile.ExistingModelFile modelFile = this.getExistingModel(block);
        this.facingBlockstste(block, (ModelFile)modelFile);
        this.genItem(annotation, block, modelFile);
    }

    private void attachedStemBlock(RegistryObject<Block> registry, BlockStateGen annotation) {
        Block block = (Block)registry.get();
        BlockModelBuilder modelFile = this.attachedStem(block);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)modelFile).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)modelFile).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)modelFile).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)modelFile).addModel();
    }

    private void facingBlockstste(Block block, ModelFile modelFile) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).modelForState().modelFile(modelFile).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).modelForState().modelFile(modelFile).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).modelForState().modelFile(modelFile).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).modelForState().modelFile(modelFile).rotationY(270).addModel();
    }

    private void genItem(BlockStateGen annotation, Block block, ModelFile.ExistingModelFile modelFile) {
        if (annotation.itemModel()) {
            if (annotation.itemType() == ItemType.BLOCK) {
                this.simpleBlockItem(block, (ModelFile)modelFile);
            } else {
                this.simpleItem(block);
            }
        }
    }

    private void justItem(RegistryObject<Block> registry) {
        this.simpleItem((Block)registry.get());
    }

    private ModelFile.ExistingModelFile getExistingModel(Block block) {
        ResourceLocation modelLocation = this.modelLoc(block);
        ModelFile.ExistingModelFile modelFile = this.models().getExistingFile(modelLocation);
        return modelFile;
    }

    private void simpleItem(Block block) {
        this.simpleItem(block, this.itemTexture(block));
    }

    private void justBlockItem(RegistryObject<Block> registry) {
        Block block = (Block)registry.get();
        ModelFile.ExistingModelFile modelFile = this.getExistingModel(block);
        this.simpleBlockItem((Block)registry.get(), (ModelFile)modelFile);
    }

    private void stairsBlock(RegistryObject<StairBlock> registry, boolean blockModel) {
        ModelFile.ExistingModelFile model;
        StairBlock block = (StairBlock)registry.get();
        ResourceLocation parentId = this.getIdWithoutSuffix((Block)block, "_stairs");
        if (blockModel) {
            model = this.models().stairs(this.name((Block)block), parentId, parentId, parentId);
            this.stairsBlock(block, parentId);
        } else {
            model = this.models().getExistingFile(this.modelLoc((Block)block));
            this.registerStairsBlock((Block)block);
        }
        this.simpleBlockItem((Block)registry.get(), (ModelFile)model);
    }

    private void stemBlock(RegistryObject<Block> registry, BlockStateGen annotation) {
        Block block = (Block)registry.get();
        String name = this.name(block);
        if (block instanceof IAgeable) {
            IAgeable ageable = (IAgeable)block;
            IntegerProperty ageProp = ageable.getAge();
            this.getVariantBuilder(block).forAllStates(state -> {
                int age = (Integer)state.m_61143_((Property)ageProp);
                ResourceLocation modelLocation = this.modLoc("block/" + name + age);
                BlockModelBuilder model = annotation.blockModel() ? this.stemModel(block, age) : this.models().getExistingFile(modelLocation);
                return ConfiguredModel.builder().modelFile((ModelFile)model).build();
            });
        }
    }

    private BlockModelBuilder stemModel(Block block, int age) {
        String name = this.name(block);
        String modelName = name + age;
        String parentModel = "minecraft:block/stem_growth" + age;
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, new ResourceLocation(parentModel))).texture("stem", this.modLoc("block/" + name))).renderType("cutout");
    }

    private BlockModelBuilder attachedStem(Block block) {
        String modelMame = this.name(block);
        String stemTexture = this.name(block).replaceAll("attached_", "");
        String upperStemTexture = stemTexture + "_upper";
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelMame, new ResourceLocation("minecraft:block/stem_fruit"))).texture("stem", this.modLoc("block/" + stemTexture))).texture("upperstem", this.modLoc("block/" + upperStemTexture))).renderType("cutout");
    }

    private void registerStairsBlock(Block block) {
        ResourceLocation parentId = this.key(block);
        ResourceLocation stairsModel = new ResourceLocation(parentId.m_135827_(), parentId.m_135815_());
        ResourceLocation innerStairsModel = new ResourceLocation(parentId.m_135827_(), parentId.m_135815_() + "_inner");
        ResourceLocation outerStairsModel = new ResourceLocation(parentId.m_135827_(), parentId.m_135815_() + "_outer");
        ModelFile.ExistingModelFile stairs = this.models().getExistingFile(stairsModel);
        ModelFile.ExistingModelFile innerStairs = this.models().getExistingFile(innerStairsModel);
        ModelFile.ExistingModelFile outerStairs = this.models().getExistingFile(outerStairsModel);
        this.stairsWithoutUvLock(block, stairs, innerStairs, outerStairs);
    }

    private void stairsWithoutUvLock(Block block, ModelFile.ExistingModelFile stairs, ModelFile.ExistingModelFile innerStairs, ModelFile.ExistingModelFile outerStairs) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            int yRot = (int)facing.m_122427_().m_122435_();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? innerStairs : outerStairs))).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot %= 360).build();
        }, new Property[]{StairBlock.f_56844_});
    }

    private void slabBlock(RegistryObject<SlabBlock> registry) {
        SlabBlock block = (SlabBlock)registry.get();
        ResourceLocation parentId = this.getIdWithoutSuffix((Block)block, "_slab");
        BlockModelBuilder model = (BlockModelBuilder)this.models().slab(this.name((Block)block), parentId, parentId, parentId);
        this.slabBlock(block, parentId, parentId);
        this.simpleBlockItem((Block)registry.get(), (ModelFile)model);
    }

    private ResourceLocation getIdWithoutSuffix(Block block, String suffix) {
        ResourceLocation id = this.key(block);
        String name = id.m_135815_().replaceAll(suffix + "$", "");
        return new ResourceLocation(id.m_135827_(), "block/" + name);
    }

    private void logBlock(RegistryObject<RotatedPillarBlock> registry) {
        RotatedPillarBlock block = (RotatedPillarBlock)registry.get();
        ResourceLocation side = this.blockTexture((Block)block);
        ResourceLocation end = this.extend(this.blockTexture((Block)block), "_top");
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeColumn(this.name((Block)block), side, end);
        this.logBlock(block);
        this.simpleBlockItem((Block)registry.get(), (ModelFile)model);
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }

    private void door(RegistryObject<DoorBlock> registryObject, String renderType, boolean itemModel) {
        DoorBlock block = (DoorBlock)registryObject.get();
        this.doorBlockWithRenderType(block, this.blockTexture((Block)block, "_lower"), this.blockTexture((Block)block, "_upper"), renderType);
        if (itemModel) {
            this.simpleItem((Block)block, this.itemTexture((Block)block));
        }
    }

    private ResourceLocation itemTexture(Block block) {
        ResourceLocation name = this.key(block);
        return new ResourceLocation(name.m_135827_(), "item/" + name.m_135815_());
    }

    private ResourceLocation blockTexture(Block block, String suffix) {
        ResourceLocation name = this.key(block);
        return new ResourceLocation(name.m_135827_(), "block/" + name.m_135815_() + suffix);
    }

    private void saplingBlock(RegistryObject<Block> registry) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)((Block)registry.get())).m_135815_();
        ResourceLocation texture = this.blockTexture((Block)registry.get());
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cross(name, texture)).renderType("cutout");
        this.simpleBlock((Block)registry.get(), (ModelFile)model);
        this.simpleItem((Block)registry.get(), texture);
    }

    public void simpleItem(Block block, ResourceLocation texture) {
        ModelFile.UncheckedModelFile parent = new ModelFile.UncheckedModelFile("item/generated");
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).m_135815_())).texture("layer0", texture)).parent((ModelFile)parent);
    }

    private void leavesBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_(), new ResourceLocation("minecraft:block/leaves"), "all", this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void cutoutBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get())).m_135815_(), this.mcLoc("block/cube_all"), "all", this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void blockItem(Block blockRegistryObject) {
        this.simpleBlockItem(blockRegistryObject, (ModelFile)new ModelFile.UncheckedModelFile("nukacraft:block/" + ForgeRegistries.BLOCKS.getKey((Object)blockRegistryObject).m_135815_()));
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private boolean checkTextureExists(ResourceLocation textureLocation) {
        return this.existingFileHelper.exists(textureLocation, PackType.CLIENT_RESOURCES, ".png", "textures");
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    @NotNull
    private ResourceLocation modelLoc(Block block) {
        ResourceLocation blockId = this.key(block);
        return new ResourceLocation(blockId.m_135827_(), "block/" + blockId.m_135815_());
    }
}

