/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.datagen.providers;

import com.nukateam.nukacraft.common.data.utils.ArmorStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public abstract class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput pOutput) {
        super(pOutput);
    }

    protected static void buildGemRecipes(Consumer<FinishedRecipe> writer, List<ItemLike> ores, Block block, ItemLike gem) {
        ModRecipeProvider.oreCooking(writer, gem, ores, 0.25f, 200);
        ModRecipeProvider.toAndFromBlock(writer, (ItemLike)block, gem);
    }

    protected static void buildIngotRecipes(Consumer<FinishedRecipe> writer, Block block, ItemLike ingot, ItemLike nugget) {
        ModRecipeProvider.toAndFromBlock(writer, (ItemLike)block, ingot);
        ModRecipeProvider.toAndFromBlock(writer, ingot, nugget);
    }

    protected static void buildOreRecipes(Consumer<FinishedRecipe> writer, List<Block> ores, Block block, Block rawBlock, ItemLike raw, ItemLike ingot, ItemLike nugget) {
        ArrayList<ItemLike> smeltables = new ArrayList<ItemLike>(List.of(raw));
        smeltables.addAll(ores);
        ModRecipeProvider.oreCooking(writer, ingot, smeltables, 0.25f, 200);
        ModRecipeProvider.toAndFromBlock(writer, (ItemLike)rawBlock, raw);
        ModRecipeProvider.toAndFromBlock(writer, (ItemLike)block, ingot);
        ModRecipeProvider.toAndFromBlock(writer, ingot, nugget);
    }

    protected static void toAndFromBlock(Consumer<FinishedRecipe> writer, ItemLike block, ItemLike raw) {
        ModRecipeProvider.simpleBlock(writer, raw, block);
        ModRecipeProvider.fromBlock(writer, block, raw);
    }

    protected static void toAndFromBlockSmall(Consumer<FinishedRecipe> writer, ItemLike block, ItemLike raw) {
        ModRecipeProvider.simpleBlockSmall(writer, raw, block);
        ModRecipeProvider.fromBlockSmall(writer, block, raw);
    }

    protected static void fromBlock(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike result) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)9).m_126209_(ingredient).m_126132_(ModRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingredient)).m_176498_(writer);
    }

    protected static void simpleBlock(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).m_126130_("SSS").m_126130_("SSS").m_126130_("SSS").m_126127_(Character.valueOf('S'), ingredient).m_126132_(ModRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)ingredient));
    }

    protected static void fromBlockSmall(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike result) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)4).m_126209_(ingredient).m_126132_(ModRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingredient)).m_176498_(writer);
    }

    protected static void simpleBlockSmall(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).m_126130_("SS").m_126130_("SS").m_126127_(Character.valueOf('S'), ingredient).m_126132_(ModRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)ingredient));
    }

    protected static void axe(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).m_126130_("XX ").m_126130_("X# ").m_126130_(" # ").m_126127_(Character.valueOf('X'), ingredient).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)ingredient));
    }

    protected static void pickaxe(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).m_126130_("XXX").m_126130_(" # ").m_126130_(" # ").m_126127_(Character.valueOf('X'), ingredient).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)ingredient));
    }

    protected static void hoe(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).m_126130_("XX ").m_126130_(" # ").m_126130_(" # ").m_126127_(Character.valueOf('X'), ingredient).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)ingredient));
    }

    protected static void armor(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike ... result) {
        ModRecipeProvider.helmet(writer, ingredient, result[0]);
        ModRecipeProvider.chestPlate(writer, ingredient, result[1]);
        ModRecipeProvider.leggings(writer, ingredient, result[2]);
        ModRecipeProvider.boots(writer, ingredient, result[3]);
    }

    protected static void armor(Consumer<FinishedRecipe> writer, ItemLike ingredient, ArmorStorage result) {
        ModRecipeProvider.armor(writer, ingredient, (ItemLike[])ModRecipeProvider.getArmor(result));
    }

    protected static void armor(Consumer<FinishedRecipe> writer, TagKey<Item> ingredient, ArmorStorage result) {
        ModRecipeProvider.armor(writer, ingredient, (ItemLike[])ModRecipeProvider.getArmor(result));
    }

    private static Item[] getArmor(ArmorStorage armor) {
        Item[] result = new Item[]{(Item)((RegistryObject)armor.get(ArmorItem.Type.HELMET)).get(), (Item)((RegistryObject)armor.get(ArmorItem.Type.CHESTPLATE)).get(), (Item)((RegistryObject)armor.get(ArmorItem.Type.LEGGINGS)).get(), (Item)((RegistryObject)armor.get(ArmorItem.Type.BOOTS)).get()};
        return result;
    }

    protected static void helmet(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("XXX").m_126130_("X X").m_126130_("   ").m_126127_(Character.valueOf('X'), ingredient).m_126132_(ModRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)ingredient));
    }

    protected static void chestPlate(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("X X").m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), ingredient).m_126132_(ModRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)ingredient));
    }

    protected static void leggings(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("XXX").m_126130_("X X").m_126130_("X X").m_126127_(Character.valueOf('X'), ingredient).m_126132_(ModRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)ingredient));
    }

    protected static void boots(Consumer<FinishedRecipe> writer, ItemLike ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("   ").m_126130_("X X").m_126130_("X X").m_126127_(Character.valueOf('X'), ingredient).m_126132_(ModRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.m_176632_((ItemLike)ingredient));
    }

    protected static void armor(Consumer<FinishedRecipe> writer, TagKey<Item> ingredient, ItemLike ... result) {
        ModRecipeProvider.helmet(writer, ingredient, result[0]);
        ModRecipeProvider.chestPlate(writer, ingredient, result[1]);
        ModRecipeProvider.leggings(writer, ingredient, result[2]);
        ModRecipeProvider.boots(writer, ingredient, result[3]);
    }

    protected static void helmet(Consumer<FinishedRecipe> writer, TagKey<Item> ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("XXX").m_126130_("X X").m_126130_("   ").m_206416_(Character.valueOf('X'), ingredient).m_126132_(ModRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.name(ingredient));
    }

    protected static void chestPlate(Consumer<FinishedRecipe> writer, TagKey<Item> ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("X X").m_126130_("XXX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ingredient).m_126132_(ModRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.name(ingredient));
    }

    protected static void leggings(Consumer<FinishedRecipe> writer, TagKey<Item> ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("XXX").m_126130_("X X").m_126130_("X X").m_206416_(Character.valueOf('X'), ingredient).m_126132_(ModRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.name(ingredient));
    }

    protected static void boots(Consumer<FinishedRecipe> writer, TagKey<Item> ingredient, ItemLike result) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).m_126130_("   ").m_126130_("X X").m_126130_("X X").m_206416_(Character.valueOf('X'), ingredient).m_126132_(ModRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)ModRecipeProvider.m_206406_(ingredient)).m_176500_(writer, "nukacraft:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_" + ModRecipeProvider.name(ingredient));
    }

    protected static void oreCooking(Consumer<FinishedRecipe> writer, ItemLike ingot, List<ItemLike> smeltables, float experience, int cookingTIme) {
        ModRecipeProvider.smelting(writer, smeltables, RecipeCategory.MISC, ingot, experience, cookingTIme);
        ModRecipeProvider.blasting(writer, smeltables, RecipeCategory.MISC, ingot, experience, cookingTIme / 2);
    }

    protected static void foodCooking(Consumer<FinishedRecipe> writer, ItemLike result, ItemLike smeltable, float experience, int cookingTIme) {
        List<ItemLike> smeltables = List.of(smeltable);
        ModRecipeProvider.foodCooking(writer, result, smeltables, experience, cookingTIme);
    }

    protected static void foodCooking(Consumer<FinishedRecipe> writer, ItemLike ingot, List<ItemLike> smeltables, float experience, int cookingTIme) {
        ModRecipeProvider.smelting(writer, smeltables, RecipeCategory.FOOD, ingot, experience, cookingTIme);
        ModRecipeProvider.smoking(writer, smeltables, RecipeCategory.FOOD, ingot, experience, cookingTIme / 2);
        ModRecipeProvider.campfire(writer, smeltables, RecipeCategory.FOOD, ingot, experience, cookingTIme * 3);
    }

    protected static void smelting(Consumer<FinishedRecipe> consumer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme) {
        ModRecipeProvider.cooking(consumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_, pIngredients, pCategory, pResult, pExperience, pCookingTIme, "_from_smelting");
    }

    protected static void smoking(Consumer<FinishedRecipe> consumer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime) {
        ModRecipeProvider.cooking(consumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44093_, pIngredients, pCategory, pResult, pExperience, pCookingTime, "_from_smoking");
    }

    protected static void blasting(Consumer<FinishedRecipe> consumer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime) {
        ModRecipeProvider.cooking(consumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44092_, pIngredients, pCategory, pResult, pExperience, pCookingTime, "_from_blasting");
    }

    protected static void campfire(Consumer<FinishedRecipe> consumer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime) {
        ModRecipeProvider.cooking(consumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44094_, pIngredients, pCategory, pResult, pExperience, pCookingTime, "_from_campfire");
    }

    protected static void cooking(Consumer<FinishedRecipe> consumer, RecipeSerializer<? extends AbstractCookingRecipe> pCookingSerializer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike result, float pExperience, int pCookingTime, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            ModRecipeProvider.cooking(consumer, pCookingSerializer, pCategory, result, pExperience, pCookingTime, pRecipeName, itemlike);
        }
    }

    private static void cooking(Consumer<FinishedRecipe> consumer, RecipeSerializer<? extends AbstractCookingRecipe> pCookingSerializer, RecipeCategory pCategory, ItemLike result, float pExperience, int pCookingTime, String pRecipeName, ItemLike itemlike) {
        SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)result, (float)pExperience, (int)pCookingTime, pCookingSerializer).m_126145_(ModRecipeProvider.m_176632_((ItemLike)result)).m_126132_(ModRecipeProvider.m_176602_((ItemLike)itemlike), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)itemlike)).m_126140_(consumer, new ResourceLocation("nukacraft", ModRecipeProvider.m_176632_((ItemLike)result) + pRecipeName + "_" + ModRecipeProvider.m_176632_((ItemLike)itemlike)));
    }

    @NotNull
    private static String getHasName(TagKey<Item> ingredient) {
        return "has" + ModRecipeProvider.name(ingredient);
    }

    @NotNull
    private static String name(TagKey<Item> ingredient) {
        return ingredient.f_203868_().m_135815_();
    }
}

