/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.datagen.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public abstract class WeaponAttributesProvider
implements DataProvider {
    public static final String ANCHOR = "bettercombat:anchor";
    public static final String AXE = "bettercombat:axe";
    public static final String BATTLESTAFF = "bettercombat:battlestaff";
    public static final String BOW_TWO_HANDED_HEAVY = "bettercombat:bow_two_handed_heavy";
    public static final String BOW_TWO_HANDED_LIGHT = "bettercombat:bow_two_handed_light";
    public static final String CLAW = "bettercombat:claw";
    public static final String CLAYMORE = "bettercombat:claymore";
    public static final String CORAL_BLADE = "bettercombat:coral_blade";
    public static final String CROSSBOW_TWO_HANDED_HEAVY = "bettercombat:crossbow_two_handed_heavy";
    public static final String CROSSBOW_TWO_HANDED_LIGHT = "bettercombat:crossbow_two_handed_light";
    public static final String CUTLASS = "bettercombat:cutlass";
    public static final String DAGGER = "bettercombat:dagger";
    public static final String DOUBLE_AXE = "bettercombat:double_axe";
    public static final String FIST = "bettercombat:fist";
    public static final String GLAIVE = "bettercombat:glaive";
    public static final String HALBERD = "bettercombat:halberd";
    public static final String HAMMER = "bettercombat:hammer";
    public static final String HEAVY_AXE = "bettercombat:heavy_axe";
    public static final String KATANA = "bettercombat:katana";
    public static final String LANCE = "bettercombat:lance";
    public static final String MACE = "bettercombat:mace";
    public static final String PICKAXE = "bettercombat:pickaxe";
    public static final String RAPIER = "bettercombat:rapier";
    public static final String SCYTHE = "bettercombat:scythe";
    public static final String SICKLE = "bettercombat:sickle";
    public static final String SOUL_KNIFE = "bettercombat:soul_knife";
    public static final String SPEAR = "bettercombat:spear";
    public static final String STAFF = "bettercombat:staff";
    public static final String SWORD = "bettercombat:sword";
    public static final String TRIDENT = "bettercombat:trident";
    public static final String TWIN_BLADE = "bettercombat:twin_blade";
    public static final String WAND = "bettercombat:wand";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final PackOutput.PathProvider pathProvider;
    private final Map<ResourceLocation, WeaponAttributeTemplate> data = new HashMap<ResourceLocation, WeaponAttributeTemplate>();

    public WeaponAttributesProvider(PackOutput output) {
        this.pathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "weapon_attributes");
    }

    public String m_6055_() {
        return "Weapon Attributes";
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        return this.saveData(cache, this.data);
    }

    protected void weaponAttribute(String parent, RegistryObject<Item> ... items) {
        for (RegistryObject<Item> item : items) {
            this.data.put(this.modLoc(this.name((Item)item.get())), new WeaponAttributeTemplate(parent));
        }
    }

    protected ResourceLocation modLoc(String name) {
        return new ResourceLocation("nukacraft", name);
    }

    protected String name(Item item) {
        return this.key(item).m_135815_();
    }

    protected ResourceLocation key(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    private CompletableFuture<?> saveData(CachedOutput cache, Map<ResourceLocation, WeaponAttributeTemplate> data) {
        return CompletableFuture.allOf((CompletableFuture[])data.entrySet().stream().map(entry -> {
            Path path = this.pathProvider.m_245731_((ResourceLocation)entry.getKey());
            JsonElement json = GSON.toJsonTree(entry.getValue());
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    private record WeaponAttributeTemplate(String parent) {
    }
}

