/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.datagen.regestry;

import com.nukateam.ntgl.common.foundation.crafting.WorkbenchIngredient;
import com.nukateam.ntgl.common.foundation.crafting.WorkbenchRecipeBuilder;
import com.nukateam.nukacraft.common.datagen.providers.ModRecipeProvider;
import com.nukateam.nukacraft.common.datagen.regestry.TagsRegistry;
import com.nukateam.nukacraft.common.registery.blocks.ModBlocks;
import com.nukateam.nukacraft.common.registery.items.ModFood;
import com.nukateam.nukacraft.common.registery.items.ModItems;
import com.nukateam.nukacraft.common.registery.items.ModWeapons;
import com.nukateam.nukacraft.common.registery.items.NukaArmorItems;
import com.nukateam.nukacraft.common.registery.items.WeaponAttachments;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class RecipeRegistry
extends ModRecipeProvider {
    public static final String HAS_WEAPON_PARTS = "has_weapon_parts";

    public RecipeRegistry(PackOutput pOutput) {
        super(pOutput);
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> writer) {
        RecipeRegistry.buildOreRecipes(writer, List.of((Block)ModBlocks.LEAD_ORE.get(), (Block)ModBlocks.DEEPSLATE_LEAD_ORE.get()), (Block)ModBlocks.LEAD_BLOCK.get(), (Block)ModBlocks.RAW_LEAD_BLOCK.get(), (ItemLike)ModItems.RAW_LEAD.get(), (ItemLike)ModItems.LEAD_INGOT.get(), (ItemLike)ModItems.LEAD_NUGGET.get());
        RecipeRegistry.buildOreRecipes(writer, List.of((Block)ModBlocks.ALUMINIUM_ORE.get(), (Block)ModBlocks.DEEPSLATE_ALUMINIUM_ORE.get()), (Block)ModBlocks.ALUMINIUM_BLOCK.get(), (Block)ModBlocks.RAW_ALUMINIUM_BLOCK.get(), (ItemLike)ModItems.RAW_ALUMINIUM.get(), (ItemLike)ModItems.ALUMINIUM_INGOT.get(), (ItemLike)ModItems.ALUMINIUM_NUGGET.get());
        RecipeRegistry.buildOreRecipes(writer, List.of((Block)ModBlocks.SILVER_ORE.get(), (Block)ModBlocks.DEEPSLATE_SILVER_ORE.get()), (Block)ModBlocks.SILVER_BLOCK.get(), (Block)ModBlocks.RAW_SILVER_BLOCK.get(), (ItemLike)ModItems.RAW_SILVER.get(), (ItemLike)ModItems.SILVER_INGOT.get(), (ItemLike)ModItems.SILVER_NUGGET.get());
        RecipeRegistry.buildOreRecipes(writer, List.of((Block)ModBlocks.BLACK_TITAN_ORE.get(), (Block)ModBlocks.DEEPSLATE_BLACK_TITAN_ORE.get()), (Block)ModBlocks.BLACK_TITAN_BLOCK.get(), (Block)ModBlocks.RAW_BLACK_TITAN_BLOCK.get(), (ItemLike)ModItems.RAW_BLACK_TITAN.get(), (ItemLike)ModItems.BLACK_TITAN_INGOT.get(), (ItemLike)ModItems.BLACK_TITAN_NUGGET.get());
        RecipeRegistry.buildOreRecipes(writer, List.of((Block)ModBlocks.URANIUM_ORE.get(), (Block)ModBlocks.DEEPSLATE_URANIUM_ORE.get()), (Block)ModBlocks.URANIUM_BLOCK.get(), (Block)ModBlocks.RAW_URANIUM_BLOCK.get(), (ItemLike)ModItems.RAW_URANIUM.get(), (ItemLike)ModItems.URANIUM_INGOT.get(), (ItemLike)ModItems.URANIUM_NUGGET.get());
        RecipeRegistry.buildGemRecipes(writer, List.of((ItemLike)ModBlocks.ULTRACITE_ORE.get(), (ItemLike)ModBlocks.DEEPSLATE_ULTRACITE_ORE.get()), (Block)ModBlocks.ULTRACITE_BLOCK.get(), (ItemLike)ModItems.ULTRACITE.get());
        RecipeRegistry.buildIngotRecipes(writer, (Block)ModBlocks.STEEL_BLOCK.get(), (ItemLike)ModItems.STEEL_INGOT.get(), (ItemLike)ModItems.STEEL_NUGGET.get());
        RecipeRegistry.buildIngotRecipes(writer, (Block)ModBlocks.SATURNITE_BLOCK.get(), (ItemLike)ModItems.SATURNITE_INGOT.get(), (ItemLike)ModItems.SATURNITE_NUGGET.get());
        RecipeRegistry.oreCooking(writer, (ItemLike)Items.f_42692_, List.of((ItemLike)ModBlocks.QUARTS_ORE.get(), (ItemLike)ModBlocks.DEEPSLATE_QUARTS_ORE.get()), 0.2f, 200);
        RecipeRegistry.toAndFromBlockSmall(writer, (ItemLike)ModBlocks.SCRAP_BLOCK.get(), (ItemLike)ModItems.SCRAP.get());
        RecipeRegistry.armor(writer, (TagKey<Item>)ItemTags.f_13168_, NukaArmorItems.WOODEN_SET);
        RecipeRegistry.armor(writer, (ItemLike)ModItems.LEATHER_HARD.get(), NukaArmorItems.LEATHER_SET);
        RecipeRegistry.armor(writer, (ItemLike)ModItems.SCRAP.get(), NukaArmorItems.RAIDER_SET);
        RecipeRegistry.armor(writer, (ItemLike)ModItems.STEEL_INGOT.get(), NukaArmorItems.METAL_SET);
        RecipeRegistry.armor(writer, (ItemLike)ModItems.COMPOSITE.get(), NukaArmorItems.COMBAT_SET);
        RecipeRegistry.foodCooking(writer, (ItemLike)ModFood.BRAHMIN_FRIES.get(), (ItemLike)ModFood.BRAHMIN_TESTICULES.get(), 0.35f, 200);
        RecipeRegistry.foodCooking(writer, (ItemLike)ModFood.COOKED_BLOATFLY_MEAT.get(), (ItemLike)ModFood.RAW_BLOATFLY_MEAT.get(), 0.35f, 200);
        RecipeRegistry.foodCooking(writer, (ItemLike)ModFood.COOKED_MOLERAT_MEAT.get(), (ItemLike)ModFood.RAW_MOLERAT_MEAT.get(), 0.35f, 200);
        RecipeRegistry.foodCooking(writer, (ItemLike)ModFood.COOKED_RADROACH_MEAT.get(), (ItemLike)ModFood.RAW_RADROACH_MEAT.get(), 0.35f, 200);
        RecipeRegistry.foodCooking(writer, (ItemLike)ModFood.COOKED_MIRELURK_MEAT.get(), (ItemLike)ModFood.RAW_MIRELURK_MEAT.get(), 0.35f, 200);
        RecipeRegistry.foodCooking(writer, (ItemLike)ModFood.COOKED_DEADCLAW_MEAT.get(), (ItemLike)ModFood.RAW_DEADCLAW_MEAT.get(), 0.5f, 200);
        this.weaponCrafts(writer);
    }

    protected void weaponCrafts(Consumer<FinishedRecipe> consumer) {
        RecipeRegistry.genMelee(consumer);
        RecipeRegistry.genGuns(consumer);
        RecipeRegistry.genAmmo(consumer);
        RecipeRegistry.genAttachments(consumer);
        RecipeRegistry.genGrenades(consumer);
    }

    private static void genAttachments(Consumer<FinishedRecipe> consumer) {
        TagKey<Item> steelIngot = TagsRegistry.forgeItemTag("ingots/steel");
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_COLLIMATOR_SIGHT.get(), WorkbenchIngredient.of((TagKey)Tags.Items.NUGGETS_IRON, (int)2), WorkbenchIngredient.of((TagKey)Tags.Items.GLASS, (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_HOLOGRAPHIC_SIGHT.get(), WorkbenchIngredient.of((TagKey)Tags.Items.NUGGETS_IRON, (int)3), WorkbenchIngredient.of((TagKey)Tags.Items.GLASS, (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_HUNTING_OPTICS.get(), WorkbenchIngredient.of((TagKey)Tags.Items.NUGGETS_IRON, (int)4), WorkbenchIngredient.of((TagKey)Tags.Items.GLASS, (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_IRON_SIGHT.get(), WorkbenchIngredient.of((TagKey)Tags.Items.NUGGETS_IRON, (int)1), WorkbenchIngredient.of((TagKey)Tags.Items.GLASS, (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_SCOUT_SIGHT.get(), WorkbenchIngredient.of((TagKey)Tags.Items.NUGGETS_IRON, (int)3), WorkbenchIngredient.of((TagKey)Tags.Items.GLASS, (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_SILENCER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2), WorkbenchIngredient.of(steelIngot, (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_COMPENSATOR.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2), WorkbenchIngredient.of(steelIngot, (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_FLAME_HIDER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2), WorkbenchIngredient.of(steelIngot, (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_HEAVY_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3), WorkbenchIngredient.of(steelIngot, (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_LONG_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3), WorkbenchIngredient.of(steelIngot, (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_SPECIALISED_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2), WorkbenchIngredient.of(steelIngot, (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_TACTICAL_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2), WorkbenchIngredient.of(steelIngot, (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_WEIGHTED_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3), WorkbenchIngredient.of(steelIngot, (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_EXTENDED_MAGAZINE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2), WorkbenchIngredient.of(steelIngot, (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_HUGE_MAGAZINE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3), WorkbenchIngredient.of(steelIngot, (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_DRUM_MAGAZINE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PISTOL_QUICK_MAGAZINE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3), WorkbenchIngredient.of(steelIngot, (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PIPE_TACTICAL_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)1), WorkbenchIngredient.of(steelIngot, (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PIPE_PISTOL_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)1), WorkbenchIngredient.of(steelIngot, (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PIPE_LONG_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2), WorkbenchIngredient.of(steelIngot, (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PIPE_CARBINE_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3), WorkbenchIngredient.of(steelIngot, (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PIPE_SILENCER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2), WorkbenchIngredient.of(steelIngot, (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PIPE_COMPENSATOR.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2), WorkbenchIngredient.of(steelIngot, (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PIPE_FLAME_HIDER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)1), WorkbenchIngredient.of(steelIngot, (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PIPE_HEAVY_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3), WorkbenchIngredient.of(steelIngot, (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PIPE_LONG_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3), WorkbenchIngredient.of(steelIngot, (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.MINIGUN_LONG_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.MINIGUN_SHREDDER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3), WorkbenchIngredient.of(steelIngot, (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.MINIGUN_SIX_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.MINIGUN_SHREDDER_SATURNITE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.MINIGUN_SHREDDER_HEAT.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.MINIGUN_EXTEND_MAG.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.MINIGUN_DRUM_MAG.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.GATLING_LASER_TRIPLE_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.GATLING_LASER_EIGHT_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.GATLING_LASER_INDUSTRIAL_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)6), WorkbenchIngredient.of(steelIngot, (int)5), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)4));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.GATLING_LASER_BEAM_SPLITTER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.GATLING_LASER_BEAM_FOCUSER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.GATLING_LASER_CORRECTION_LENS.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PUMP_SHIELD_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PUMP_SILENCER_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PUMP_LONG_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)6), WorkbenchIngredient.of(steelIngot, (int)5));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PUMP_TACTICAL_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3), WorkbenchIngredient.of(steelIngot, (int)2));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PUMP_PISTOL_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2), WorkbenchIngredient.of(steelIngot, (int)1));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PUMP_LONG_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.PUMP_WEIGHTED_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.TESLA_TACTICAL_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.TESLA_AUTO_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.TESLA_CHARGING_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.TESLA_RAIL_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)6), WorkbenchIngredient.of(steelIngot, (int)5));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.TESLA_OVERHEAT_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)6), WorkbenchIngredient.of(steelIngot, (int)5));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.LASER_SNIPER_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)6), WorkbenchIngredient.of(steelIngot, (int)5));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.LASER_AUTO_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)6), WorkbenchIngredient.of(steelIngot, (int)5));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.LASER_PROTECTRON_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)7), WorkbenchIngredient.of(steelIngot, (int)6));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.LASER_TACTICAL_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.LASER_LONG_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.LASER_WEIGHTED_GRIP.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)6), WorkbenchIngredient.of(steelIngot, (int)5));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.LASER_ALL_VISION.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.FLAMER_LONG_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.FLAMER_COMPRESS_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)6), WorkbenchIngredient.of(steelIngot, (int)5));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.FLAMER_EVAPORATIVE_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)6), WorkbenchIngredient.of(steelIngot, (int)5));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.FLAMER_HEAVY_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)7), WorkbenchIngredient.of(steelIngot, (int)6));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.BROADSIDER_MAGAZINE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.BROADSIDER_BARREL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)6), WorkbenchIngredient.of(steelIngot, (int)5));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.MISSILE_MAGAZINE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.MISSILE_DRUM.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)6), WorkbenchIngredient.of(steelIngot, (int)5));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.BARREL_EXTENDER_MISSILE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.STOCK_BLADE_MISSILE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)3));
        RecipeRegistry.weapon(consumer, (Item)WeaponAttachments.SHIELD.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)4));
    }

    private static void genMelee(Consumer<FinishedRecipe> consumer) {
        TagKey<Item> steelIngot = TagsRegistry.forgeItemTag("ingots/steel");
        Item stick = Items.f_42398_;
        TagKey planks = ItemTags.f_13168_;
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.CLEAVER.get(), WorkbenchIngredient.of(steelIngot, (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.SHIV.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)1), WorkbenchIngredient.of((ItemLike)stick, (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.ROLLPIN.get(), WorkbenchIngredient.of((TagKey)planks, (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.CANE.get(), WorkbenchIngredient.of((ItemLike)stick, (int)4), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.TEXTILE.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.BASEBALL_BAT.get(), WorkbenchIngredient.of((TagKey)planks, (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.HAMMER.get(), WorkbenchIngredient.of(steelIngot, (int)2), WorkbenchIngredient.of((ItemLike)stick, (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.POOLCUE.get(), WorkbenchIngredient.of((TagKey)planks, (int)2));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.KOMI.get(), WorkbenchIngredient.of((TagKey)planks, (int)1), WorkbenchIngredient.of((ItemLike)stick, (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.COMBAT_KNIFE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.STEEL_INGOT.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.COSMIC_KNIFE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SATURNITE_INGOT.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.TEXTILE.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.COMBAT_PIPE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.CROWBAR.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.STEEL_INGOT.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.GOLF_DRIVER.get(), WorkbenchIngredient.of((TagKey)planks, (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.STEEL_INGOT.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.HATCHET.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.STEEL_INGOT.get()), (int)1), WorkbenchIngredient.of((ItemLike)stick, (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.FIRE_AXE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.STEEL_INGOT.get()), (int)3), WorkbenchIngredient.of((ItemLike)stick, (int)2));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.MACHETE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.STEEL_INGOT.get()), (int)2), WorkbenchIngredient.of((ItemLike)stick, (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.KATANA.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.STEEL_INGOT.get()), (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.TEXTILE.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.PIPE_WRENCH.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.STEEL_INGOT.get()), (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)1));
    }

    private static void genGuns(Consumer<FinishedRecipe> consumer) {
        TagKey<Item> steelIngot = TagsRegistry.forgeItemTag("ingots/steel");
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.PISTOL10MM.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)2), WorkbenchIngredient.of(steelIngot, (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.PIPE_PISTOL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.ADHESIVE.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.CLASSIC10MM.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)3), WorkbenchIngredient.of(steelIngot, (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SPRINGS.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.SCOUT10MM.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)4), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.ALUMINIUM_INGOT.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.PIPE_REVOLVER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)5), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.ADHESIVE.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.LASER_PISTOL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)1), WorkbenchIngredient.of(steelIngot, (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.GLOWING_RESIN.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.CLASSIC_LASER_PISTOL.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.ALUMINIUM_INGOT.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.GLOWING_RESIN.get()), (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.SHOTGUN.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)5), WorkbenchIngredient.of(steelIngot, (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.LASER_RIFLE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.ALUMINIUM_INGOT.get()), (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.TESLA_RIFLE.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)1), WorkbenchIngredient.of(steelIngot, (int)4), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.ALUMINIUM_INGOT.get()), (int)4), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.COPPER_WIRE.get()), (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)2));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.POWDERGUN.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)6), WorkbenchIngredient.of((TagKey)ItemTags.f_13168_, (int)6), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)4));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.FATMAN.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)8), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)4), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.MINIGUN.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)10), WorkbenchIngredient.of(steelIngot, (int)4), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SPRINGS.get()), (int)6));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.GATLING_LASER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)8), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.CIRCUIT.get()), (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModWeapons.FUSION_CELL.get()), (int)10), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)10));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.BROADSIDER.get(), WorkbenchIngredient.of(steelIngot, (int)10), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)4));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.MISSILE_LAUNCHER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)8), WorkbenchIngredient.of(steelIngot, (int)3), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCREWS.get()), (int)5));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.FLAMER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get()), (int)4), WorkbenchIngredient.of(steelIngot, (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.OIL.get()), (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.HANDMADE_FLAMER.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)6), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.OIL.get()), (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.ADHESIVE.get()), (int)2));
    }

    private static void genAmmo(Consumer<FinishedRecipe> consumer) {
        TagKey<Item> leadIngot = TagsRegistry.forgeItemTag("ingots/lead");
        TagKey<Item> steelIngot = TagsRegistry.forgeItemTag("ingots/steel");
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.ROUND10MM.get(), 64, WorkbenchIngredient.of((ItemLike)Items.f_151052_, (int)2), WorkbenchIngredient.of(leadIngot, (int)4), WorkbenchIngredient.of((TagKey)Tags.Items.GUNPOWDER, (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.ROUND10MM_PIERCING.get(), 64, WorkbenchIngredient.of((ItemLike)Items.f_151052_, (int)2), WorkbenchIngredient.of(steelIngot, (int)2), WorkbenchIngredient.of(leadIngot, (int)4), WorkbenchIngredient.of((TagKey)Tags.Items.GUNPOWDER, (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.ROUND38.get(), 64, WorkbenchIngredient.of((ItemLike)Items.f_151052_, (int)2), WorkbenchIngredient.of(leadIngot, (int)4), WorkbenchIngredient.of((TagKey)Tags.Items.GUNPOWDER, (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.ROUND38_PIERCING.get(), 64, WorkbenchIngredient.of((ItemLike)Items.f_151052_, (int)2), WorkbenchIngredient.of(steelIngot, (int)2), WorkbenchIngredient.of(leadIngot, (int)4), WorkbenchIngredient.of((TagKey)Tags.Items.GUNPOWDER, (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.ROUND45.get(), 64, WorkbenchIngredient.of((ItemLike)Items.f_151052_, (int)2), WorkbenchIngredient.of(leadIngot, (int)4), WorkbenchIngredient.of((TagKey)Tags.Items.GUNPOWDER, (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.ROUND45_PIERCING.get(), 64, WorkbenchIngredient.of((ItemLike)Items.f_151052_, (int)2), WorkbenchIngredient.of(steelIngot, (int)2), WorkbenchIngredient.of(leadIngot, (int)4), WorkbenchIngredient.of((TagKey)Tags.Items.GUNPOWDER, (int)3));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.ROUND5MM.get(), 64, WorkbenchIngredient.of((ItemLike)Items.f_151052_, (int)4), WorkbenchIngredient.of(leadIngot, (int)8), WorkbenchIngredient.of((TagKey)Tags.Items.GUNPOWDER, (int)6));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.ROUND5MM_PIERCING.get(), 64, WorkbenchIngredient.of((ItemLike)Items.f_151052_, (int)4), WorkbenchIngredient.of(steelIngot, (int)4), WorkbenchIngredient.of(leadIngot, (int)8), WorkbenchIngredient.of((TagKey)Tags.Items.GUNPOWDER, (int)6));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.SHOT_SHELL.get(), 64, WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.PLASTIC.get()), (int)2), WorkbenchIngredient.of(leadIngot, (int)8), WorkbenchIngredient.of((TagKey)Tags.Items.GUNPOWDER, (int)6));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.MISSILE.get(), 1, WorkbenchIngredient.of(steelIngot, (int)4), WorkbenchIngredient.of((TagKey)Tags.Items.GUNPOWDER, (int)8));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.MISSILE_MINI.get(), 1, WorkbenchIngredient.of(steelIngot, (int)2), WorkbenchIngredient.of((TagKey)Tags.Items.GUNPOWDER, (int)4));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.CANNONBALL.get(), 1, WorkbenchIngredient.of(leadIngot, (int)8));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.STEEL_BALLS.get(), 10, WorkbenchIngredient.of(leadIngot, (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.STEEL_BALL.get(), 10, WorkbenchIngredient.of(leadIngot, (int)1));
    }

    private static void genGrenades(Consumer<FinishedRecipe> consumer) {
        TagKey gunpowder = Tags.Items.GUNPOWDER;
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.GRENADE.get(), WorkbenchIngredient.of((TagKey)gunpowder, (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.GRENADE_FIRE.get(), WorkbenchIngredient.of((TagKey)gunpowder, (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.OIL.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.SCRAP.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.BASEBALL_GRENADE.get(), WorkbenchIngredient.of((TagKey)gunpowder, (int)2), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.TEXTILE.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.MOLOTOV.get(), 2, WorkbenchIngredient.of((ItemLike)((ItemLike)ModWeapons.FUEL.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.OIL.get()), (int)1), WorkbenchIngredient.of((TagKey)Tags.Items.GLASS, (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.TEXTILE.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.MOLOTOV_COLA.get(), WorkbenchIngredient.of((ItemLike)((ItemLike)ModFood.NUKA_COLA.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModWeapons.FUEL.get()), (int)1), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.OIL.get()), (int)1));
        RecipeRegistry.weapon(consumer, (Item)ModWeapons.DYNAMITE_STICK.get(), WorkbenchIngredient.of((TagKey)gunpowder, (int)4), WorkbenchIngredient.of((ItemLike)((ItemLike)ModItems.TEXTILE.get()), (int)5));
    }

    private static void weapon(Consumer<FinishedRecipe> consumer, Item result, WorkbenchIngredient ... ingredients) {
        RecipeRegistry.weapon(consumer, result, 1, ingredients);
    }

    private static void weapon(Consumer<FinishedRecipe> consumer, Item result, int amount, WorkbenchIngredient ... ingredients) {
        WorkbenchRecipeBuilder recipe = WorkbenchRecipeBuilder.crafting((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result, (int)amount).addCriterion(HAS_WEAPON_PARTS, (CriterionTriggerInstance)RecipeRegistry.m_125977_((ItemLike)((ItemLike)ModItems.WEAPON_PARTS.get())));
        for (WorkbenchIngredient ingredient : ingredients) {
            recipe.addIngredient(ingredient);
        }
        recipe.build(consumer);
    }
}

