/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.datagen.regestry;

import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.nukacraft.common.registery.blocks.ModBlocks;
import com.nukateam.nukacraft.common.registery.items.ModItems;
import com.nukateam.nukacraft.common.registery.items.ModWeapons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TagsRegistry {
    public static final HashMap<Block, ArrayList<TagKey<Block>>> BLOCK_TAGS = new HashMap();
    public static final HashMap<Item, ArrayList<TagKey<Item>>> ITEM_TAGS = new HashMap();
    public static final String INGOT_TAG = "ingots/";
    public static final String NUGGET_TAG = "nuggets/";
    public static final String RAW_MATERIALS_TAG = "raw_materials/";
    public static String ORE_ALUMINIUM = "ores/aluminium";
    public static String ORE_LEAD = "ores/lead";
    public static String ORE_BLACK_TITAN = "ores/black_titan";
    public static String ORE_SILVER = "ores/silver";
    public static String ORE_QUARTZ = "ores/quartz";
    public static String ORE_URANIUM = "ores/uranium";
    public static String ORE_ULTRACITE = "ores/ultracite";
    public static String IN_DEEPSLATE = "ores_in_ground/deepslate";
    public static String IN_STONE = "ores_in_ground/stone";
    public static String GLASS = "glass";
    public static TagKey<Block>[] ORE = new TagKey[]{BlockTags.f_144282_, Tags.Blocks.ORES_IN_GROUND_STONE};
    public static TagKey<Block>[] DEEPSLATE_ORE = new TagKey[]{BlockTags.f_144282_, Tags.Blocks.ORES_IN_GROUND_DEEPSLATE};
    public static TagKey<Block>[] NEEDS_STONE_PICKAXE = new TagKey[]{BlockTags.f_144282_, BlockTags.f_144286_};
    public static TagKey<Block>[] NEEDS_IRON_PICKAXE = new TagKey[]{BlockTags.f_144282_, BlockTags.f_144285_};
    public static TagKey<Block>[] NEEDS_DIAMOND_PICKAXE = new TagKey[]{BlockTags.f_144282_, BlockTags.f_144284_};
    public static TagKey<Block>[] LOGS = new TagKey[]{BlockTags.f_13106_, BlockTags.f_13105_};
    public static TagKey<Item>[] LOGS_ITEM = new TagKey[]{ItemTags.f_13182_, ItemTags.f_13181_};

    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return TagsRegistry.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return TagsRegistry.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return TagsRegistry.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return TagsRegistry.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static void setupBlocks() {
        TagsRegistry.addTags((Block)ModBlocks.LEAD_ORE.get(), ORE, new TagKey[]{BlockTags.f_144286_});
        TagsRegistry.addTags((Block)ModBlocks.DEEPSLATE_LEAD_ORE.get(), DEEPSLATE_ORE, new TagKey[]{BlockTags.f_144286_});
        TagsRegistry.addTags((Block)ModBlocks.ALUMINIUM_ORE.get(), ORE, new TagKey[]{BlockTags.f_144285_});
        TagsRegistry.addTags((Block)ModBlocks.DEEPSLATE_ALUMINIUM_ORE.get(), DEEPSLATE_ORE, new TagKey[]{BlockTags.f_144285_});
        TagsRegistry.addTags((Block)ModBlocks.SILVER_ORE.get(), ORE, new TagKey[]{BlockTags.f_144285_});
        TagsRegistry.addTags((Block)ModBlocks.DEEPSLATE_SILVER_ORE.get(), DEEPSLATE_ORE, new TagKey[]{BlockTags.f_144285_});
        TagsRegistry.addTags((Block)ModBlocks.QUARTS_ORE.get(), ORE, new TagKey[]{BlockTags.f_144285_});
        TagsRegistry.addTags((Block)ModBlocks.DEEPSLATE_QUARTS_ORE.get(), DEEPSLATE_ORE, new TagKey[]{BlockTags.f_144285_});
        TagsRegistry.addTags((Block)ModBlocks.BLACK_TITAN_ORE.get(), ORE, new TagKey[]{BlockTags.f_144284_});
        TagsRegistry.addTags((Block)ModBlocks.DEEPSLATE_BLACK_TITAN_ORE.get(), DEEPSLATE_ORE, new TagKey[]{BlockTags.f_144284_});
        TagsRegistry.addTags((Block)ModBlocks.URANIUM_ORE.get(), ORE, new TagKey[]{BlockTags.f_144284_});
        TagsRegistry.addTags((Block)ModBlocks.DEEPSLATE_URANIUM_ORE.get(), DEEPSLATE_ORE, new TagKey[]{BlockTags.f_144284_});
        TagsRegistry.addTags((Block)ModBlocks.ULTRACITE_ORE.get(), ORE, new TagKey[]{BlockTags.f_144284_});
        TagsRegistry.addTags((Block)ModBlocks.DEEPSLATE_ULTRACITE_ORE.get(), DEEPSLATE_ORE, new TagKey[]{BlockTags.f_144284_});
        TagsRegistry.addTags((Block)ModBlocks.ULTRACITE_TUFF_ORE.get(), BlockTags.f_144282_, BlockTags.f_144284_);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.LEAD_ORE.get(), ORE_LEAD, IN_STONE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.DEEPSLATE_LEAD_ORE.get(), ORE_LEAD, IN_DEEPSLATE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.ALUMINIUM_ORE.get(), ORE_ALUMINIUM, IN_STONE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.DEEPSLATE_ALUMINIUM_ORE.get(), ORE_ALUMINIUM, IN_DEEPSLATE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.SILVER_ORE.get(), ORE_SILVER, IN_STONE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.DEEPSLATE_SILVER_ORE.get(), ORE_SILVER, IN_DEEPSLATE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.QUARTS_ORE.get(), ORE_QUARTZ, IN_STONE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.DEEPSLATE_QUARTS_ORE.get(), ORE_QUARTZ, IN_DEEPSLATE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.BLACK_TITAN_ORE.get(), ORE_BLACK_TITAN, IN_STONE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.DEEPSLATE_BLACK_TITAN_ORE.get(), ORE_BLACK_TITAN, IN_DEEPSLATE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.URANIUM_ORE.get(), ORE_URANIUM, IN_STONE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.DEEPSLATE_URANIUM_ORE.get(), ORE_URANIUM, IN_DEEPSLATE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.ULTRACITE_ORE.get(), ORE_ULTRACITE, IN_STONE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.DEEPSLATE_ULTRACITE_ORE.get(), ORE_ULTRACITE, IN_DEEPSLATE);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.ULTRACITE_TUFF_ORE.get(), ORE_ULTRACITE);
        TagsRegistry.addTags((Block)ModBlocks.WHITEBRICKS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.WHITE_BRICKS_SLAB.get(), NEEDS_STONE_PICKAXE, new TagKey[]{BlockTags.f_13031_});
        TagsRegistry.addTags((Block)ModBlocks.WHITEBRICKS_STAIRS.get(), NEEDS_STONE_PICKAXE, new TagKey[]{BlockTags.f_13030_});
        TagsRegistry.addTags((Block)ModBlocks.MOSS_WHITE_BRICKS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.SMOOTH_BRICKS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.EXPLOSIVE_BARREL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.ASHSTONE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.SCRAP_BLOCK.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.SLICED_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.BLUE_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.BLACK_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.CYAN_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.GREEN_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.MAGENTA_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.PURPLE_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.RED_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.BROWN_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.WHITE_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.ORANGE_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.LIGHT_BLUE_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.YELLOW_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.LIME_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.PINK_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.DARK_GRAY_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.GRAY_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.VAULT_TECH_TILE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.SCRAP_BLOCK.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.ASHSTONE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.VTARMOR.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.BLACKSTEEL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.STEELFLOOR.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.REDSTEEL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.YELLOW_STEEL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.RUSTREDSTEEL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.RUSTEDGREENSTEEL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.PLATEDGREENSTEEL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.GREENSTEEL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.WHITE_STEEL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.BLUESTEEL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.SMOOTH_BRICKS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.CRACKED_WHITE_BRICKS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.WHITEBRICKS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.MOSS_WHITE_BRICKS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.DANGER_FLOOR.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.VT_LATTICE.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.POWERBLOCK.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.BLACKSTEEL2.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.RED_ROCKET_PANEL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.CRKBRICK_PIPE.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.CRKBRICK_VENT.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.BLACKSTEEL2.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.WHITE_STEEL_COLUMN.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.YELLOWSTEEL_COLUMN.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.RED_STEEL_SLAB.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.GREEN_STEEL_SLAB.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.WHITE_STEEL_SLAB.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.BLACK_STEEL_SLAB.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.WHITE_BRICKS_SLAB.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.BLACKSTEEL_STAIRS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.WHITEBRICKS_STAIRS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.CRACKED_WHITE_BRICKS_STAIRS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.MOSS_WHITE_BRICKS_STAIRS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.STEEL_BARS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.RUSTY_STEEL_BARS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.SHELTERBARS.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.ULTRACITE_MAGMA.get(), NEEDS_IRON_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.WORKBENCH.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.WORKBENCH_SIDE.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.NUKACOLA_VENDING.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.NUKACOLA_VENDING_TOP.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.NUKACOLA_FRIDGE_MACHINE.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.NUKACOLA_FRIDGE_TOP.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.PA_STATION.get(), NEEDS_IRON_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.NUC_STATION_CONTROL.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.NUC_STATION_BLOCK.get(), NEEDS_STONE_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.SERVER_BLOCK.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.BARREL.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.EXPLOSIVE_BARREL.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.CRYOCAPSULE.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.CRYO_CAPSULE_ACT.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.OPENCRYOCAPSULE.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.RUSTY_PIPE.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.VENT.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.TERMINAL.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.RADIO_TERMINAL.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.VAULT_BLASTDOOR.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.RUSTY_DOOR.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.CAGE_DOOR.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.STORE_DOOR.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.RED_DOOR.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.GREEN_DOOR.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.WHITE_DOOR.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.HARD_DOOR.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.STORAGE.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.MEDIC_STORAGE.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.VTCRATE.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.VTCRATE2.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.WOODCRATE.get(), BlockTags.f_144280_);
        TagsRegistry.addTags((Block)ModBlocks.SUPPORTWALL.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.SUPPORTWALLTOP.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.SUPPORTTOP.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.RUST_SUPPORT_WALL.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.RUST_SUPPORT_WALL_TOP.get(), BlockTags.f_144282_);
        TagsRegistry.addTags((Block)ModBlocks.MONORAIL.get(), NEEDS_IRON_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.POINTED_ULTRACITE_CRYSTALL.get(), NEEDS_IRON_PICKAXE);
        TagsRegistry.addTags((Block)ModBlocks.LANDMINE.get(), BlockTags.f_144283_);
        TagsRegistry.addTags((Block)ModBlocks.GARVELL.get(), BlockTags.f_144283_);
        TagsRegistry.addTags((Block)ModBlocks.ACID_DIRT.get(), BlockTags.f_144283_);
        TagsRegistry.addTags((Block)ModBlocks.ASH_DIRT.get(), BlockTags.f_144283_);
        TagsRegistry.addTags((Block)ModBlocks.SCORCHED_EARTH.get(), BlockTags.f_144283_);
        TagsRegistry.addTags((Block)ModBlocks.CRANBERRYWOOD.get(), LOGS);
        TagsRegistry.addTags((Block)ModBlocks.ASHWOOD.get(), LOGS);
        TagsRegistry.addTags((Block)ModBlocks.STRIPPED_ASHWOOD.get(), LOGS);
        TagsRegistry.addTags((Block)ModBlocks.CRANBERRY_LEAVES.get(), BlockTags.f_13035_);
        TagsRegistry.addTags((Block)ModBlocks.EVERGREEN_LEAVES.get(), BlockTags.f_13035_);
        TagsRegistry.addTags((Block)ModBlocks.RUSTY_LEAVES.get(), BlockTags.f_13035_);
        TagsRegistry.addTags((Block)ModBlocks.CRANBERRY_PLANKS.get(), BlockTags.f_13090_);
        TagsRegistry.addTags((Block)ModBlocks.DEADWOOD_PLANKS.get(), BlockTags.f_13090_);
        TagsRegistry.addTags((Block)ModBlocks.CRANBERRY_PLANKS_SLAB.get(), BlockTags.f_13097_);
        TagsRegistry.addTags((Block)ModBlocks.DEADWOOD_PLANKS_SLAB.get(), BlockTags.f_13097_);
        TagsRegistry.addTags((Block)ModBlocks.CRANBERRY_PLANKS_STAIRS.get(), BlockTags.f_13096_);
        TagsRegistry.addTags((Block)ModBlocks.DEADWOOD_PLANKS_STAIRS.get(), BlockTags.f_13096_);
        TagsRegistry.addBlockAndItem((Block)ModBlocks.ARMEDGLASS.get(), GLASS);
    }

    public static void setupItems() {
        TagsRegistry.addTags(((Block)ModBlocks.CRANBERRYWOOD.get()).m_5456_(), LOGS_ITEM);
        TagsRegistry.addTags(((Block)ModBlocks.ASHWOOD.get()).m_5456_(), LOGS_ITEM);
        TagsRegistry.addTags(((Block)ModBlocks.STRIPPED_ASHWOOD.get()).m_5456_(), LOGS_ITEM);
        TagsRegistry.addTags(((WeaponItem)ModWeapons.HATCHET.get()).m_5456_(), ItemTags.f_271207_);
        TagsRegistry.addTags(((WeaponItem)ModWeapons.FIRE_AXE.get()).m_5456_(), ItemTags.f_271207_);
        TagsRegistry.addTags(((Block)ModBlocks.WHITE_BRICKS_SLAB.get()).m_5456_(), ItemTags.f_13139_);
        TagsRegistry.addTags(((StairBlock)ModBlocks.WHITEBRICKS_STAIRS.get()).m_5456_(), ItemTags.f_13138_);
        TagsRegistry.addTags(((Block)ModBlocks.CRANBERRY_LEAVES.get()).m_5456_(), ItemTags.f_13143_);
        TagsRegistry.addTags(((Block)ModBlocks.EVERGREEN_LEAVES.get()).m_5456_().m_5456_(), ItemTags.f_13143_);
        TagsRegistry.addTags(((Block)ModBlocks.RUSTY_LEAVES.get()).m_5456_(), ItemTags.f_13143_);
        TagsRegistry.addTags(((RotatedPillarBlock)ModBlocks.CRANBERRY_PLANKS.get()).m_5456_(), ItemTags.f_13168_);
        TagsRegistry.addTags(((RotatedPillarBlock)ModBlocks.DEADWOOD_PLANKS.get()).m_5456_(), ItemTags.f_13168_);
        TagsRegistry.addTags(((Block)ModBlocks.CRANBERRY_PLANKS_STAIRS.get()).m_5456_(), ItemTags.f_13175_);
        TagsRegistry.addTags(((Block)ModBlocks.DEADWOOD_PLANKS_STAIRS.get()).m_5456_(), ItemTags.f_13175_);
        TagsRegistry.addTags(((Block)ModBlocks.CRANBERRY_PLANKS_STAIRS.get()).m_5456_(), ItemTags.f_13174_);
        TagsRegistry.addTags(((Block)ModBlocks.DEADWOOD_PLANKS_STAIRS.get()).m_5456_(), ItemTags.f_13174_);
        TagsRegistry.addTags(((Item)ModItems.ALUMINIUM_INGOT.get()).m_5456_(), TagsRegistry.forgeItemTag("ingots/aluminium"));
        TagsRegistry.addTags(((Item)ModItems.STEEL_INGOT.get()).m_5456_(), TagsRegistry.forgeItemTag("ingots/steel"));
        TagsRegistry.addTags(((Item)ModItems.BLACK_TITAN_INGOT.get()).m_5456_(), TagsRegistry.forgeItemTag("ingots/black_titan"));
        TagsRegistry.addTags(((Item)ModItems.SILVER_INGOT.get()).m_5456_(), TagsRegistry.forgeItemTag("ingots/silver"));
        TagsRegistry.addTags(((Item)ModItems.LEAD_INGOT.get()).m_5456_(), TagsRegistry.forgeItemTag("ingots/lead"));
        TagsRegistry.addTags(((Item)ModItems.URANIUM_INGOT.get()).m_5456_(), TagsRegistry.forgeItemTag("nuggets/uranium"));
        TagsRegistry.addTags(((Item)ModItems.ALUMINIUM_NUGGET.get()).m_5456_(), TagsRegistry.forgeItemTag("nuggets/aluminium"));
        TagsRegistry.addTags(((Item)ModItems.STEEL_NUGGET.get()).m_5456_(), TagsRegistry.forgeItemTag("nuggets/steel"));
        TagsRegistry.addTags(((Item)ModItems.BLACK_TITAN_NUGGET.get()).m_5456_(), TagsRegistry.forgeItemTag("nuggets/black_titan"));
        TagsRegistry.addTags(((Item)ModItems.SILVER_NUGGET.get()).m_5456_(), TagsRegistry.forgeItemTag("nuggets/silver"));
        TagsRegistry.addTags(((Item)ModItems.LEAD_NUGGET.get()).m_5456_(), TagsRegistry.forgeItemTag("nuggets/lead"));
        TagsRegistry.addTags(((Item)ModItems.RAW_ALUMINIUM.get()).m_5456_(), TagsRegistry.forgeItemTag("raw_materials/aluminium"));
        TagsRegistry.addTags(((Item)ModItems.RAW_BLACK_TITAN.get()).m_5456_(), TagsRegistry.forgeItemTag("raw_materials/black_titan"));
        TagsRegistry.addTags(((Item)ModItems.RAW_SILVER.get()).m_5456_(), TagsRegistry.forgeItemTag("raw_materials/silver"));
        TagsRegistry.addTags(((Item)ModItems.RAW_LEAD.get()).m_5456_(), TagsRegistry.forgeItemTag("raw_materials/lead"));
        TagsRegistry.addTags(((Item)ModItems.RAW_URANIUM.get()).m_5456_(), TagsRegistry.forgeItemTag("raw_materials/uranium"));
    }

    public static void addTags(Block block, TagKey<Block> ... tags) {
        ArrayList<TagKey<Block>> list = new ArrayList<TagKey<Block>>(List.of(tags));
        BLOCK_TAGS.put(block, list);
    }

    public static <T, Y> void put(HashMap<T, ArrayList<TagKey<T>>> map, T key, TagKey<T> tag) {
        ArrayList<TagKey<T>> list = map.getOrDefault(key, new ArrayList());
        list.add(tag);
        map.put(key, list);
    }

    public static void addBlockAndItem(Block block, String ... tags) {
        for (String tag : tags) {
            TagsRegistry.put(BLOCK_TAGS, block, TagsRegistry.forgeBlockTag(tag));
            TagsRegistry.put(ITEM_TAGS, block.m_5456_(), TagsRegistry.forgeItemTag(tag));
        }
    }

    public static void addTags(Block block, TagKey<Block>[] tags, TagKey<Block> ... tags2) {
        List<TagKey<Block>> result = Stream.concat(Arrays.stream(tags), Arrays.stream(tags2)).toList();
        ArrayList<TagKey<Block>> list = new ArrayList<TagKey<Block>>(result);
        BLOCK_TAGS.put(block, list);
    }

    public static void addTags(Item item, TagKey<Item> ... tags) {
        ArrayList<TagKey<Item>> list = new ArrayList<TagKey<Item>>(List.of(tags));
        ITEM_TAGS.put(item, list);
    }

    public static void addTags(Item item, TagKey<Item>[] tags, TagKey<Item> ... tags2) {
        List<TagKey<Item>> result = Stream.concat(Arrays.stream(tags), Arrays.stream(tags2)).toList();
        ArrayList<TagKey<Item>> list = new ArrayList<TagKey<Item>>(result);
        ITEM_TAGS.put(item, list);
    }

    public static ArrayList<TagKey<Block>> getTags(Block block) {
        return BLOCK_TAGS.get(block);
    }

    public static ArrayList<TagKey<Item>> getTags(Item item) {
        return ITEM_TAGS.get(item);
    }
}

