/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.events;

import com.nukateam.nukacraft.common.registery.items.ModWeapons;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nukacraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).m_32055_().m_41720_() == ModWeapons.MININUKE.get()) {
            CompoundTag persistentData = itemEntity.getPersistentData();
            persistentData.m_128350_("initialHeight", (float)itemEntity.m_20186_());
            MinecraftForge.EVENT_BUS.addListener(worldTickEvent -> {
                if (worldTickEvent.phase == TickEvent.Phase.END) {
                    ForgeEvents.checkItemFall(itemEntity);
                }
            });
        }
    }

    private static void checkItemFall(ItemEntity itemEntity) {
        float currentHeight;
        float initialHeight;
        float fallDistance;
        CompoundTag persistentData;
        if (itemEntity.m_20096_() && !itemEntity.m_213877_() && (persistentData = itemEntity.getPersistentData()).m_128441_("initialHeight") && (fallDistance = (initialHeight = persistentData.m_128457_("initialHeight")) - (currentHeight = (float)itemEntity.m_20186_())) > 7.0f) {
            ForgeEvents.explode(itemEntity);
        }
    }

    private static void explode(ItemEntity itemEntity) {
        Level level = itemEntity.m_9236_();
        if (!level.f_46443_) {
            level.m_254849_(null, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), 4.0f, Level.ExplosionInteraction.BLOCK);
            itemEntity.m_146870_();
        }
    }
}

