/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.events;

import com.nukateam.nukacraft.common.data.utils.RadiationUtils;
import com.nukateam.nukacraft.common.foundation.blocks.blocks.RadioactiveBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;

public class RadiationTracker {
    public static final int COUNTER = 10;
    public static final Map<Player, RadiationTracker> radiationTrackers = new HashMap<Player, RadiationTracker>();
    public final Player player;
    private int counter = 10;

    public RadiationTracker(Player player) {
        this.player = player;
    }

    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.counter <= 0) {
            this.rareTick(event);
            this.counter = 10;
        } else {
            --this.counter;
        }
    }

    private void rareTick(TickEvent.PlayerTickEvent event) {
        if (event.player != this.player) {
            return;
        }
        Level level = event.player.m_9236_();
        AABB bounding = this.player.m_20191_().m_82400_(10.0);
        Stream blocks = BlockPos.m_121921_((AABB)bounding);
        blocks.forEach(blockPos -> {
            Block block = level.m_8055_(blockPos).m_60734_();
            if (block instanceof RadioactiveBlock) {
                RadioactiveBlock radioactiveBlock = (RadioactiveBlock)block;
                if (!this.player.m_7500_()) {
                    RadiationUtils.addRadiation((LivingEntity)this.player, radioactiveBlock.getRadiation());
                }
            }
        });
    }
}

