/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.blocks.blocks;

import com.nukateam.nukacraft.common.data.utils.VoxelShapeHelper;
import com.nukateam.nukacraft.common.foundation.blocks.blocks.CustomModelBlock;
import com.nukateam.nukacraft.common.foundation.entities.blocks.ChairBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChairBlock
extends CustomModelBlock {
    private final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();
    private float seatPos = 0.25f;

    public ChairBlock(float seatPos, BlockBehaviour.Properties properties) {
        super(properties);
        this.setSeatPos(seatPos);
    }

    public void setSeatPos(float seatPos) {
        this.seatPos = seatPos;
    }

    public float seatY() {
        return this.seatPos;
    }

    private VoxelShape getShape(BlockState state) {
        if (this.SHAPES.containsKey(state)) {
            return this.SHAPES.get(state);
        }
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(ChairBlock.m_49796_((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)6.9, (double)15.9));
        VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
        this.SHAPES.put(state, shape);
        return shape;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public boolean isChair(BlockState state) {
        return true;
    }

    public BlockPos Dismount(Level level, BlockState state, BlockPos pos) {
        return pos;
    }

    public float setPassangerRotation(BlockState state, Entity entity) {
        return entity.m_146908_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.isChair(state) || player.m_20159_() || player.m_6047_()) {
            return InteractionResult.PASS;
        }
        List seats = level.m_45976_(ChairBlockEntity.class, new AABB(pos, pos.m_7918_(1, 1, 1)));
        if (seats.isEmpty()) {
            ChairBlockEntity seat = new ChairBlockEntity(level, pos, this.seatY());
            level.m_7967_((Entity)seat);
            player.m_20329_((Entity)seat);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

