/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.blocks.plants.bushes;

import com.nukateam.nukacraft.common.data.interfaces.IAgeable;
import com.nukateam.nukacraft.common.data.utils.BiomeUtils;
import com.nukateam.nukacraft.common.data.utils.HarvestUtils;
import com.nukateam.nukacraft.common.data.utils.PlantMutationUtils;
import com.nukateam.nukacraft.common.data.utils.Resources;
import com.nukateam.nukacraft.common.foundation.blocks.plants.bushes.BaseBushBlock;
import com.nukateam.nukacraft.common.registery.blocks.PlantBlocks;
import com.nukateam.nukacraft.common.registery.items.ModFood;
import com.nukateam.nukacraft.common.registery.items.ModItems;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class SmallAgeBushBlock
extends BaseBushBlock
implements BonemealableBlock,
IAgeable {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final VoxelShape BUSHLING_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public SmallAgeBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public IntegerProperty getAge() {
        return AGE;
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_204336_(BlockTags.f_144274_) || pState.m_60713_(Blocks.f_50093_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.m_60824_(getter, pos);
        return BUSHLING_SHAPE.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    @Override
    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean isMutablePlant = state.m_60734_().m_49966_().m_204336_(BlockTags.create((ResourceLocation)Resources.nukaResource("mutable_plants")));
        float chance = level.f_46441_.m_188501_();
        Integer age = (Integer)state.m_61143_((Property)AGE);
        if (age < 3 && level.m_45524_(pos.m_7494_(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            if (BiomeUtils.isInGlowSea((Level)level, pos, state)) {
                if (isMutablePlant && (double)chance < 0.5) {
                    PlantMutationUtils.mutationSuccess(state, pos, (Level)level);
                } else {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                }
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        boolean adhesive;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean flag = i == 3;
        boolean bl = adhesive = player.m_21120_(hand).m_150930_(Items.f_42499_) || player.m_21120_(hand).m_150930_((Item)ModItems.FERTILIZER.get()) || player.m_21120_(hand).m_150930_((Item)ModItems.PURPLE_REAGENT.get());
        if (!flag && adhesive) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int j = 1 + level.f_46441_.m_188503_(2);
            Random ran = new Random();
            int chance = ran.nextInt(200);
            if (state.m_60734_().equals(PlantBlocks.NEO_AGAVE.get()) && chance <= 1) {
                SmallAgeBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModFood.RETROGAVE.get(), 1));
            }
            SmallAgeBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)HarvestUtils.getFinishItem(state), j + (flag ? 1 : 0)));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{AGE});
    }

    @Override
    public boolean m_7370_(LevelReader getter, BlockPos pos, BlockState state, boolean pIsClient) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    @Override
    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    @Override
    public void m_214148_(ServerLevel serverLevel, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.m_61143_((Property)AGE) + 1);
        serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

