/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.entities.misc;

import com.nukateam.chassis_core.common.util.helpers.MathHelper;
import com.nukateam.nukacraft.common.data.utils.ExplosionType;
import com.nukateam.nukacraft.common.data.utils.VectorUtils;
import com.nukateam.nukacraft.common.foundation.entities.misc.SimpleGeoEntity;
import com.nukateam.nukacraft.common.settings.ExplosionTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class NuclearExplosionEffectEntity
extends SimpleGeoEntity {
    private static final int explosionFade = 40;
    private static final int tremorFade = 30;
    private static final int WORLD_MIN_Y = -64;
    private final int lifeTime;
    public int darkSkyFor;
    public int tremorFor;
    public int muteNonNukeSoundsFor;
    public int renderNukeFlashFor;
    public float prevNukeFlashAmount = 0.0f;
    public float nukeFlashAmount = 0.0f;
    public float masterVolumeNukeModifier = 0.0f;
    private ExplosionType explosionType = ExplosionTypes.MINI_NUKE;
    private boolean initialized = false;

    public NuclearExplosionEffectEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
        this.darkSkyFor = 70;
        this.muteNonNukeSoundsFor = 50;
        this.lifeTime = this.explosionType.getDuration();
        this.tremorFor = this.explosionType.getTremorDuration();
        this.renderNukeFlashFor = this.explosionType.getFlashDuration();
    }

    public boolean m_6060_() {
        return false;
    }

    public void setType(ExplosionType explosionType) {
        this.explosionType = explosionType;
        this.initialized = true;
    }

    public ExplosionType getExplosionType() {
        return this.explosionType;
    }

    public float getOpacity() {
        int fadeLeft = this.lifeTime - this.f_19797_;
        return fadeLeft > 40 ? 1.0f : (float)MathHelper.getFraction((double)fadeLeft, (double)40.0);
    }

    public float getTremorIntensity() {
        if (this.f_19797_ > this.explosionType.getTremorDuration()) {
            return 0.0f;
        }
        int tremorLeft = this.explosionType.getTremorDuration() - this.f_19797_;
        return tremorLeft > 30 ? 1.0f : (float)MathHelper.getFraction((double)tremorLeft, (double)30.0);
    }

    private int sub(int s) {
        if (s > 0) {
            return --s;
        }
        return s;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getDistanceToPlayer() {
        Minecraft minecraft = Minecraft.m_91087_();
        assert (minecraft.f_91074_ != null);
        return minecraft.f_91074_.m_20318_(minecraft.m_91296_()).m_82554_(this.m_20318_(minecraft.m_91296_()));
    }

    public BlockPos getBlockPos() {
        Vec3 pos = this.m_20182_();
        pos = pos.m_82492_(0.0, 1.0, 0.0);
        Vec3i posI = new Vec3i((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
        return new BlockPos(posI);
    }

    public Vec3 getExplosionPos() {
        Vec3 pos = this.m_20182_();
        while (this.m_9236_().m_46859_(new BlockPos(VectorUtils.toVec3I(pos))) && pos.f_82480_ >= -64.0) {
            pos = pos.m_82492_(0.0, 1.0, 0.0);
        }
        return pos;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.initialized && this.m_9236_().m_46859_(this.getBlockPos())) {
            this.m_146884_(this.getExplosionPos());
        }
        if (this.f_19797_ > this.lifeTime) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.prevNukeFlashAmount = this.nukeFlashAmount;
        this.darkSkyFor = this.sub(this.darkSkyFor);
        this.tremorFor = this.sub(this.tremorFor);
        if (this.muteNonNukeSoundsFor > 0) {
            --this.muteNonNukeSoundsFor;
            if (this.masterVolumeNukeModifier < 1.0f) {
                this.masterVolumeNukeModifier += 0.1f;
            }
        } else if (this.masterVolumeNukeModifier > 0.0f) {
            this.masterVolumeNukeModifier -= 0.1f;
        }
        if (this.renderNukeFlashFor > 0) {
            if (this.nukeFlashAmount < 1.0f) {
                this.nukeFlashAmount = Math.min(this.nukeFlashAmount + 0.4f, 1.0f);
            }
            --this.renderNukeFlashFor;
        } else if (this.nukeFlashAmount > 0.0f) {
            this.nukeFlashAmount = Math.max(this.nukeFlashAmount - 0.05f, 0.0f);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "explosionController", 0, event -> event.setAndContinue(RawAnimation.begin().thenPlayAndHold("explosion")));
        controller.setAnimationSpeed(1.0);
        controllers.add(new AnimationController[]{controller});
    }
}

