/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.entities.misc;

import com.nukateam.nukacraft.common.data.utils.MathUtils;
import com.nukateam.nukacraft.common.foundation.entities.misc.SimpleEntity;
import com.nukateam.nukacraft.common.registery.ModParticles;
import com.nukateam.nukacraft.common.registery.entities.ModEntities;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NuclearExplosionEntity
extends SimpleEntity
implements GeoEntity {
    public static final int LIFE_TIME = 20;
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(NuclearExplosionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean spawnedParticle = false;
    private Stack<BlockPos> destroyingChunks = new Stack();

    public NuclearExplosionEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public NuclearExplosionEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ModEntities.NUCLEAR_EXPLOSION.get(), level);
        this.m_20011_(this.m_142242_());
    }

    private static BlockPos containing(double p_275310_, double p_275414_, double p_275737_) {
        return new BlockPos(Mth.m_14107_((double)p_275310_), Mth.m_14107_((double)p_275414_), Mth.m_14107_((double)p_275737_));
    }

    public void m_8119_() {
        super.m_8119_();
        int chunksAffected = (int)Math.ceil(this.getSize());
        int radius = chunksAffected * 15;
        this.showParticles(radius);
        if (this.f_19797_ > 20 && this.destroyingChunks.isEmpty()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            if (!this.m_9236_().f_46443_) {
                if (this.destroyingChunks.isEmpty()) {
                    BlockPos center = this.m_20183_();
                    int chunks = chunksAffected;
                    for (int i = -chunks; i <= chunks; ++i) {
                        for (int j = -chunks; j <= chunks; ++j) {
                            for (int k = -chunks; k <= chunks; ++k) {
                                this.destroyingChunks.push(center.m_7918_(i * 16, j * 2, k * 16));
                            }
                        }
                    }
                    this.destroyingChunks.sort((blockPos1, blockPos2) -> Double.compare(blockPos2.m_123333_((Vec3i)this.m_20183_()), blockPos1.m_123333_((Vec3i)this.m_20183_())));
                } else {
                    int tickChunkCount = Math.min(this.destroyingChunks.size(), 3);
                    for (int i = 0; i < tickChunkCount; ++i) {
                        this.removeChunk(radius);
                    }
                }
            }
            AABB killBox = this.m_20191_().m_82377_((double)((float)radius + (float)radius * 0.5f), (double)radius * 0.6, (double)((float)radius + (float)radius * 0.5f));
            float flingStrength = this.getSize() * 0.33f;
            float maximumDistance = (float)radius + (float)radius * 0.5f + 1.0f;
            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, killBox)) {
                float dist = entity.m_20270_((Entity)this);
                float damage = this.calculateDamage(dist, maximumDistance);
                Vec3 vec3 = entity.m_20182_().m_82546_(this.m_20182_()).m_82520_(0.0, 0.3, 0.0).m_82541_();
                entity.m_20256_(vec3.m_82490_((double)(damage * 0.1f * flingStrength)));
                if (!(damage > 0.0f)) continue;
                entity.m_6469_(this.m_269291_().m_269387_(), damage);
            }
        }
    }

    public boolean m_6060_() {
        return false;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "explosionController", 0, event -> event.setAndContinue(RawAnimation.begin().thenPlayAndHold("explosion")));
        controller.setAnimationSpeed(1.0);
        controllers.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setSize(float f) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(f));
    }

    private boolean isDestroyable(BlockState state) {
        return state.m_60734_().m_7325_() < 1000.0f;
    }

    private float calculateDamage(float dist, float max) {
        float revert = (max - dist) / max;
        float baseDmg = this.getSize() <= 1.5f ? 100.0f : 100.0f + (this.getSize() - 1.5f) * 400.0f;
        return revert * baseDmg;
    }

    private void showParticles(int radius) {
        if (!this.spawnedParticle) {
            int particleY;
            this.spawnedParticle = true;
            for (particleY = (int)Math.ceil(this.m_20186_()); particleY > this.m_9236_().m_141937_() && (double)particleY > this.m_20186_() - (double)((float)radius / 2.0f) && this.isDestroyable(this.m_9236_().m_8055_(NuclearExplosionEntity.containing(this.m_20185_(), particleY, this.m_20189_()))); --particleY) {
            }
            this.m_9236_().m_6485_((ParticleOptions)ModParticles.MUSHROOM_CLOUD.get(), true, this.m_20185_(), (double)(particleY + 2), this.m_20189_(), (double)this.getSize(), 0.0, 0.0);
        }
    }

    private void removeChunk(int radius) {
        BlockPos chunkCorner = this.destroyingChunks.pop();
        BlockPos.MutableBlockPos carve = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos carveBelow = new BlockPos.MutableBlockPos();
        carve.m_122190_((Vec3i)chunkCorner);
        carveBelow.m_122190_((Vec3i)chunkCorner);
        float itemDropModifier = 0.025f / Math.min(1.0f, this.getSize());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 15; y >= 0; --y) {
                    BlockState state;
                    carve.m_122178_(chunkCorner.m_123341_() + x, Mth.m_14045_((int)(chunkCorner.m_123342_() + y), (int)this.m_9236_().m_141937_(), (int)this.m_9236_().m_151558_()), chunkCorner.m_123343_() + z);
                    float widthSimplexNoise = (MathUtils.sampleNoise3D(carve.m_123341_(), carve.m_123342_(), carve.m_123343_(), radius) - 0.5f) * 0.45f + 0.55f;
                    double yDist = MathUtils.smin(0.6f - (float)Math.abs(this.m_20183_().m_123342_() - carve.m_123342_()) / (float)radius, 0.6f, 0.2f);
                    double distToCenter = carve.m_203202_((double)this.m_20183_().m_123341_(), (double)(carve.m_123342_() - 1), (double)this.m_20183_().m_123343_());
                    double targetRadius = yDist * (double)((float)radius + widthSimplexNoise * (float)radius) * (double)radius;
                    if (!(distToCenter <= targetRadius) || (state = this.m_9236_().m_8055_((BlockPos)carve)).m_60795_() && state.m_60819_().m_76178_() || !this.isDestroyable(state)) continue;
                    carveBelow.m_122178_(carve.m_123341_(), carve.m_123342_() - 1, carve.m_123343_());
                    if (this.f_19796_.m_188501_() < itemDropModifier && state.m_60819_().m_76178_()) {
                        this.m_9236_().m_46961_((BlockPos)carve, true);
                        continue;
                    }
                    this.m_9236_().m_46597_((BlockPos)carve, Blocks.f_50016_.m_49966_());
                }
                if (!((double)this.f_19796_.m_188501_() < 0.15) || this.m_9236_().m_8055_((BlockPos)carveBelow).m_60795_()) continue;
                this.m_9236_().m_46597_(carveBelow.m_7494_(), Blocks.f_50083_.m_49966_());
            }
        }
    }
}

