/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.entities.mobs;

import com.nukateam.chassis_core.common.util.helpers.timer.PlayOnceTimerTask;
import com.nukateam.chassis_core.common.util.helpers.timer.TickTimer;
import com.nukateam.chassis_core.common.util.helpers.timer.TimerTask;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.nukacraft.common.data.interfaces.IGunUser;
import com.nukateam.nukacraft.common.foundation.entities.mobs.ITriggerProvider;
import com.nukateam.nukacraft.common.foundation.entities.mobs.Raider;
import com.nukateam.nukacraft.common.foundation.goals.AssaultronAttackGoal;
import com.nukateam.nukacraft.common.foundation.goals.GeoMeleeAttackGoal;
import com.nukateam.nukacraft.common.foundation.goals.GunAttackGoal;
import com.nukateam.nukacraft.common.registery.ModSounds;
import com.nukateam.nukacraft.common.registery.items.MobGuns;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Assaultron
extends PathfinderMob
implements GeoEntity,
IGunUser,
ITriggerProvider {
    public static final EntityDataAccessor<Boolean> IS_AGGRESSIVE = SynchedEntityData.m_135353_(Assaultron.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_SHOOTING_LASER = SynchedEntityData.m_135353_(Assaultron.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LASER_COOLDOWN = SynchedEntityData.m_135353_(Assaultron.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String TRIGGER = "trigger";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final boolean isServerSide;
    private final TickTimer serverTimer;
    private boolean startAttacking;
    private String attackAnimName;
    private String[] attackAnims;
    AnimationController<Assaultron> triggersController;

    public Assaultron(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.isServerSide = !this.m_9236_().f_46443_;
        this.serverTimer = new TickTimer();
        this.startAttacking = false;
        this.attackAnims = new String[]{"attack_right", "attack_left", "attack"};
        this.triggersController = new AnimationController((GeoAnimatable)this, TRIGGER, event -> PlayState.CONTINUE).triggerableAnim("attack_right", RawAnimation.begin().then("attack_right", Animation.LoopType.PLAY_ONCE)).triggerableAnim("attack_left", RawAnimation.begin().then("attack_left", Animation.LoopType.PLAY_ONCE)).triggerableAnim("attack", RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE)).setAnimationSpeed(2.0);
        WeaponItem gun = (WeaponItem)this.getGun().m_41720_();
        this.resetLaserCooldown(gun);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 75.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, new AssaultronAttackGoal<Assaultron>(this, 0.7, 20.0f));
        this.f_21345_.m_25352_(4, new GeoMeleeAttackGoal<Assaultron>(this, 1.5, false));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{this.getClass()}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setupGuns();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private void setupGuns() {
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)MobGuns.ASSAULTRON_LASER.get()));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_AGGRESSIVE, (Object)false);
        this.f_19804_.m_135372_(IS_SHOOTING_LASER, (Object)false);
        this.f_19804_.m_135372_(LASER_COOLDOWN, (Object)0);
    }

    public void m_6710_(@Nullable LivingEntity pTarget) {
        super.m_6710_(pTarget);
        if (this.isServerSide) {
            this.setIsAggressive(pTarget != null);
        }
    }

    public boolean isShootingLaser() {
        return (Boolean)this.f_19804_.m_135370_(IS_SHOOTING_LASER);
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        GunAttackGoal.shoot((LivingEntity)this, InteractionHand.MAIN_HAND);
        ItemStack weapon = this.getGun();
        WeaponItem gun = (WeaponItem)weapon.m_41720_();
        WeaponData gunData = new WeaponData(weapon, (LivingEntity)this);
        int laserDuration = WeaponModifierHelper.getCurrentAmmo((WeaponData)gunData).getLife();
        this.f_19804_.m_135381_(IS_SHOOTING_LASER, (Object)true);
        this.serverTimer.addTimer((TimerTask)new PlayOnceTimerTask(laserDuration, () -> {
            this.resetLaserCooldown(gun);
            this.f_19804_.m_135381_(IS_SHOOTING_LASER, (Object)false);
        }));
    }

    @Override
    public ItemStack getGun() {
        if (!(this.m_21205_().m_41720_() instanceof WeaponItem)) {
            this.setupGuns();
        }
        return this.m_21205_();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.triggersController});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 0, this.animateArms())});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 0, this.animateLegs())});
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isServerSide) {
            this.serverTimer.tick();
            this.decreaseLaserCooldown();
            this.m_20088_().m_135381_(IS_AGGRESSIVE, (Object)(this.m_5448_() != null ? 1 : 0));
        }
    }

    private void resetLaserCooldown(WeaponItem gun) {
        this.setLaserCooldown(gun.getConfig().getGeneral().getReloadTime());
    }

    public int getLaserCooldown() {
        return (Integer)this.m_20088_().m_135370_(LASER_COOLDOWN);
    }

    public void setLaserCooldown(int value) {
        this.m_20088_().m_135381_(LASER_COOLDOWN, (Object)value);
    }

    public void decreaseLaserCooldown() {
        if (this.getLaserCooldown() > 0) {
            this.setLaserCooldown(this.getLaserCooldown() - 1);
        }
    }

    protected void m_5907_() {
        super.m_5907_();
    }

    protected boolean m_6125_() {
        this.m_5907_();
        return super.m_6125_();
    }

    public void setIsAggressive(boolean isRunning) {
        this.m_20088_().m_135381_(IS_AGGRESSIVE, (Object)isRunning);
        if (isRunning) {
            this.m_7910_(1.5f);
        } else {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
        }
    }

    public boolean isReadyToShoot() {
        return this.getLaserCooldown() == 0 && (Boolean)this.m_20088_().m_135370_(IS_AGGRESSIVE) != false;
    }

    @NotNull
    private AnimationController.AnimationStateHandler<Assaultron> animateArms() {
        return event -> {
            AnimationController controller = event.getController();
            RawAnimation animation = RawAnimation.begin();
            Boolean isAggressive = (Boolean)this.m_20088_().m_135370_(IS_AGGRESSIVE);
            controller.setAnimationSpeed(1.0);
            if (!this.triggersController.hasAnimationFinished()) {
                return PlayState.STOP;
            }
            if (event.isMoving()) {
                if (isAggressive.booleanValue()) {
                    animation.thenLoop("run_arms");
                    controller.setAnimationSpeed(3.0);
                } else {
                    animation.thenLoop("walk_arms");
                    controller.setAnimationSpeed(2.0);
                }
            } else {
                return PlayState.STOP;
            }
            return event.setAndContinue(animation);
        };
    }

    @NotNull
    private AnimationController.AnimationStateHandler<Assaultron> animateLegs() {
        return event -> {
            AnimationController controller = event.getController();
            RawAnimation animation = RawAnimation.begin();
            Boolean isAggressive = (Boolean)this.m_20088_().m_135370_(IS_AGGRESSIVE);
            controller.setAnimationSpeed(1.0);
            if (this.isReadyToShoot() || this.isShootingLaser()) {
                animation.thenPlayAndHold("laser_start");
            } else if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animation().name().equals("laser_start")) {
                animation.then("laser_end", Animation.LoopType.PLAY_ONCE);
            } else if (event.isMoving()) {
                if (isAggressive.booleanValue()) {
                    animation.thenLoop("run_legs");
                    controller.setAnimationSpeed(3.0);
                } else {
                    animation.thenLoop("walk_legs");
                    controller.setAnimationSpeed(2.0);
                }
            } else if (isAggressive.booleanValue()) {
                if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animation().name().equals("idle")) {
                    animation.thenPlayAndHold("aggressive_start");
                } else {
                    animation.thenLoop("aggressive");
                }
            } else {
                animation.thenLoop("idle");
            }
            return event.setAndContinue(animation);
        };
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.ASSAULTRON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ROBOT_DEATH.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_216990_((SoundEvent)ModSounds.ASSAULTRON_WALK.get());
    }

    @Override
    public void onAttack() {
        this.attackAnimName = this.attackAnims[this.f_19796_.m_188503_(this.attackAnims.length)];
        this.triggerAnim(TRIGGER, this.attackAnimName);
    }
}

