/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.entities.mobs;

import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.nukacraft.common.data.interfaces.IGunUser;
import com.nukateam.nukacraft.common.data.utils.PowerArmorUtils;
import com.nukateam.nukacraft.common.data.utils.Resources;
import com.nukateam.nukacraft.common.foundation.entities.misc.PowerArmorFrame;
import com.nukateam.nukacraft.common.foundation.entities.mobs.Radroach;
import com.nukateam.nukacraft.common.foundation.goals.GunAttackGoal;
import com.nukateam.nukacraft.common.foundation.goals.RidePowerArmorGoal;
import com.nukateam.nukacraft.common.foundation.variants.RaiderVariant;
import com.nukateam.nukacraft.common.registery.items.ModWeapons;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Raider
extends PathfinderMob
implements IGunUser {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Raider.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public PowerArmorFrame armorTarget = null;
    private WeaponItem[] guns = new WeaponItem[]{(WeaponItem)ModWeapons.PISTOL10MM.get(), (WeaponItem)ModWeapons.PIPE_REVOLVER.get(), (WeaponItem)ModWeapons.PIPE_PISTOL.get(), (WeaponItem)ModWeapons.SCOUT10MM.get(), (WeaponItem)ModWeapons.MINIGUN.get(), (WeaponItem)ModWeapons.LASER_PISTOL.get()};

    public Raider(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21553_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, new GunAttackGoal<Raider>(this, 1.0, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new RidePowerArmorGoal(this, 1.0, 20.0f));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{Raider.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Radroach.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void m_6083_() {
        super.m_6083_();
        if (PowerArmorUtils.isWearingPowerArmor((Entity)this) && !PowerArmorUtils.getPowerArmor((Entity)this).hasEnergy()) {
            this.m_8127_();
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setVariant((RaiderVariant)((Object)Util.m_214670_((Object[])RaiderVariant.values(), (RandomSource)this.f_19796_)));
        int id = this.f_19796_.m_188503_(this.guns.length);
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)this.guns[id]));
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTypeVariant(pCompound.m_128451_("Variant"));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12310_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    private void setTypeVariant(int pTypeVariant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)pTypeVariant);
    }

    public RaiderVariant getVariant() {
        return RaiderVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(RaiderVariant variant) {
        this.setTypeVariant(variant.getId() & 0xFF);
    }

    public boolean m_20145_() {
        if (this.m_20202_() instanceof PowerArmorFrame) {
            return true;
        }
        return super.m_20145_();
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        GunAttackGoal.shoot((LivingEntity)this, InteractionHand.MAIN_HAND);
    }

    public ResourceLocation getTexture() {
        return Resources.nukaResource("textures/entity/raider/raider_" + this.getTypeVariant() + ".png");
    }

    @Override
    public ItemStack getGun() {
        return this.m_21205_();
    }
}

