/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.goals;

import com.nukateam.nukacraft.common.foundation.entities.misc.PowerArmorFrame;
import com.nukateam.nukacraft.common.foundation.entities.mobs.Raider;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;

public class RidePowerArmorGoal
extends Goal {
    private final Raider entity;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private final float searchDistance;
    protected TargetingConditions targetConditions;
    private PowerArmorFrame target;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public RidePowerArmorGoal(Raider entity, double speedModifier, float searchDistance) {
        this.entity = entity;
        this.level = entity.m_9236_();
        this.speedModifier = speedModifier;
        this.navigation = entity.m_21573_();
        this.searchDistance = searchDistance;
        this.targetConditions = TargetingConditions.m_148352_().m_26883_((double)searchDistance).m_26888_(target -> !target.m_20160_());
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(entity.m_21573_() instanceof GroundPathNavigation) && !(entity.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        return this.entity.m_20202_() == null;
    }

    public boolean m_8045_() {
        return !this.navigation.m_26571_() && this.target != null && !this.target.hasPassenger();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.m_21439_(BlockPathTypes.WATER);
        this.entity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.navigation.m_26573_();
        this.entity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    protected AABB getTargetSearchArea(double pTargetDistance) {
        return this.entity.m_20191_().m_82377_(pTargetDistance, 4.0, pTargetDistance);
    }

    public void m_8037_() {
        this.target = (PowerArmorFrame)this.entity.m_9236_().m_45982_(this.entity.m_9236_().m_6443_(PowerArmorFrame.class, this.getTargetSearchArea(this.searchDistance), entity -> true), this.targetConditions, (LivingEntity)this.entity, this.entity.m_20185_(), this.entity.m_20188_(), this.entity.m_20189_());
        if (this.target == null || !this.target.hasEnergy()) {
            return;
        }
        this.entity.armorTarget = this.target;
        this.entity.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.entity.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (!this.entity.m_21523_() && !this.entity.m_20159_()) {
                this.navigation.m_5624_((Entity)this.target, this.speedModifier);
            }
        }
        if (this.entity.m_20270_((Entity)this.target) < 2.0f) {
            this.target.ride((LivingEntity)this.entity);
            if (this.target.isOpened()) {
                this.target.close();
            }
            this.entity.armorTarget = null;
        }
    }
}

