/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.items.misc;

import com.nukateam.chassis_core.common.foundation.item.StackUtils;
import com.nukateam.geo.interfaces.DynamicGeoItem;
import com.nukateam.geo.render.DynamicGeoItemRenderer;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.nukacraft.client.render.animators.PipboyAnimator;
import com.nukateam.nukacraft.client.render.renderers.items.PipBoyRenderer;
import com.nukateam.nukacraft.common.data.utils.PipBoyUtils;
import com.nukateam.nukacraft.common.foundation.container.PipBoyMenu;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PipBoyItem
extends Item
implements DynamicGeoItem {
    public static final String ATLAS_ID = "atlasID";
    public static final String SCREEN = "screen";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final String skin;
    private final Lazy<PipBoyRenderer> RENDERER = Lazy.of(() -> new PipBoyRenderer());

    public PipBoyItem(String skin, Item.Properties pProperties) {
        super(pProperties);
        this.skin = skin;
    }

    public static ResourceLocation getPipboyFrame(PipBoyItem pipBoyItem) {
        return new ResourceLocation("nukacraft:textures/screens/" + pipBoyItem.skin + "_pipboy.png");
    }

    public DynamicGeoItemRenderer getRenderer() {
        return (DynamicGeoItemRenderer)this.RENDERER.get();
    }

    public BiFunction<ItemDisplayContext, DynamicGeoItemRenderer<PipboyAnimator>, PipboyAnimator> getAnimatorFactory() {
        return PipboyAnimator::new;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        CompoundTag stackTag = stack.m_41784_();
        if (stackTag.m_128461_(SCREEN).equals("")) {
            stackTag.m_128359_(SCREEN, "green");
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_21206_().m_41720_() instanceof PipBoyItem && player.m_6144_() && Ntgl.isDebugging()) {
                PipBoyItem.openPipboyScreen(serverPlayer);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void m_7373_(ItemStack item, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(item, level, list, flag);
        String variant = StackUtils.getVariant((ItemStack)item);
        if (Ntgl.isDebugging()) {
            list.add((Component)Component.m_237115_((String)"pipboy.nukacraft.handselect"));
            list.add((Component)Component.m_237115_((String)"pipboy.nukacraft.clicks"));
            list.add((Component)Component.m_237115_((String)("skin." + variant)));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public String getSkin() {
        return this.skin;
    }

    public static void openPipboyScreen(ServerPlayer player) {
        if (!PipBoyUtils.hasPipboy((Player)player)) {
            return;
        }
        if (Ntgl.isDebugging()) {
            PipBoyItem.openPipboyScreen(player, new BlockPos(0, 0, 0));
        }
    }

    public static void openPipboyScreen(ServerPlayer serverPlayer, final BlockPos blockPos) {
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Sadzxc");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                return new PipBoyMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(blockPos));
            }
        }, (BlockPos)blockPos);
    }
}

