/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.world;

import com.nukateam.nukacraft.common.data.utils.Resources;
import com.nukateam.nukacraft.common.foundation.world.BiomeSettings;
import com.nukateam.nukacraft.common.foundation.world.features.ModDefaultFeatures;
import com.nukateam.nukacraft.common.foundation.world.features.placed.ModVegetationPlacements;
import com.nukateam.nukacraft.common.registery.entities.ModMobs;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class ModBiomes {
    public static final ResourceKey<Biome> POISON_VALLEY = ModBiomes.createKey("poison_valley");
    public static final ResourceKey<Biome> GLOW_SEA = ModBiomes.createKey("glow_sea");
    public static final ResourceKey<Biome> ASH_HEAP = ModBiomes.createKey("ash_heap");
    public static final ResourceKey<Biome> CRANBERRY_BOG = ModBiomes.createKey("cranberry_bog");
    public static final ResourceKey<Biome> SAVAGE_DIVIDE = ModBiomes.createKey("savage_divide");
    private static final HashMap<ResourceKey<Biome>, BiomeSettings> biomeSettings = new HashMap();

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        HolderGetter worldCarvers = context.m_255420_(Registries.f_257003_);
        context.m_255272_(POISON_VALLEY, (Object)ModBiomes.createPoisonValley((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.m_255272_(CRANBERRY_BOG, (Object)ModBiomes.createCranberryBog((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.m_255272_(ASH_HEAP, (Object)ModBiomes.createAshHeap((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.m_255272_(GLOW_SEA, (Object)ModBiomes.createGlowSea((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.m_255272_(SAVAGE_DIVIDE, (Object)ModBiomes.createSavageDivide((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
    }

    public static void setupBiomeSettings() {
        biomeSettings.put(POISON_VALLEY, new BiomeSettings().setFogDensity(1.0f));
        biomeSettings.put(CRANBERRY_BOG, new BiomeSettings().setFogDensity(1.0f));
        biomeSettings.put(ASH_HEAP, new BiomeSettings().setFogDensity(0.5f));
        biomeSettings.put(GLOW_SEA, new BiomeSettings().setFogDensity(0.05f));
        biomeSettings.put(SAVAGE_DIVIDE, new BiomeSettings().setFogDensity(1.0f));
    }

    @Nullable
    public static BiomeSettings getBiomeSettings(Holder<Biome> biome) {
        for (ResourceKey<Biome> key : biomeSettings.keySet()) {
            if (!biome.m_203565_(key)) continue;
            return biomeSettings.get(key);
        }
        return null;
    }

    private static Biome createPoisonValley(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(-5399162).m_48034_(-9547964).m_48037_(11648455).m_48040_(-7964315).m_48043_(1783388).m_48045_(-861768).m_48018_();
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModVegetationPlacements.ASH_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModVegetationPlacements.POISON_GRASS);
        ModDefaultFeatures.addPoisonValleyOres(biomeBuilder);
        ModDefaultFeatures.addAshTrees(biomeBuilder);
        ModDefaultFeatures.addAshStone(biomeBuilder);
        ModDefaultFeatures.addScrap(biomeBuilder);
        ModDefaultFeatures.addAcidLake(biomeBuilder);
        ModDefaultFeatures.addPoisonValleyPlants(biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.5f).m_47611_(0.5f).m_47603_(effects).m_47605_(mobBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    private static Biome createSavageDivide(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(-10990522).m_48034_(-11386816).m_48037_(-11386816).m_48040_(16246715).m_48043_(-861668).m_48045_(-861668).m_48018_();
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModVegetationPlacements.STRANGE_GRASS);
        ModDefaultFeatures.addSavageDivideOres(biomeBuilder);
        ModDefaultFeatures.addImmortalGreenTrees(biomeBuilder);
        ModDefaultFeatures.addCommonBerryBush(biomeBuilder);
        ModDefaultFeatures.addScrap(biomeBuilder);
        ModDefaultFeatures.addRustyTrees(biomeBuilder);
        BiomeDefaultFeatures.m_126704_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.7f).m_47611_(0.4f).m_47603_(effects).m_47605_(mobBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    private static void createBiomeSettings(Biome biome, BiomeSettings settings) {
    }

    private static Biome createCranberryBog(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(-10990522).m_48034_(-11386816).m_48037_(-11590620).m_48040_(-3024201).m_48043_(-6797754).m_48045_(-7714230).m_48018_();
        mobBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModMobs.RADROACH.get(), 1, 1, 1));
        mobBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModMobs.BLOATFLY.get(), 1, 1, 1));
        mobBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModMobs.BRAHMIN.get(), 1, 1, 1));
        ModDefaultFeatures.addCranberryBogOres(biomeBuilder);
        ModDefaultFeatures.addDewdropTrees(biomeBuilder);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)biomeBuilder);
        ModDefaultFeatures.addScrap(biomeBuilder);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        ModDefaultFeatures.addCranBerryBogPlants(biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.8f).m_47611_(0.9f).m_47603_(effects).m_47605_(mobBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    private static Biome createGlowSea(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(0xFFD666).m_48034_(3882546).m_48037_(2308637).m_48040_(16246715).m_48043_(9076070).m_48045_(9076070).m_48018_();
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModVegetationPlacements.GRASS_ASH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModVegetationPlacements.GLOW_GRASS);
        ModDefaultFeatures.addGlowSeaOres(biomeBuilder);
        ModDefaultFeatures.addGlowTrees(biomeBuilder);
        ModDefaultFeatures.addScrap(biomeBuilder);
        ModDefaultFeatures.addGlowSeaPlants(biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(false).m_47609_(1.5f).m_47611_(0.9f).m_47603_(effects).m_47605_(mobBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    private static Biome createAshHeap(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        BiomeSpecialEffects effects = new BiomeSpecialEffects.Builder().m_48019_(-10990522).m_48034_(-9551310).m_48037_(11648455).m_48040_(-10990522).m_48043_(-10465466).m_48045_(-11187642).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123762_, 0.0219f)).m_48018_();
        ModDefaultFeatures.addAshHeapOres(biomeBuilder);
        ModDefaultFeatures.addScrap(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModVegetationPlacements.GRASS_ASH);
        ModDefaultFeatures.addAshHeapTrees(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModVegetationPlacements.HEAP_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModVegetationPlacements.RUSTY_BUSH);
        ModDefaultFeatures.addAshHeapDisks(biomeBuilder);
        ModDefaultFeatures.addAshHeapPlants(biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(false).m_47609_(1.2f).m_47611_(0.5f).m_47603_(effects).m_47605_(mobBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    private static ResourceKey<Biome> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Resources.nukaResource(name));
    }
}

