/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.world;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class WastelandNoiseRouterData {
    public static final ResourceKey<DensityFunction> Y = WastelandNoiseRouterData.createKey("y");
    public static final ResourceKey<DensityFunction> SHIFT_X = WastelandNoiseRouterData.createKey("shift_x");
    public static final ResourceKey<DensityFunction> SHIFT_Z = WastelandNoiseRouterData.createKey("shift_z");
    public static final ResourceKey<DensityFunction> CONTINENTS = WastelandNoiseRouterData.createKey("overworld/continents");
    public static final ResourceKey<DensityFunction> EROSION = WastelandNoiseRouterData.createKey("overworld/erosion");
    public static final ResourceKey<DensityFunction> RIDGES = WastelandNoiseRouterData.createKey("overworld/ridges");
    public static final ResourceKey<DensityFunction> FACTOR = WastelandNoiseRouterData.createKey("overworld/factor");
    public static final ResourceKey<DensityFunction> DEPTH = WastelandNoiseRouterData.createKey("overworld/depth");
    public static final ResourceKey<DensityFunction> SLOPED_CHEESE = WastelandNoiseRouterData.createKey("overworld/sloped_cheese");
    public static final ResourceKey<DensityFunction> CONTINENTS_LARGE = WastelandNoiseRouterData.createKey("overworld_large_biomes/continents");
    public static final ResourceKey<DensityFunction> EROSION_LARGE = WastelandNoiseRouterData.createKey("overworld_large_biomes/erosion");
    public static final ResourceKey<DensityFunction> FACTOR_LARGE = WastelandNoiseRouterData.createKey("overworld_large_biomes/factor");
    public static final ResourceKey<DensityFunction> DEPTH_LARGE = WastelandNoiseRouterData.createKey("overworld_large_biomes/depth");
    public static final ResourceKey<DensityFunction> SLOPED_CHEESE_LARGE = WastelandNoiseRouterData.createKey("overworld_large_biomes/sloped_cheese");
    public static final ResourceKey<DensityFunction> SLOPED_CHEESE_AMPLIFIED = WastelandNoiseRouterData.createKey("overworld_amplified/sloped_cheese");
    public static final ResourceKey<DensityFunction> SPAGHETTI_ROUGHNESS_FUNCTION = WastelandNoiseRouterData.createKey("overworld/caves/spaghetti_roughness_function");
    public static final ResourceKey<DensityFunction> ENTRANCES = WastelandNoiseRouterData.createKey("overworld/caves/entrances");
    public static final ResourceKey<DensityFunction> NOODLE = WastelandNoiseRouterData.createKey("overworld/caves/noodle");
    public static final ResourceKey<DensityFunction> PILLARS = WastelandNoiseRouterData.createKey("overworld/caves/pillars");
    public static final ResourceKey<DensityFunction> SPAGHETTI_2D = WastelandNoiseRouterData.createKey("overworld/caves/spaghetti_2d");

    private static ResourceKey<DensityFunction> createKey(String p_209537_) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)new ResourceLocation(p_209537_));
    }

    private static DensityFunction underground(HolderGetter<DensityFunction> registry, HolderGetter<NormalNoise.NoiseParameters> pNoiseParameters, DensityFunction p_224473_) {
        DensityFunction densityFunction = WastelandNoiseRouterData.getFunction(registry, SPAGHETTI_2D);
        DensityFunction densityFunction1 = WastelandNoiseRouterData.getFunction(registry, SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction densityFunction2 = DensityFunctions.m_208324_((Holder)pNoiseParameters.m_255043_(Noises.f_189245_), (double)8.0);
        DensityFunction densityFunction3 = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityFunction2.m_208230_());
        DensityFunction densityFunction4 = DensityFunctions.m_208324_((Holder)pNoiseParameters.m_255043_(Noises.f_189246_), (double)0.6666666666666666);
        DensityFunction densityFunction5 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.27), (DensityFunction)densityFunction4).m_208220_(-1.0, 1.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)1.5), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)-0.64), (DensityFunction)p_224473_)).m_208220_(0.0, 0.5));
        DensityFunction densityFunction6 = DensityFunctions.m_208293_((DensityFunction)densityFunction3, (DensityFunction)densityFunction5);
        DensityFunction densityFunction7 = DensityFunctions.m_208375_((DensityFunction)DensityFunctions.m_208375_((DensityFunction)densityFunction6, (DensityFunction)WastelandNoiseRouterData.getFunction(registry, ENTRANCES)), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)densityFunction, (DensityFunction)densityFunction1));
        DensityFunction densityFunction8 = WastelandNoiseRouterData.getFunction(registry, PILLARS);
        DensityFunction densityFunction9 = DensityFunctions.m_208287_((DensityFunction)densityFunction8, (double)-1000000.0, (double)0.03, (DensityFunction)DensityFunctions.m_208264_((double)-1000000.0), (DensityFunction)densityFunction8);
        return DensityFunctions.m_208382_((DensityFunction)densityFunction7, (DensityFunction)densityFunction9);
    }

    private static DensityFunction postProcess(DensityFunction p_224493_) {
        DensityFunction densityFunction = DensityFunctions.m_208389_((DensityFunction)p_224493_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208281_((DensityFunction)densityFunction), (DensityFunction)DensityFunctions.m_208264_((double)0.64)).m_208234_();
    }

    public static NoiseRouter falloutNoise(HolderGetter<DensityFunction> registry, HolderGetter<NormalNoise.NoiseParameters> pNoiseParameters, boolean pLarge, boolean pAmplified) {
        DensityFunction densityFunction = DensityFunctions.m_208324_((Holder)pNoiseParameters.m_255043_(Noises.f_189287_), (double)0.5);
        DensityFunction densityFunction1 = DensityFunctions.m_208324_((Holder)pNoiseParameters.m_255043_(Noises.f_189288_), (double)0.67);
        DensityFunction densityFunction2 = DensityFunctions.m_208324_((Holder)pNoiseParameters.m_255043_(Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction densityFunction3 = DensityFunctions.m_208322_((Holder)pNoiseParameters.m_255043_(Noises.f_189289_));
        DensityFunction densityFunction4 = WastelandNoiseRouterData.getFunction(registry, SHIFT_X);
        DensityFunction densityFunction5 = WastelandNoiseRouterData.getFunction(registry, SHIFT_Z);
        DensityFunction densityFunction6 = DensityFunctions.m_208296_((DensityFunction)densityFunction4, (DensityFunction)densityFunction5, (double)0.25, (Holder)pNoiseParameters.m_255043_(pLarge ? Noises.f_189281_ : Noises.f_189269_));
        DensityFunction densityFunction7 = DensityFunctions.m_208296_((DensityFunction)densityFunction4, (DensityFunction)densityFunction5, (double)0.25, (Holder)pNoiseParameters.m_255043_(pLarge ? Noises.f_189282_ : Noises.f_189278_));
        DensityFunction densityFunction8 = WastelandNoiseRouterData.getFunction(registry, pLarge ? FACTOR_LARGE : FACTOR);
        DensityFunction densityFunction9 = WastelandNoiseRouterData.getFunction(registry, pLarge ? DEPTH_LARGE : DEPTH);
        DensityFunction densityFunction10 = WastelandNoiseRouterData.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)densityFunction8), densityFunction9);
        DensityFunction densityFunction11 = WastelandNoiseRouterData.getFunction(registry, pLarge ? SLOPED_CHEESE_LARGE : (pAmplified ? SLOPED_CHEESE_AMPLIFIED : SLOPED_CHEESE));
        DensityFunction densityFunction12 = DensityFunctions.m_208375_((DensityFunction)densityFunction11, (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)5.0), (DensityFunction)WastelandNoiseRouterData.getFunction(registry, ENTRANCES)));
        DensityFunction densityFunction13 = DensityFunctions.m_208287_((DensityFunction)densityFunction11, (double)-1000000.0, (double)1.5625, (DensityFunction)densityFunction12, (DensityFunction)WastelandNoiseRouterData.underground(registry, pNoiseParameters, densityFunction11));
        DensityFunction densityFunction14 = DensityFunctions.m_208375_((DensityFunction)WastelandNoiseRouterData.postProcess(WastelandNoiseRouterData.slideOverworld(pAmplified, densityFunction13)), (DensityFunction)WastelandNoiseRouterData.getFunction(registry, NOODLE));
        DensityFunction densityFunction15 = WastelandNoiseRouterData.getFunction(registry, Y);
        return new NoiseRouter(densityFunction, densityFunction1, densityFunction2, densityFunction3, densityFunction6, densityFunction7, WastelandNoiseRouterData.getFunction(registry, pLarge ? CONTINENTS_LARGE : CONTINENTS), WastelandNoiseRouterData.getFunction(registry, pLarge ? EROSION_LARGE : EROSION), densityFunction9, WastelandNoiseRouterData.getFunction(registry, RIDGES), WastelandNoiseRouterData.slideOverworld(pAmplified, DensityFunctions.m_208293_((DensityFunction)densityFunction10, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125)).m_208220_(-64.0, 64.0)), densityFunction14, DensityFunctions.m_208264_((double)0.0), DensityFunctions.m_208264_((double)0.0), DensityFunctions.m_208264_((double)0.0));
    }

    private static DensityFunction slideOverworld(boolean p_224490_, DensityFunction p_224491_) {
        return WastelandNoiseRouterData.slide(p_224491_, -64, 384, p_224490_ ? 16 : 80, p_224490_ ? 0 : 64, -0.078125, 0, 24, p_224490_ ? 0.4 : 0.1171875);
    }

    private static DensityFunction noiseGradientDensity(DensityFunction p_212272_, DensityFunction p_212273_) {
        DensityFunction densityFunction = DensityFunctions.m_208363_((DensityFunction)p_212273_, (DensityFunction)p_212272_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityFunction.m_208233_());
    }

    private static DensityFunction slide(DensityFunction p_224444_, int p_224445_, int p_224446_, int p_224447_, int p_224448_, double p_224449_, int p_224450_, int p_224451_, double p_224452_) {
        DensityFunction densityFunction1 = DensityFunctions.m_208266_((int)(p_224445_ + p_224446_ - p_224447_), (int)(p_224445_ + p_224446_ - p_224448_), (double)1.0, (double)0.0);
        DensityFunction $$9 = DensityFunctions.m_224030_((DensityFunction)densityFunction1, (double)p_224449_, (DensityFunction)p_224444_);
        DensityFunction densityFunction2 = DensityFunctions.m_208266_((int)(p_224445_ + p_224450_), (int)(p_224445_ + p_224451_), (double)0.0, (double)1.0);
        return DensityFunctions.m_224030_((DensityFunction)densityFunction2, (double)p_224452_, (DensityFunction)$$9);
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> pDensityFunctions, ResourceKey<DensityFunction> pKey) {
        return new DensityFunctions.HolderHolder((Holder)pDensityFunctions.m_255043_(pKey));
    }
}

