/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.registery.fluid;

import com.nukateam.nukacraft.common.data.utils.Resources;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class AcidFluidType
extends FluidType {
    public static final ResourceLocation ACID_STILL_RL = Resources.nukaResource("block/fluid/acid_still");
    public static final ResourceLocation ACID_FLOWING_RL = Resources.nukaResource("block/fluid/acid_flow");
    public static final ResourceLocation ACID_OVERLAY_RL = Resources.nukaResource("block/fluid/acid_overlay");
    public static final Vector3f FOG_COLOR = new Vector3f(0.40784314f, 0.3372549f, 0.21176471f);

    public AcidFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return ACID_STILL_RL;
            }

            public ResourceLocation getFlowingTexture() {
                return ACID_FLOWING_RL;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return ACID_OVERLAY_RL;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return FOG_COLOR;
            }
        });
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        boolean flag;
        double d9 = entity.m_20186_();
        float f4 = 0.8f;
        float f5 = 0.02f;
        float f6 = EnchantmentHelper.m_44922_((LivingEntity)entity);
        double d0 = 0.08;
        boolean bl = flag = entity.m_20184_().f_82480_ <= 0.0;
        if (f6 > 3.0f) {
            f6 = 3.0f;
        }
        if (!entity.m_20096_()) {
            f6 *= 0.5f;
        }
        if (f6 > 0.0f) {
            f4 += (0.54600006f - f4) * f6 / 3.0f;
            f5 += (entity.m_6113_() - f5) * f6 / 3.0f;
        }
        if (entity.m_21023_(MobEffects.f_19593_)) {
            f4 = 0.96f;
        }
        entity.m_19920_(f5 *= (float)entity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_(), movementVector);
        entity.m_6478_(MoverType.SELF, entity.m_20184_());
        Vec3 vec36 = entity.m_20184_();
        if (entity.f_19862_ && entity.m_6147_()) {
            vec36 = new Vec3(vec36.f_82479_, 0.2, vec36.f_82481_);
        }
        entity.m_20256_(vec36.m_82542_((double)f4, (double)0.8f, (double)f4));
        Vec3 vec32 = entity.m_20994_(d0, flag, entity.m_20184_());
        entity.m_20256_(vec32);
        if (entity.f_19862_ && entity.m_20229_(vec32.f_82479_, vec32.f_82480_ + (double)0.6f - entity.m_20186_() + d9, vec32.f_82481_)) {
            entity.m_20334_(vec32.f_82479_, (double)0.3f, vec32.f_82481_);
        }
        return true;
    }

    public boolean isVaporizedOnPlacement(Level level, BlockPos pos, FluidStack stack) {
        return level.m_6042_().f_63857_();
    }
}

