/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.registery.items;

import com.mojang.datafixers.util.Pair;
import com.nukateam.nukacraft.common.data.utils.ArmorStorage;
import com.nukateam.nukacraft.common.datagen.utils.annotations.ItemModelGen;
import com.nukateam.nukacraft.common.foundation.items.armor.GeoArmorItem;
import com.nukateam.nukacraft.common.foundation.items.misc.PipBoyItem;
import com.nukateam.nukacraft.common.foundation.materials.ModArmorMaterials;
import java.util.List;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class NukaArmorItems {
    public static final List<Pair<ArmorItem.Type, String>> ARMOR_SLOTS = List.of(Pair.of((Object)ArmorItem.Type.HELMET, (Object)"helmet"), Pair.of((Object)ArmorItem.Type.CHESTPLATE, (Object)"chest"), Pair.of((Object)ArmorItem.Type.LEGGINGS, (Object)"leggins"), Pair.of((Object)ArmorItem.Type.BOOTS, (Object)"boots"));
    public static final List<Pair<ArmorItem.Type, String>> CLOTH_SLOTS = List.of(Pair.of((Object)ArmorItem.Type.CHESTPLATE, (Object)"chest"), Pair.of((Object)ArmorItem.Type.LEGGINGS, (Object)"leggins"), Pair.of((Object)ArmorItem.Type.BOOTS, (Object)"boots"));
    public static final List<Pair<ArmorItem.Type, String>> CLOTH_WITHOUT_BOOTS = List.of(Pair.of((Object)ArmorItem.Type.CHESTPLATE, (Object)"chest"), Pair.of((Object)ArmorItem.Type.LEGGINGS, (Object)"leggins"));
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"nukacraft");
    @ItemModelGen(path="armor")
    public static final ArmorStorage WOODEN_SET = NukaArmorItems.registerArmorSet("wooden", ModArmorMaterials.WOOD);
    @ItemModelGen(path="armor")
    public static final ArmorStorage LEATHER_SET = NukaArmorItems.registerArmorSet("leather", ModArmorMaterials.HARDLEATHER);
    @ItemModelGen(path="armor")
    public static final ArmorStorage VAULT_DWELLER_SET = NukaArmorItems.registerClothSet("vault_dweller", ModArmorMaterials.CLOTH);
    @ItemModelGen(path="armor")
    public static final ArmorStorage VAULT_SCIENTIST_SET = NukaArmorItems.registerClothSetWithoutBoots("vault_science", ModArmorMaterials.CLOTH);
    @ItemModelGen(path="armor")
    public static final ArmorStorage RAIDER_SET = NukaArmorItems.registerArmorSet("raiders", ModArmorMaterials.RAIDER);
    @ItemModelGen(path="armor")
    public static final ArmorStorage METAL_SET = NukaArmorItems.registerArmorSet("metal", ModArmorMaterials.METAL);
    @ItemModelGen(path="armor")
    public static final ArmorStorage TRAPPER_SET = NukaArmorItems.registerArmorSet("trapper", ModArmorMaterials.TRAPPER);
    @ItemModelGen(path="armor")
    public static final ArmorStorage SCOUT_SET = NukaArmorItems.registerArmorSet("scout", ModArmorMaterials.SCOUT);
    @ItemModelGen(path="armor")
    public static final ArmorStorage VAULT_SECURITY_SET = NukaArmorItems.registerArmorSet("vault_security", ModArmorMaterials.SCOUT);
    @ItemModelGen(path="armor")
    public static final ArmorStorage COMBAT_SET = NukaArmorItems.registerArmorSet("combat", ModArmorMaterials.COMBAT);
    @ItemModelGen(path="armor")
    public static final ArmorStorage ROBOT_SET = NukaArmorItems.registerArmorSet("robot", ModArmorMaterials.ROBOT);
    public static final RegistryObject<Item> PIP_BOY_D = ITEMS.register("pipboy", () -> new PipBoyItem("default", new Item.Properties().m_41487_(1)));

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }

    private static ArmorStorage registerArmorSet(String name, ArmorMaterial material) {
        return NukaArmorItems.registerSet(name, material, ARMOR_SLOTS);
    }

    private static ArmorStorage registerClothSet(String name, ArmorMaterial material) {
        return NukaArmorItems.registerSet(name, material, CLOTH_SLOTS);
    }

    private static ArmorStorage registerClothSetWithoutBoots(String name, ArmorMaterial material) {
        return NukaArmorItems.registerSet(name, material, CLOTH_WITHOUT_BOOTS);
    }

    private static ArmorStorage registerSet(String name, ArmorMaterial material, List<Pair<ArmorItem.Type, String>> slots) {
        ArmorStorage armorSet = new ArmorStorage();
        for (Pair<ArmorItem.Type, String> slot : slots) {
            RegistryObject<Item> item = NukaArmorItems.registerArmor(name, slot, material);
            armorSet.put((ArmorItem.Type)slot.getFirst(), item);
        }
        return armorSet;
    }

    private static RegistryObject<Item> registerArmor(String name, Pair<ArmorItem.Type, String> slot, ArmorMaterial material) {
        String id = name + "_" + (String)slot.getSecond();
        return ITEMS.register(id, () -> new GeoArmorItem(name, material, (ArmorItem.Type)slot.getFirst(), new Item.Properties()));
    }
}

