/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.client.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nukateam.nukacraft.common.foundation.world.BiomeSettings;
import com.nukateam.nukacraft.common.foundation.world.ModBiomes;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nukacraft", value={Dist.CLIENT})
public class FogEventHandler {
    private static double fogX;
    private static double fogZ;
    private static boolean fogInit;
    private static float fogFarPlaneDistance;

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        Entity entity = event.getCamera().m_90592_();
        Level world = entity.m_9236_();
        int playerX = Mth.m_14143_((float)((float)entity.m_20182_().m_7096_()));
        int playerY = Mth.m_14143_((float)((float)entity.m_20182_().m_7098_()));
        int playerZ = Mth.m_14143_((float)((float)entity.m_20182_().m_7094_()));
        if ((double)playerX == fogX && (double)playerZ == fogZ && fogInit) {
            FogEventHandler.renderFog(event.getMode(), fogFarPlaneDistance, 0.75f);
            return;
        }
        fogInit = true;
        int distance = 20;
        float fpDistanceBiomeFog = 0.0f;
        int weightBiomeFog = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                pos.m_122178_(playerX + x, 0, playerZ + z);
                Holder biome = world.m_204166_((BlockPos)pos);
                BiomeSettings settings = ModBiomes.getBiomeSettings((Holder<Biome>)biome);
                if (settings == null) continue;
                float distancePart = settings.getFogDensity();
                float weightPart = 1.0f;
                if (x == -distance) {
                    xDiff = 1.0 - (entity.m_20182_().m_7096_() - (double)playerX);
                    distancePart = (float)((double)distancePart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                } else if (x == distance) {
                    xDiff = entity.m_20182_().m_7096_() - (double)playerX;
                    distancePart = (float)((double)distancePart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (entity.m_20182_().m_7094_() - (double)playerZ);
                    distancePart = (float)((double)distancePart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                } else if (z == distance) {
                    zDiff = entity.m_20182_().m_7094_() - (double)playerZ;
                    distancePart = (float)((double)distancePart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                }
                fpDistanceBiomeFog += distancePart;
                weightBiomeFog = (int)((float)weightBiomeFog + weightPart);
            }
        }
        float weightMixed = distance * 2 * (distance * 2);
        float weightDefault = weightMixed - (float)weightBiomeFog;
        float fpDistanceBiomeFogAvg = weightBiomeFog == 0 ? 0.0f : fpDistanceBiomeFog / (float)weightBiomeFog;
        float farPlaneDistance = (fpDistanceBiomeFog * 240.0f + event.getFarPlaneDistance() * weightDefault) / weightMixed;
        float farPlaneDistanceScaleBiome = 0.1f * (1.0f - fpDistanceBiomeFogAvg) + 0.75f * fpDistanceBiomeFogAvg;
        float farPlaneDistanceScale = (farPlaneDistanceScaleBiome * (float)weightBiomeFog + 0.75f * weightDefault) / weightMixed;
        fogX = entity.m_20182_().m_7096_();
        fogZ = entity.m_20182_().m_7094_();
        fogFarPlaneDistance = Math.min(farPlaneDistance, event.getFarPlaneDistance());
        FogEventHandler.renderFog(event.getMode(), fogFarPlaneDistance, farPlaneDistanceScale);
    }

    private static void renderFog(FogRenderer.FogMode fogMode, float farPlaneDistance, float farPlaneDistanceScale) {
        if (fogMode == FogRenderer.FogMode.FOG_SKY) {
            RenderSystem.setShaderTexture((int)0, (int)0);
            RenderSystem.setShaderFogStart((float)0.0f);
            RenderSystem.setShaderFogEnd((float)farPlaneDistance);
        } else {
            RenderSystem.setShaderTexture((int)0, (int)0);
            RenderSystem.setShaderFogStart((float)(farPlaneDistance * farPlaneDistanceScale));
            RenderSystem.setShaderFogEnd((float)farPlaneDistance);
        }
    }
}

