/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.client.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.nukateam.nukacraft.common.data.utils.ExplosionType;
import com.nukateam.nukacraft.common.data.utils.Resources;
import com.nukateam.nukacraft.common.foundation.entities.misc.NuclearExplosionEffectEntity;
import com.nukateam.nukacraft.common.foundation.entities.misc.NuclearExplosionEntity;
import com.nukateam.nukacraft.common.registery.entities.ModEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExplosionUtils {
    public static final ResourceLocation BOMB_FLASH = Resources.nukaResource("textures/misc/bomb_flash.png");
    public static final int EXPLOSION_SEARCH_DISTANCE = 45;
    public static int lastTremorTick = -1;

    @OnlyIn(value=Dist.CLIENT)
    public static void preScreenRender(float partialTick) {
        Double screenEffectIntensity = (Double)Minecraft.m_91087_().f_91066_.m_231924_().m_231551_();
        ExplosionUtils.getNukesAround().forEach(nuke -> {
            float nukeFlashAmount = ExplosionUtils.getNukeFlashAmount(nuke, partialTick);
            ExplosionUtils.createFlash(screenEffectIntensity, nukeFlashAmount);
        });
    }

    public static void createNuclearExplosion(Entity entity, ExplosionType type) {
        Level level = entity.m_9236_();
        NuclearExplosionEntity explosion = (NuclearExplosionEntity)((EntityType)ModEntities.NUCLEAR_EXPLOSION.get()).m_20615_(level);
        explosion.m_20359_(entity);
        explosion.setSize(type.size());
        level.m_7967_((Entity)explosion);
        NuclearExplosionEffectEntity explosionEffect = (NuclearExplosionEffectEntity)((EntityType)ModEntities.NUCLEAR_EXPLOSION_EFFECT.get()).m_20615_(level);
        explosionEffect.m_20359_(entity);
        explosionEffect.setType(type);
        level.m_7967_((Entity)explosionEffect);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ArrayList<NuclearExplosionEffectEntity> getNukesAround() {
        Minecraft minecraft = Minecraft.m_91087_();
        ArrayList<NuclearExplosionEffectEntity> result = new ArrayList<NuclearExplosionEffectEntity>();
        if (minecraft.f_91074_ == null) {
            return result;
        }
        List explosions = minecraft.f_91073_.m_6249_((Entity)minecraft.f_91074_, minecraft.f_91074_.m_20191_().m_82400_(45.0), entity -> entity instanceof NuclearExplosionEffectEntity);
        explosions.forEach(entity -> result.add((NuclearExplosionEffectEntity)((Object)entity)));
        return result;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static Double getDistanceToNearestExplosion() {
        ArrayList<NuclearExplosionEffectEntity> nukes = ExplosionUtils.getNukesAround();
        if (nukes.isEmpty()) {
            return null;
        }
        return ExplosionUtils.min(nukes, nuke -> nuke.getDistanceToPlayer());
    }

    public static <T> Double min(List<T> list, Function<T, Double> comparator) {
        Double min = comparator.apply(list.get(0));
        for (T t : list) {
            Double num = comparator.apply(t);
            if (!(num < min)) continue;
            min = num;
        }
        return min;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getNukeFlashAmount(NuclearExplosionEffectEntity entity, float partialTicks) {
        return entity.prevNukeFlashAmount + (entity.nukeFlashAmount - entity.prevNukeFlashAmount) * partialTicks;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void createFlash(double screenEffectIntensity, float nukeFlashAmount) {
        if (nukeFlashAmount > 0.0f) {
            int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
            int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(nukeFlashAmount * (float)screenEffectIntensity));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BOMB_FLASH);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_5483_(0.0, (double)screenHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)screenWidth, (double)screenHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)screenWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
            tesselator.m_85914_();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

