/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.client.models;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.nukateam.chassis_core.common.foundation.item.StackUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class GunIconModels
implements IUnbakedGeometry<GunIconModels> {
    @Nonnull
    private final ItemStack stack;

    public GunIconModels(ItemStack stack) {
        this.stack = stack;
    }

    public GunIconModels withStack(ItemStack stack) {
        return new GunIconModels(stack);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker modelBaker, Function<Material, TextureAtlasSprite> function, ModelState modelState, ItemOverrides itemOverrides, ResourceLocation resourceLocation) {
        Material particleLocation = GunIconModels.getMaterial(context, "particle");
        TextureAtlasSprite particleSprite = particleLocation != null ? function.apply(particleLocation) : null;
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(resourceLocation);
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ItemOverrideHandler(itemOverrides, modelBaker, (IGeometryBakingContext)itemContext, this), (ItemTransforms)context.getTransforms());
        String skin = StackUtils.getVariant((ItemStack)this.stack);
        Material baseMaterial = new Material(InventoryMenu.f_39692_, GunIconModels.getTexture(GunIconModels.getItemName(this.stack), skin));
        Material baseLocation = GunIconModels.getMaterial(context, "base");
        TextureAtlasSprite sprite = !this.stack.m_41619_() ? function.apply(baseMaterial) : function.apply(baseLocation);
        List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)sprite.m_245424_());
        List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)modelState, (ResourceLocation)resourceLocation);
        builder.addQuads(GunIconModels.getLayerRenderTypes(), (Collection)quads);
        builder.setParticle(particleSprite);
        return builder.build();
    }

    private static String getItemName(ItemStack stack) {
        return ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
    }

    private static ResourceLocation getTexture(String nameItem, String skin) {
        return new ResourceLocation("nukacraft", "item/dynamic/" + nameItem + "/" + nameItem + "_" + skin);
    }

    public static RenderTypeGroup getLayerRenderTypes() {
        return new RenderTypeGroup(RenderType.m_110466_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    @Nullable
    private static Material getMaterial(IGeometryBakingContext context, String base) {
        return context.hasMaterial(base) ? context.getMaterial(base) : null;
    }

    private static final class ItemOverrideHandler
    extends ItemOverrides {
        private final ItemOverrides nested;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;
        private final GunIconModels parent;

        private ItemOverrideHandler(ItemOverrides nested, ModelBaker baker, IGeometryBakingContext owner, GunIconModels parent) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int integer) {
            BakedModel overriden = this.nested.m_173464_(originalModel, stack, level, entity, integer);
            if (overriden != originalModel) {
                return overriden;
            }
            if (!StackUtils.getVariant((ItemStack)stack).equals("default")) {
                GunIconModels unbaked = this.parent.withStack(stack);
                BakedModel bakedModel = unbaked.bake(this.owner, this.baker, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, this, new ResourceLocation("nukacraft:gun_icon_override"));
                return bakedModel;
            }
            return originalModel;
        }
    }

    public static enum Loader implements IGeometryLoader<GunIconModels>
    {
        INSTANCE;


        public GunIconModels read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            return new GunIconModels(ItemStack.f_41583_);
        }
    }
}

