/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.client.models;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nukateam.chassis_core.common.foundation.item.StackUtils;
import com.nukateam.nukacraft.common.data.utils.Resources;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GunIconModelsTest
implements IUnbakedGeometry<GunIconModelsTest> {
    @Nonnull
    private final ItemStack stack;
    private BlockModel baseModel = null;
    private ImmutableMap<ItemDisplayContext, BlockModel> perspectives = null;

    public GunIconModelsTest(BlockModel baseModel, ImmutableMap<ItemDisplayContext, BlockModel> perspectives, ItemStack stack) {
        this.stack = stack;
        this.baseModel = baseModel;
        this.perspectives = perspectives;
    }

    public GunIconModelsTest(ItemStack stack) {
        this.stack = stack;
    }

    public GunIconModelsTest withStack(ItemStack stack) {
        return new GunIconModelsTest(null, null, stack);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker modelBaker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides itemOverrides, ResourceLocation resourceLocation) {
        ImmutableMap map = ImmutableMap.copyOf((Map)Maps.transformValues(this.perspectives, value -> value.m_111449_(modelBaker, value, spriteGetter, modelState, resourceLocation, context.useBlockLight())));
        BakedModel backedModel = this.baseModel.m_111449_(modelBaker, this.baseModel, spriteGetter, modelState, resourceLocation, context.useBlockLight());
        return new Baked(this, context, modelBaker, spriteGetter, modelState, itemOverrides, resourceLocation, spriteGetter.apply(context.getMaterial("particle")), itemOverrides, backedModel, (ImmutableMap<ItemDisplayContext, BakedModel>)map);
    }

    @NotNull
    private BakedModel getIconModel(IGeometryBakingContext context, ModelBaker modelBaker, Function<Material, TextureAtlasSprite> function, ModelState modelState, ItemOverrides itemOverrides, ResourceLocation resourceLocation) {
        Material particleLocation = GunIconModelsTest.getMaterial(context, "particle");
        TextureAtlasSprite particleSprite = particleLocation != null ? function.apply(particleLocation) : null;
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(resourceLocation);
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ItemOverrideHandler(itemOverrides, modelBaker, (IGeometryBakingContext)itemContext, this), (ItemTransforms)context.getTransforms());
        String skin = StackUtils.getVariant((ItemStack)this.stack);
        Material baseMaterial = new Material(InventoryMenu.f_39692_, GunIconModelsTest.getTexture(GunIconModelsTest.getItemName(this.stack), skin));
        Material baseLocation = GunIconModelsTest.getMaterial(context, "base");
        TextureAtlasSprite sprite = !this.stack.m_41619_() ? function.apply(baseMaterial) : function.apply(baseLocation);
        List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)sprite.m_245424_());
        List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)modelState, (ResourceLocation)resourceLocation);
        builder.addQuads(GunIconModelsTest.getLayerRenderTypes(), (Collection)quads);
        builder.setParticle(particleSprite);
        return builder.build();
    }

    private static String getItemName(ItemStack stack) {
        return ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
    }

    private static ResourceLocation getTexture(String nameItem, String skin) {
        return new ResourceLocation("nukacraft", "item/dynamic/" + nameItem + "/" + nameItem + "_" + skin);
    }

    public static RenderTypeGroup getLayerRenderTypes() {
        return new RenderTypeGroup(RenderType.m_110466_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    @Nullable
    private static Material getMaterial(IGeometryBakingContext context, String base) {
        return context.hasMaterial(base) ? context.getMaterial(base) : null;
    }

    public static class Baked
    implements IDynamicBakedModel {
        private final GunIconModelsTest gunIconModels;
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        @NotNull
        private final IGeometryBakingContext context;
        private final ModelBaker modelBaker;
        private final Function<Material, TextureAtlasSprite> function;
        private final ModelState modelState;
        private final ItemOverrides itemOverrides;
        private final ResourceLocation resourceLocation;
        private final TextureAtlasSprite particle;
        private final ItemOverrides overrides;
        private final BakedModel baseModel;
        private final ImmutableMap<ItemDisplayContext, BakedModel> perspectives;

        public Baked(GunIconModelsTest gunIconModels, IGeometryBakingContext context, ModelBaker modelBaker, Function<Material, TextureAtlasSprite> function, ModelState modelState, ItemOverrides itemOverrides, ResourceLocation resourceLocation, TextureAtlasSprite particle, ItemOverrides overrides, BakedModel baseModel, ImmutableMap<ItemDisplayContext, BakedModel> perspectives) {
            this.gunIconModels = gunIconModels;
            this.isAmbientOcclusion = context.useAmbientOcclusion();
            this.isGui3d = context.isGui3d();
            this.isSideLit = context.useBlockLight();
            this.context = context;
            this.modelBaker = modelBaker;
            this.function = function;
            this.modelState = modelState;
            this.itemOverrides = itemOverrides;
            this.resourceLocation = resourceLocation;
            this.particle = particle;
            this.overrides = overrides;
            this.baseModel = baseModel;
            this.perspectives = perspectives;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            return this.baseModel.getQuads(state, side, rand, data, renderType);
        }

        public boolean m_7541_() {
            return this.isAmbientOcclusion;
        }

        public boolean m_7539_() {
            return this.isGui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public ItemTransforms m_7442_() {
            return ItemTransforms.f_111786_;
        }

        public BakedModel applyTransform(ItemDisplayContext display, PoseStack poseStack, boolean applyLeftHandTransform) {
            return super.applyTransform(display, poseStack, applyLeftHandTransform);
        }

        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            return this.baseModel.getRenderTypes(state, rand, data);
        }
    }

    private static final class ItemOverrideHandler
    extends ItemOverrides {
        private final ItemOverrides nested;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;
        private final GunIconModelsTest parent;

        private ItemOverrideHandler(ItemOverrides nested, ModelBaker baker, IGeometryBakingContext owner, GunIconModelsTest parent) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int integer) {
            BakedModel overriden = this.nested.m_173464_(originalModel, stack, level, entity, integer);
            if (overriden != originalModel) {
                return overriden;
            }
            if (!StackUtils.getVariant((ItemStack)stack).equals("default")) {
                GunIconModelsTest unbaked = this.parent.withStack(stack);
                BakedModel bakedModel = unbaked.bake(this.owner, this.baker, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, this, Resources.nukaResource("gun_icon_override"));
                return bakedModel;
            }
            return originalModel;
        }
    }

    public static enum Loader implements IGeometryLoader<GunIconModelsTest>
    {
        INSTANCE;


        public GunIconModelsTest read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            return new GunIconModelsTest(ItemStack.f_41583_);
        }
    }
}

