/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.client.models.entity;

import com.nukateam.nukacraft.client.models.entity.EntityModel;
import com.nukateam.nukacraft.common.data.utils.Resources;
import com.nukateam.nukacraft.common.foundation.entities.mobs.Deathclaw;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.data.EntityModelData;

public class DeathclawModel<Type extends Deathclaw>
extends EntityModel<Type> {
    private static final ResourceLocation model = Resources.nukaResource("geo/entity/deathclaw.geo.json");
    private static final ResourceLocation animation = Resources.nukaResource("animations/entity/deathclaw.animation.json");

    @Override
    public ResourceLocation getTextureResource(Type object) {
        return Resources.nukaResource("textures/entity/deathclaw/" + ((Deathclaw)((Object)object)).getVariant().getTexture() + ".png");
    }

    @Override
    public void setCustomAnimations(Type animatable, long instanceId, AnimationState<Type> animationState) {
        super.setCustomAnimations(animatable, instanceId, animationState);
        DeathclawModel.setHeadAnimation(animatable, this.getAnimationProcessor(), animationState);
    }

    public RenderType getRenderType(Type animatable, ResourceLocation texture) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureResource(animatable));
    }

    public static void setHeadAnimation(CoreGeoBone head, AnimationState animationState) {
        if (head != null) {
            EntityModelData data = (EntityModelData)animationState.getExtraData().get(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(data.headPitch() * ((float)Math.PI / 180));
            head.setRotY(data.netHeadYaw() * ((float)Math.PI / 180));
        }
    }

    public static void setHeadAnimation(LivingEntity animatable, AnimationProcessor animationProcessor, AnimationState animationState) {
        CoreGeoBone head = animationProcessor.getBone("head");
        if (head != null) {
            DeathclawModel.setHeadAnimation(head, animationState);
        }
    }
}

