/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.client.render.particles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nukateam.nukacraft.common.foundation.sounds.NuclearExplosionSound;
import com.nukateam.nukacraft.common.registery.ModParticles;
import com.nukateam.nukacraft.common.registery.ModSounds;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class MushroomCloudParticle
extends Particle {
    private static final int BALL_FOR = 10;
    private static final int FADE_SPEED = 10;
    private final float scale;
    private boolean playedRinging;
    private boolean playedExplosion;
    private boolean playedRumble;

    protected MushroomCloudParticle(ClientLevel level, double x, double y, double z, float scale) {
        super(level, x, y, z);
        this.f_107226_ = 0.0f;
        this.f_107225_ = (int)Math.ceil(133.33f * scale);
        this.scale = scale + 0.2f;
        this.m_107250_(3.0f, 3.0f);
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5989_() {
        if (this.f_107224_ > 0 && !this.playedExplosion) {
            this.playedExplosion = true;
            this.playSound((SoundEvent)ModSounds.NUCLEAR_EXPLOSION.get(), this.f_107225_ - 20, this.f_107225_, 0.2f, false);
        }
        if (this.f_107224_ < 10) {
            if (!this.playedRinging) {
                this.playedRinging = true;
                this.playSound((SoundEvent)ModSounds.NUCLEAR_EXPLOSION_RINGING.get(), 100, 50, 0.05f, true);
            }
        } else if (this.f_107224_ < this.f_107225_ - 10) {
            float life = (float)Math.log(1.0f + (float)(this.f_107224_ - 10) / (float)(this.f_107225_ - 10)) * 2.0f;
            float explosionSpread = (12.0f * life + 4.0f) * this.scale;
            int i = 0;
            while ((float)i < (float)(1 + this.f_107223_.m_188503_(2)) * this.scale) {
                Vec3 from = new Vec3((double)(this.f_107208_.f_46441_.m_188501_() - 0.5f), (double)(this.f_107208_.f_46441_.m_188501_() - 0.5f), (double)(this.f_107208_.f_46441_.m_188501_() - 0.5f)).m_82490_((double)(this.scale * 1.4f)).m_82520_(this.f_107212_, this.f_107213_, this.f_107214_);
                Vec3 away = new Vec3((double)(this.f_107208_.f_46441_.m_188501_() - 0.5f), (double)(this.f_107208_.f_46441_.m_188501_() - 0.5f), (double)(this.f_107208_.f_46441_.m_188501_() - 0.5f)).m_82490_((double)2.34f);
                this.f_107208_.m_7106_((ParticleOptions)ModParticles.MUSHROOM_CLOUD_SMOKE.get(), from.f_82479_, from.f_82480_, from.f_82481_, away.f_82479_, away.f_82480_, away.f_82481_);
                ++i;
            }
            int j = 0;
            while ((float)j < this.scale * this.scale) {
                Vec3 explosionBase = new Vec3((double)((this.f_107208_.f_46441_.m_188501_() - 0.5f) * explosionSpread), (double)((-0.6f + this.f_107208_.f_46441_.m_188501_() * 0.5f) * explosionSpread * 0.1f), (double)((this.f_107208_.f_46441_.m_188501_() - 0.5f) * explosionSpread)).m_82520_(this.f_107212_, this.f_107213_, this.f_107214_);
                this.f_107208_.m_7106_((ParticleOptions)ModParticles.MUSHROOM_CLOUD_EXPLOSION.get(), explosionBase.f_82479_, explosionBase.f_82480_, explosionBase.f_82481_, 0.0, 0.0, 0.0);
                ++j;
            }
            if (this.f_107224_ > 10 && !this.playedRumble) {
                this.playedRumble = true;
                this.playSound((SoundEvent)ModSounds.NUCLEAR_EXPLOSION_RUMBLE.get(), this.f_107225_ + 100, this.f_107225_, 0.1f, true);
            }
        }
        super.m_5989_();
    }

    private void playSound(SoundEvent soundEvent, int duration, int fadesAt, float fadeInBy, boolean looping) {
        Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)new NuclearExplosionSound(soundEvent, this.f_107212_, this.f_107213_, this.f_107214_, duration, fadesAt, fadeInBy, looping));
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_252880_(x, y - 0.5f, z);
        posestack.m_85841_(-this.scale, -this.scale, this.scale);
        posestack.m_85849_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (xSpeed == 0.0) {
                xSpeed = 1.0;
            }
            return new MushroomCloudParticle(level, x, y, z, (float)Math.max(0.5, xSpeed));
        }
    }
}

