/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.client.render.renderers.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;

public class CustomTexturedModel
implements BakedModel {
    private final BakedModel baseModel;
    private final String textureType;

    public CustomTexturedModel(BakedModel baseModel, String textureType) {
        this.baseModel = baseModel;
        this.textureType = textureType;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource random) {
        ArrayList quads = new ArrayList(this.baseModel.m_213637_(state, side, random));
        ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>();
        for (BakedQuad quad : quads) {
            TextureAtlasSprite sprite = this.getTextureForType(this.textureType);
            if (sprite != null) {
                BakedQuad newQuad = new BakedQuad(quad.m_111303_(), quad.m_111305_(), quad.m_111306_(), sprite, quad.m_111307_());
                newQuads.add(newQuad);
                continue;
            }
            newQuads.add(quad);
        }
        return newQuads;
    }

    private TextureAtlasSprite getTextureForType(String textureType) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("nukacraft", "item/dynamic/pistol10mm/pistol10mm_" + textureType));
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.baseModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }
}

