/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.data.enums;

import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum HeartType {
    CONTAINER(0, false),
    NORMAL(2, true),
    POISIONED(4, true),
    WITHERED(6, true),
    ABSORBING(8, false),
    FROZEN(9, false);

    private final int index;
    private final boolean canBlink;

    private HeartType(int pIndex, boolean pCanBlink) {
        this.index = pIndex;
        this.canBlink = pCanBlink;
    }

    public static HeartType forPlayer(Player pPlayer) {
        HeartType gui$hearttype = pPlayer.m_21023_(MobEffects.f_19614_) ? POISIONED : (pPlayer.m_21023_(MobEffects.f_19615_) ? WITHERED : (pPlayer.m_146890_() ? FROZEN : NORMAL));
        return gui$hearttype;
    }

    public int getX(boolean isHalf, boolean highlight) {
        int x;
        if (this == CONTAINER) {
            x = highlight ? 1 : 0;
        } else {
            int halfX = isHalf ? 1 : 0;
            int highlightX = this.canBlink && highlight ? 2 : 0;
            x = halfX + highlightX;
        }
        return 16 + (this.index * 2 + x) * 9;
    }
}

