/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.data.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nukateam.nukacraft.client.helpers.NbtColor;
import com.nukateam.nukacraft.common.data.utils.Resources;
import com.nukateam.nukacraft.common.data.utils.SlotUtils;
import com.nukateam.nukacraft.common.foundation.items.misc.PipBoyItem;
import com.nukateam.nukacraft.common.registery.ModAttributes;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class PipBoyUtils {
    public static ResourceLocation warning_image = new ResourceLocation("nukacraft:textures/screens/pipboy_screens/warning_pipboy.png");
    public static Integer[] warn_cords = new Integer[]{-8, -22};

    public static int getPlayerRads(Player player) {
        double radVal = player.m_21133_((Attribute)ModAttributes.RADIATION.get());
        return Mth.m_14165_((double)radVal);
    }

    public static void setPipboyShader() {
        PipBoyUtils.setPipboyShader(1.0f);
    }

    public static void setPipboyShader(float alpha) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        NbtColor color = PipBoyUtils.getScreenColor((Player)mc.f_91074_);
        RenderSystem.setShaderColor((float)color.red, (float)color.green, (float)color.blue, (float)alpha);
    }

    public static void setScreenColor(@NotNull NbtColor color, @NotNull Player player) {
        ItemStack stack = PipBoyUtils.getPipboyStack(player);
        if (stack.m_41720_() instanceof PipBoyItem) {
            CompoundTag pipBoyTag = stack.m_41784_();
            pipBoyTag.m_128365_("color", (Tag)color.serializeNBT());
        }
    }

    public static NbtColor getScreenColor(@NotNull Player player) {
        ItemStack pipboyStack = PipBoyUtils.getPipboyStack(player);
        CompoundTag pipboyTag = pipboyStack.m_41784_();
        NbtColor color = new NbtColor();
        if (!pipboyStack.m_41619_() && pipboyTag.m_128441_("color")) {
            color.deserializeNBT(pipboyTag.m_128469_("color"));
            return color;
        }
        return color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasPipboy() {
        return PipBoyUtils.hasPipboy((Player)Minecraft.m_91087_().f_91074_);
    }

    public static boolean hasPipboy(Player player) {
        return PipBoyUtils.getPipboyStack(player).m_41720_() instanceof PipBoyItem;
    }

    public static ItemStack getPipboyStack(Player player) {
        ItemStack pipboy = ItemStack.f_41583_;
        ItemStack offhand = player.m_21206_();
        ItemStack curiosPipboy = SlotUtils.getCuriosPipboy(player);
        if (offhand.m_41720_() instanceof PipBoyItem) {
            pipboy = offhand;
        }
        if (curiosPipboy.m_41720_() instanceof PipBoyItem) {
            pipboy = curiosPipboy;
        }
        return pipboy;
    }

    public static ResourceLocation getPipboySkin(Player player) {
        ItemStack slot = PipBoyUtils.getPipboyStack(player);
        if (slot.m_41720_() instanceof PipBoyItem) {
            return Resources.nukaResource("textures/screens/default_pipboy.png");
        }
        return Resources.nukaResource("textures/screens/pipboy2000_default.png");
    }
}

