/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.datagen.loot;

import com.nukateam.nukacraft.common.datagen.DataGenUtils;
import com.nukateam.nukacraft.common.datagen.utils.annotations.LootIgnored;
import com.nukateam.nukacraft.common.datagen.utils.records.LootData;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public abstract class ModEntityLootTables
extends EntityLootSubProvider {
    private final Class<?>[] registryClasses;

    public ModEntityLootTables(Class<?> ... registryClasses) {
        super(FeatureFlags.f_244280_.m_247355_());
        this.registryClasses = registryClasses;
    }

    protected void simpleLoot(EntityType<?> entity, LootData ... loots) {
        LootTable.Builder builder = LootTable.m_79147_();
        for (LootData loot : loots) {
            builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)loot.chance())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)loot.drop())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)loot.min(), (float)loot.max()))));
        }
        this.m_245309_(entity, builder);
    }

    protected void cowLikeLoot(EntityType<?> entity, LootData meat, LootData ... drops) {
        LootTable.Builder builder = LootTable.m_79147_();
        for (LootData drop : drops) {
            builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)drop.chance())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drop.drop()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)drop.min(), (float)drop.max()))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))));
        }
        builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)meat.chance())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)meat.drop()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)meat.min(), (float)meat.max()))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_())))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))));
        this.m_245309_(entity, builder);
    }

    protected Stream<EntityType<?>> getKnownEntityTypes() {
        ArrayList result = new ArrayList();
        for (Class<?> registry : this.registryClasses) {
            result.addAll(ModEntityLootTables.getMobs(registry));
        }
        return result.stream();
    }

    @NotNull
    private static ArrayList<EntityType<?>> getMobs(Class<?> registryClass) {
        ArrayList result = new ArrayList();
        DataGenUtils.handleFields(registryClass, (obj, field) -> {
            RegistryObject registry;
            if (obj instanceof RegistryObject && (registry = (RegistryObject)obj).get() instanceof EntityType) {
                EntityType entityType = (EntityType)registry.get();
                if (!field.isAnnotationPresent(LootIgnored.class)) {
                    result.add(entityType);
                }
            }
        });
        return result;
    }
}

