/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.events;

import com.nukateam.nukacraft.common.events.RadiationTracker;
import com.nukateam.nukacraft.common.registery.ModAttributes;
import com.nukateam.nukacraft.common.registery.fluid.ModFluids;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import oshi.util.tuples.Pair;

@Mod.EventBusSubscriber
public class CustomHandler {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AttributeInstance rad = player.m_21051_((Attribute)ModAttributes.RADIATION.get());
            rad.m_22100_(0.0);
            for (AttributeModifier mod : rad.m_22122_()) {
                if (!mod.m_22214_().equals("radiation")) continue;
                rad.m_22130_(mod);
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        RadiationTracker.radiationTrackers.values().forEach(val -> {
            if (val.player == event.player) {
                val.onPlayerTick(event);
            }
        });
    }

    @SubscribeEvent
    public static void whenFluidsMeet(BlockEvent.FluidPlaceBlockEvent event) {
        FluidState fluidState = event.getOriginalState().m_60819_();
        if (fluidState.m_76170_()) {
            CustomHandler.extracted(event, fluidState, fluid -> {
                Pair<Block, Block> lavaInteraction = ModFluids.getLavaInteraction(fluid);
                if (lavaInteraction == null) {
                    return null;
                }
                return (Block)lavaInteraction.getA();
            });
        } else {
            CustomHandler.extracted(event, fluidState, fluid -> {
                Pair<Block, Block> lavaInteraction = ModFluids.getLavaInteraction(fluid);
                if (lavaInteraction == null) {
                    return null;
                }
                return (Block)lavaInteraction.getB();
            });
        }
    }

    private static void extracted(BlockEvent.FluidPlaceBlockEvent event, FluidState fluidState, Function<FluidState, Block> function) {
        LevelAccessor world = event.getLevel();
        BlockPos pos = event.getPos();
        for (Direction direction : Direction.values()) {
            Block block;
            FluidState metFluidState;
            FluidState fluidState2 = metFluidState = fluidState.m_76170_() ? fluidState : world.m_6425_(pos.m_121945_(direction));
            if (!metFluidState.m_205070_(FluidTags.f_13131_) || (block = function.apply(metFluidState)) == null) continue;
            event.setNewState(block.m_49966_());
            break;
        }
    }
}

