/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.blocks.blocks;

import com.nukateam.nukacraft.common.data.utils.VoxelShapeHelper;
import com.nukateam.nukacraft.common.foundation.entities.blocks.BasicStorageEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasicStorageBlock
extends BarrelBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();
    private String model;

    public BasicStorageBlock(BlockBehaviour.Properties pProperties, String model) {
        super(pProperties);
        this.model = model;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_49042_, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof BasicStorageEntity) {
            pPlayer.m_5893_((MenuProvider)((BasicStorageEntity)blockentity));
            pPlayer.m_36220_(Stats.f_12971_);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)((Container)blockentity));
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof BasicStorageEntity) {
            ((BasicStorageEntity)blockentity).recheckOpen();
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BasicStorageEntity(pPos, pState);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack stack) {
        BlockEntity blockentity;
        if (stack.m_41788_() && (blockentity = pLevel.m_7702_(pPos)) instanceof BasicStorageEntity) {
            ((BasicStorageEntity)blockentity).m_58638_(stack.m_41786_());
        }
    }

    private VoxelShape getShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_49042_);
        if (this.SHAPES.containsKey(state)) {
            return this.SHAPES.get(state);
        }
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        switch (this.model) {
            case "SideHalf": {
                switch (direction) {
                    case EAST: {
                        shapes.add(BasicStorageBlock.m_49796_((double)7.01, (double)0.01, (double)0.010000000000001563, (double)15.99, (double)15.99, (double)15.990000000000002));
                        break;
                    }
                    case WEST: {
                        shapes.add(BasicStorageBlock.m_49796_((double)0.009999999999999787, (double)0.01, (double)0.010000000000001563, (double)8.99, (double)15.99, (double)15.990000000000002));
                        break;
                    }
                    case SOUTH: {
                        shapes.add(BasicStorageBlock.m_49796_((double)0.01, (double)0.01, (double)7.01, (double)15.99, (double)15.99, (double)15.99));
                        break;
                    }
                    case NORTH: {
                        shapes.add(BasicStorageBlock.m_49796_((double)0.01, (double)0.01, (double)0.01, (double)15.99, (double)15.99, (double)8.99));
                    }
                }
                break;
            }
            case "MedicStore": {
                switch (direction) {
                    case EAST: {
                        shapes.add(BasicStorageBlock.m_49796_((double)7.01, (double)0.01, (double)0.010000000000001563, (double)15.99, (double)9.99, (double)15.990000000000002));
                        break;
                    }
                    case WEST: {
                        shapes.add(BasicStorageBlock.m_49796_((double)0.009999999999999787, (double)0.01, (double)0.010000000000001563, (double)8.99, (double)9.99, (double)15.990000000000002));
                        break;
                    }
                    case SOUTH: {
                        shapes.add(BasicStorageBlock.m_49796_((double)0.01, (double)0.01, (double)7.01, (double)15.99, (double)9.99, (double)15.99));
                        break;
                    }
                    case NORTH: {
                        shapes.add(BasicStorageBlock.m_49796_((double)0.01, (double)0.01, (double)0.01, (double)15.99, (double)9.99, (double)8.99));
                    }
                }
                break;
            }
            case "Cabinet": {
                switch (direction) {
                    case EAST: {
                        shapes.add(BasicStorageBlock.m_49796_((double)2.01, (double)0.01, (double)0.010000000000001563, (double)15.99, (double)15.99, (double)15.990000000000002));
                        break;
                    }
                    case WEST: {
                        shapes.add(BasicStorageBlock.m_49796_((double)0.009999999999999787, (double)0.01, (double)0.010000000000001563, (double)12.99, (double)15.99, (double)15.990000000000002));
                        break;
                    }
                    case SOUTH: {
                        shapes.add(BasicStorageBlock.m_49796_((double)0.01, (double)0.01, (double)2.01, (double)15.99, (double)15.99, (double)15.99));
                        break;
                    }
                    case NORTH: {
                        shapes.add(BasicStorageBlock.m_49796_((double)0.01, (double)0.01, (double)0.01, (double)15.99, (double)15.99, (double)12.99));
                    }
                }
                break;
            }
            case "FullBlock": {
                shapes.add(BasicStorageBlock.m_49796_((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)15.9, (double)15.9));
            }
        }
        VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
        this.SHAPES.put(state, shape);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getShape(state);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_49042_, (Comparable)pContext.m_8125_());
    }
}

