/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.blocks.blocks;

import com.nukateam.ntgl.common.util.interfaces.IExplosiveOnHit;
import com.nukateam.nukacraft.common.data.utils.VoxelShapeHelper;
import com.nukateam.nukacraft.common.foundation.entities.blocks.OwnableBlockEntity;
import com.nukateam.nukacraft.common.foundation.entities.misc.PowerArmorFrame;
import com.nukateam.nukacraft.common.foundation.entities.misc.PrimedFragmineEntity;
import com.nukateam.nukacraft.common.registery.ModSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LandMineBlock
extends BaseEntityBlock
implements IExplosiveOnHit {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final int EXPLODE_CHANCE = 60;
    private final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();
    private final Random random = new Random();

    public LandMineBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity entity) {
        PowerArmorFrame frame;
        OwnableBlockEntity ownable;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(pLevel.f_46443_ || !(blockEntity instanceof OwnableBlockEntity) || LandMineBlock.isOwner(entity, ownable = (OwnableBlockEntity)blockEntity) || entity instanceof PowerArmorFrame && (frame = (PowerArmorFrame)entity).m_217005_() && LandMineBlock.isOwner((Entity)frame.m_6688_(), ownable))) {
            this.explode(pLevel, pPos);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        boolean isCorrectBlock;
        boolean shovelInHand = pPlayer.m_21205_().m_41720_() instanceof ShovelItem;
        BlockState floorState = pLevel.m_8055_(pPos.m_7495_());
        boolean bl = isCorrectBlock = floorState.m_204336_(BlockTags.f_144274_) || pState.m_204336_(BlockTags.f_13029_);
        if (shovelInHand && isCorrectBlock) {
            this.pull(pState, pLevel, pPos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public BlockState pull(BlockState pState, Level pLevel, BlockPos pPos) {
        pState = (BlockState)pState.m_61122_((Property)POWERED);
        pLevel.m_7731_(pPos, pState, 3);
        return pState;
    }

    private static boolean isOwner(Entity pEntity, OwnableBlockEntity ownable) {
        return ownable.getOwner().equals(pEntity.m_20148_().toString());
    }

    public void explode(Level pLevel, BlockPos pPos) {
        if (!pLevel.f_46443_) {
            PrimedFragmineEntity mine = new PrimedFragmineEntity(pLevel, (double)pPos.m_123341_() + 0.5, pPos.m_123342_(), (double)pPos.m_123343_() + 0.5, null);
            int i = mine.getFuse();
            mine.setFuse((short)(pLevel.f_46441_.m_188503_(i / 4) + i / 8));
            pLevel.m_7967_((Entity)mine);
            pLevel.m_6263_(null, mine.m_20185_(), mine.m_20186_(), mine.m_20189_(), (SoundEvent)ModSounds.MINE_TICK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_46961_(pPos, false);
        }
    }

    public void explodeOnHit(Level level, BlockPos pos) {
        int i = this.random.nextInt(99);
        if (i < 60 && !level.f_46443_) {
            level.m_46961_(pos, false);
            level.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 6.0f, Level.ExplosionInteraction.NONE);
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (this.SHAPES.containsKey(pState)) {
            return this.SHAPES.get(pState);
        }
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(LandMineBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0999999999999992, (double)11.0));
        VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
        this.SHAPES.put(pState, shape);
        return shape;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack stack) {
        if (pPlacer instanceof Player) {
            Player player = (Player)pPlacer;
            String uuid = player.m_36316_().getId().toString();
            BlockEntity entity = pLevel.m_7702_(pPos);
            if (entity instanceof OwnableBlockEntity) {
                OwnableBlockEntity ownable = (OwnableBlockEntity)entity;
                ownable.setOwner(uuid);
            }
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, stack);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }
}

