/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.blocks.blocks;

import com.nukateam.ntgl.common.util.util.VoxelShapeHelper;
import com.nukateam.nukacraft.common.data.utils.PipBoyUtils;
import com.nukateam.nukacraft.common.foundation.entities.blocks.OpenGearEntity;
import com.nukateam.nukacraft.common.registery.ModSounds;
import com.nukateam.nukacraft.common.registery.blocks.ModBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OpenGearBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public OpenGearBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState pState) {
        return new OpenGearEntity(pos, pState);
    }

    protected void fillFrame(BlockState block, Level world, BlockState baseState, int base_x, int base_y, int base_z) {
        switch ((Direction)baseState.m_61143_((Property)FACING)) {
            case NORTH: {
                for (int posBlocks = 1; posBlocks < 4; ++posBlocks) {
                    world.m_7731_(new BlockPos(base_x - posBlocks, base_y, base_z), block, 3);
                    world.m_7731_(new BlockPos(base_x, base_y + posBlocks, base_z), block, 3);
                    for (int cordBlock = 1; cordBlock < 4; ++cordBlock) {
                        world.m_7731_(new BlockPos(base_x - posBlocks, base_y + cordBlock, base_z), block, 3);
                    }
                }
                break;
            }
            case EAST: {
                for (int posBlocks = 1; posBlocks < 4; ++posBlocks) {
                    world.m_7731_(new BlockPos(base_x, base_y, base_z - posBlocks), block, 3);
                    world.m_7731_(new BlockPos(base_x, base_y + posBlocks, base_z), block, 3);
                    for (int cordBlock = 1; cordBlock < 4; ++cordBlock) {
                        world.m_7731_(new BlockPos(base_x, base_y + cordBlock, base_z - posBlocks), block, 3);
                    }
                }
                break;
            }
            case WEST: {
                for (int posBlocks = 1; posBlocks < 4; ++posBlocks) {
                    world.m_7731_(new BlockPos(base_x, base_y, base_z + posBlocks), block, 3);
                    world.m_7731_(new BlockPos(base_x, base_y + posBlocks, base_z), block, 3);
                    for (int cordBlock = 1; cordBlock < 4; ++cordBlock) {
                        world.m_7731_(new BlockPos(base_x, base_y + cordBlock, base_z + posBlocks), block, 3);
                    }
                }
                break;
            }
            case SOUTH: {
                for (int posBlocks = 1; posBlocks < 4; ++posBlocks) {
                    world.m_7731_(new BlockPos(base_x + posBlocks, base_y, base_z), block, 3);
                    world.m_7731_(new BlockPos(base_x, base_y + posBlocks, base_z), block, 3);
                    for (int cordBlock = 1; cordBlock < 4; ++cordBlock) {
                        world.m_7731_(new BlockPos(base_x + posBlocks, base_y + cordBlock, base_z), block, 3);
                    }
                }
                break;
            }
        }
    }

    protected void filledEraser(Level world, BlockState baseState, int base_x, int base_y, int base_z) {
        BlockState air = Blocks.f_50016_.m_49966_();
        BlockState stairs = ((Block)ModBlocks.HALF_BARRIER.get()).m_49966_();
        switch ((Direction)baseState.m_61143_((Property)FACING)) {
            case NORTH: {
                world.m_7731_(new BlockPos(base_x - 1, base_y + 1, base_z), air, 3);
                world.m_7731_(new BlockPos(base_x - 2, base_y + 1, base_z), air, 3);
                world.m_7731_(new BlockPos(base_x - 1, base_y + 2, base_z), air, 3);
                world.m_7731_(new BlockPos(base_x - 2, base_y + 2, base_z), air, 3);
                world.m_7731_(new BlockPos(base_x - 1, base_y, base_z), stairs, 3);
                world.m_7731_(new BlockPos(base_x - 2, base_y, base_z), stairs, 3);
                break;
            }
            case SOUTH: {
                world.m_7731_(new BlockPos(base_x + 1, base_y + 1, base_z), air, 3);
                world.m_7731_(new BlockPos(base_x + 2, base_y + 1, base_z), air, 3);
                world.m_7731_(new BlockPos(base_x + 1, base_y + 2, base_z), air, 3);
                world.m_7731_(new BlockPos(base_x + 2, base_y + 2, base_z), air, 3);
                world.m_7731_(new BlockPos(base_x + 1, base_y, base_z), stairs, 3);
                world.m_7731_(new BlockPos(base_x + 2, base_y, base_z), stairs, 3);
                break;
            }
            case WEST: {
                world.m_7731_(new BlockPos(base_x, base_y + 1, base_z + 1), air, 3);
                world.m_7731_(new BlockPos(base_x, base_y + 1, base_z + 2), air, 3);
                world.m_7731_(new BlockPos(base_x, base_y + 2, base_z + 1), air, 3);
                world.m_7731_(new BlockPos(base_x, base_y + 2, base_z + 2), air, 3);
                world.m_7731_(new BlockPos(base_x, base_y, base_z + 1), stairs, 3);
                world.m_7731_(new BlockPos(base_x, base_y, base_z + 2), stairs, 3);
                break;
            }
            case EAST: {
                world.m_7731_(new BlockPos(base_x, base_y + 1, base_z - 1), air, 3);
                world.m_7731_(new BlockPos(base_x, base_y + 1, base_z - 2), air, 3);
                world.m_7731_(new BlockPos(base_x, base_y + 2, base_z - 1), air, 3);
                world.m_7731_(new BlockPos(base_x, base_y + 2, base_z - 2), air, 3);
                world.m_7731_(new BlockPos(base_x, base_y, base_z - 1), stairs, 3);
                world.m_7731_(new BlockPos(base_x, base_y, base_z - 2), stairs, 3);
            }
        }
    }

    public void doorOpenInteraction(Player player, BlockState pState, Level pLevel, BlockPos pos) {
        if (PipBoyUtils.hasPipboy(player)) {
            this.fillFrame(((Block)ModBlocks.FILLER_BARRIER.get()).m_49966_(), pLevel, pState, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            pLevel.m_5594_(player, pos, (SoundEvent)ModSounds.VAULT_DOOR_INTERACT.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
            BlockState newState = ((Block)ModBlocks.GEAR_DOOR.get()).m_49966_();
            for (Map.Entry entry : pState.m_61148_().entrySet()) {
                Property property = newState.m_60734_().m_49965_().m_61081_(((Property)entry.getKey()).m_61708_());
            }
            pLevel.m_7731_(pos, newState, 3);
        }
    }

    public void m_6402_(Level pLevel, BlockPos pos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack stack) {
        this.filledEraser(pLevel, pState, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        super.m_6402_(pLevel, pos, pState, pPlacer, stack);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.fillFrame(Blocks.f_50016_.m_49966_(), level, state, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pos, CollisionContext pContext) {
        if (this.SHAPES.containsKey(pState)) {
            return this.SHAPES.get(pState);
        }
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        switch ((Direction)pState.m_61143_((Property)FACING)) {
            case NORTH: {
                shapes.add(OpenGearBlock.m_49796_((double)-48.0, (double)0.0, (double)0.0, (double)16.0, (double)64.0, (double)16.0));
                break;
            }
            case EAST: {
                shapes.add(OpenGearBlock.m_49796_((double)0.0, (double)0.0, (double)-48.0, (double)16.0, (double)64.0, (double)16.0));
                break;
            }
            case WEST: {
                shapes.add(OpenGearBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)64.0, (double)64.0));
                break;
            }
            default: {
                shapes.add(OpenGearBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)64.0, (double)64.0, (double)16.0));
            }
        }
        VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
        this.SHAPES.put(pState, shape);
        return shape;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pos) {
        return super.m_7952_(pState, pLevel, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }
}

