/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.blocks.blocks;

import com.google.common.annotations.VisibleForTesting;
import com.nukateam.nukacraft.common.registery.blocks.ModBlocks;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PointedUltraciteCrystall
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.f_155997_;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.f_155998_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public PointedUltraciteCrystall(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TIP_DIRECTION, (Comparable)Direction.UP)).m_61124_(THICKNESS, (Comparable)DripstoneThickness.TIP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static void spawnFallingStalactite(BlockState pState, ServerLevel pLevel, BlockPos pPos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        BlockState blockstate = pState;
        while (PointedUltraciteCrystall.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)pLevel, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (PointedUltraciteCrystall.isTip(blockstate, true)) {
                int i = Math.max(1 + pPos.m_123342_() - blockpos$mutableblockpos.m_123342_(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.m_149656_(f, 40);
                break;
            }
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockState blockstate2;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = pLevel.m_8055_(pPos.m_6630_(1));
        if (PointedUltraciteCrystall.canGrow(blockstate, blockstate1 = pLevel.m_8055_(pPos.m_6630_(2))) && (blockpos = PointedUltraciteCrystall.findTip(pState, (LevelAccessor)pLevel, pPos, 7, false)) != null && PointedUltraciteCrystall.canDrip(blockstate2 = pLevel.m_8055_(blockpos)) && PointedUltraciteCrystall.canTipGrow(blockstate2, pLevel, blockpos)) {
            if (pRandom.m_188499_()) {
                PointedUltraciteCrystall.grow(pLevel, blockpos, Direction.DOWN);
            } else {
                PointedUltraciteCrystall.growStalagmiteBelow(pLevel, blockpos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel pLevel, BlockPos pPos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        for (int i = 0; i < 10; ++i) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            BlockState blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (!blockstate.m_60819_().m_76178_()) {
                return;
            }
            if (PointedUltraciteCrystall.isUnmergedTipWithDirection(blockstate, Direction.UP) && PointedUltraciteCrystall.canTipGrow(blockstate, pLevel, (BlockPos)blockpos$mutableblockpos)) {
                PointedUltraciteCrystall.grow(pLevel, (BlockPos)blockpos$mutableblockpos, Direction.UP);
                return;
            }
            if (PointedUltraciteCrystall.isValidPointedDripstonePlacement((LevelReader)pLevel, (BlockPos)blockpos$mutableblockpos, Direction.UP) && !pLevel.m_46801_(blockpos$mutableblockpos.m_7495_())) {
                PointedUltraciteCrystall.grow(pLevel, blockpos$mutableblockpos.m_7495_(), Direction.UP);
                return;
            }
            if (PointedUltraciteCrystall.canDripThrough((BlockGetter)pLevel, (BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return;
        }
    }

    private static void grow(ServerLevel pServer, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.m_121945_(pDirection);
        BlockState blockstate = pServer.m_8055_(blockpos);
        if (PointedUltraciteCrystall.isUnmergedTipWithDirection(blockstate, pDirection.m_122424_())) {
            PointedUltraciteCrystall.createMergedTips(blockstate, (LevelAccessor)pServer, blockpos);
        } else if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49990_)) {
            PointedUltraciteCrystall.createDripstone((LevelAccessor)pServer, blockpos, pDirection, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor pLevel, BlockPos pPos, Direction pDirection, DripstoneThickness pThickness) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((Block)ModBlocks.POINTED_ULTRACITE_CRYSTALL.get()).m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)pDirection)).m_61124_(THICKNESS, (Comparable)pThickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pLevel.m_6425_(pPos).m_76152_() == Fluids.f_76193_));
        pLevel.m_7731_(pPos, blockstate, 3);
    }

    private static void createMergedTips(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        BlockPos abovePos;
        BlockPos belowPos;
        if (pState.m_61143_((Property)TIP_DIRECTION) == Direction.UP) {
            belowPos = pPos;
            abovePos = pPos.m_7494_();
        } else {
            abovePos = pPos;
            belowPos = pPos.m_7495_();
        }
        PointedUltraciteCrystall.createDripstone(pLevel, abovePos, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        PointedUltraciteCrystall.createDripstone(pLevel, belowPos, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    public static void spawnDripParticle(Level pLevel, BlockPos pPos, BlockState pState) {
        PointedUltraciteCrystall.getFluidAboveStalactite(pLevel, pPos, pState).ifPresent(p_154189_ -> PointedUltraciteCrystall.spawnDripParticle(pLevel, pPos, pState, p_154189_));
    }

    private static void spawnDripParticle(Level pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        Vec3 vec3 = pState.m_60824_((BlockGetter)pLevel, pPos);
        double d0 = 0.0625;
        double d1 = (double)pPos.m_123341_() + 0.5 + vec3.f_82479_;
        double d2 = (double)((float)(pPos.m_123342_() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pPos.m_123343_() + 0.5 + vec3.f_82481_;
        Fluid fluid = PointedUltraciteCrystall.getDripFluid(pLevel, pFluid);
        SimpleParticleType particleoptions = fluid.m_205067_(FluidTags.f_13132_) ? ParticleTypes.f_175822_ : ParticleTypes.f_175824_;
        pLevel.m_7106_((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState pState, LevelAccessor pLevel, BlockPos pPos, int pMaxIterations, boolean pIsTipMerge) {
        if (PointedUltraciteCrystall.isTip(pState, pIsTipMerge)) {
            return pPos;
        }
        Direction direction = (Direction)pState.m_61143_((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202023_, p_202024_) -> p_202024_.m_60713_((Block)ModBlocks.POINTED_ULTRACITE_CRYSTALL.get()) && p_202024_.m_61143_((Property)TIP_DIRECTION) == direction;
        return PointedUltraciteCrystall.findBlockVertical(pLevel, pPos, direction.m_122421_(), bipredicate, p_154168_ -> PointedUltraciteCrystall.isTip(p_154168_, pIsTipMerge), pMaxIterations).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader pLevel, BlockPos pPos, Direction pDir) {
        Direction direction;
        if (PointedUltraciteCrystall.isValidPointedDripstonePlacement(pLevel, pPos, pDir)) {
            direction = pDir;
        } else {
            if (!PointedUltraciteCrystall.isValidPointedDripstonePlacement(pLevel, pPos, pDir.m_122424_())) {
                return null;
            }
            direction = pDir.m_122424_();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader pLevel, BlockPos pPos, Direction pDir, boolean pIsTipMerge) {
        Direction direction = pDir.m_122424_();
        BlockState blockstate = pLevel.m_8055_(pPos.m_121945_(pDir));
        if (PointedUltraciteCrystall.isPointedDripstoneWithDirection(blockstate, direction)) {
            return !pIsTipMerge && blockstate.m_61143_(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedUltraciteCrystall.isPointedDripstoneWithDirection(blockstate, pDir)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.m_61143_(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = pLevel.m_8055_(pPos.m_121945_(direction));
            return !PointedUltraciteCrystall.isPointedDripstoneWithDirection(blockstate1, pDir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState p_154239_) {
        return PointedUltraciteCrystall.isStalactite(p_154239_) && p_154239_.m_61143_(THICKNESS) == DripstoneThickness.TIP && (Boolean)p_154239_.m_61143_((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState pState, ServerLevel pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.m_61143_((Property)TIP_DIRECTION);
        BlockPos blockpos = pPos.m_121945_(direction);
        BlockState blockstate = pLevel.m_8055_(blockpos);
        if (!blockstate.m_60819_().m_76178_()) {
            return false;
        }
        return blockstate.m_60795_() ? true : PointedUltraciteCrystall.isUnmergedTipWithDirection(blockstate, direction.m_122424_());
    }

    private static Optional<BlockPos> findRootBlock(Level pLevel, BlockPos pPos, BlockState pState, int pMaxIterations) {
        Direction direction = (Direction)pState.m_61143_((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (pos1, pos2) -> pos2.m_60713_((Block)ModBlocks.POINTED_ULTRACITE_CRYSTALL.get()) && pos2.m_61143_((Property)TIP_DIRECTION) == direction;
        return PointedUltraciteCrystall.findBlockVertical((LevelAccessor)pLevel, pPos, direction.m_122424_().m_122421_(), bipredicate, pos -> !pos.m_60713_((Block)ModBlocks.POINTED_ULTRACITE_CRYSTALL.get()), pMaxIterations);
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader pLevel, BlockPos pPos, Direction pDir) {
        BlockPos blockpos = pPos.m_121945_(pDir.m_122424_());
        BlockState blockstate = pLevel.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)pLevel, blockpos, pDir) || PointedUltraciteCrystall.isPointedDripstoneWithDirection(blockstate, pDir);
    }

    private static boolean isTip(BlockState pState, boolean pIsTipMerge) {
        if (!pState.m_60713_((Block)ModBlocks.POINTED_ULTRACITE_CRYSTALL.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)pState.m_61143_(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || pIsTipMerge && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState pState, Direction pDir) {
        return PointedUltraciteCrystall.isTip(pState, false) && pState.m_61143_((Property)TIP_DIRECTION) == pDir;
    }

    private static boolean isStalactite(BlockState pState) {
        return PointedUltraciteCrystall.isPointedDripstoneWithDirection(pState, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState pState) {
        return PointedUltraciteCrystall.isPointedDripstoneWithDirection(pState, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return PointedUltraciteCrystall.isStalactite(pState) && !pLevel.m_8055_(pPos.m_7494_()).m_60713_((Block)ModBlocks.POINTED_ULTRACITE_CRYSTALL.get());
    }

    private static boolean isPointedDripstoneWithDirection(BlockState pState, Direction pDir) {
        return pState.m_60713_((Block)ModBlocks.POINTED_ULTRACITE_CRYSTALL.get()) && pState.m_61143_((Property)TIP_DIRECTION) == pDir;
    }

    private static Optional<Fluid> getFluidAboveStalactite(Level pLevel, BlockPos pPos, BlockState pState) {
        return !PointedUltraciteCrystall.isStalactite(pState) ? Optional.empty() : PointedUltraciteCrystall.findRootBlock(pLevel, pPos, pState, 11).map(p_202027_ -> pLevel.m_6425_(p_202027_.m_7494_()).m_76152_());
    }

    private static boolean canFillCauldron(Fluid p_154159_) {
        return p_154159_ == Fluids.f_76195_ || p_154159_ == Fluids.f_76193_;
    }

    private static boolean canGrow(BlockState pDripstoneState, BlockState pState) {
        return pDripstoneState.m_60713_((Block)ModBlocks.ULTRACITE_TUFF.get()) && pState.m_60713_(Blocks.f_49990_) && pState.m_60819_().m_76170_();
    }

    private static Fluid getDripFluid(Level pLevel, Fluid pFluid) {
        if (!pFluid.m_6212_(Fluids.f_76191_)) {
            return pFluid;
        }
        return pLevel.m_6042_().f_63857_() ? Fluids.f_76195_ : Fluids.f_76193_;
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor pLevel, BlockPos pPos, Direction.AxisDirection pAxis, BiPredicate<BlockPos, BlockState> pPositionalStatePredicate, Predicate<BlockState> pStatePredicate, int pMaxIterations) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)pAxis, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        for (int i = 1; i < pMaxIterations; ++i) {
            blockpos$mutableblockpos.m_122173_(direction);
            BlockState blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (pStatePredicate.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.m_7949_());
            }
            if (!pLevel.m_151562_(blockpos$mutableblockpos.m_123342_()) && pPositionalStatePredicate.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        if (pState.m_60795_()) {
            return true;
        }
        if (pState.m_60804_(pLevel, pPos)) {
            return false;
        }
        if (!pState.m_60819_().m_76178_()) {
            return false;
        }
        VoxelShape voxelshape = pState.m_60812_(pLevel, pPos);
        return !Shapes.m_83157_((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return PointedUltraciteCrystall.isValidPointedDripstonePlacement(pLevel, pPos, (Direction)pState.m_61143_((Property)TIP_DIRECTION));
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (pDirection != Direction.UP && pDirection != Direction.DOWN) {
            return pState;
        }
        Direction direction = (Direction)pState.m_61143_((Property)TIP_DIRECTION);
        if (direction == Direction.DOWN && pLevel.m_183326_().m_183582_(pCurrentPos, (Object)this)) {
            return pState;
        }
        if (pDirection == direction.m_122424_() && !this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos)) {
            if (direction == Direction.DOWN) {
                pLevel.m_186460_(pCurrentPos, (Block)this, 2);
            } else {
                pLevel.m_186460_(pCurrentPos, (Block)this, 1);
            }
            return pState;
        }
        boolean flag = pState.m_61143_(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = PointedUltraciteCrystall.calculateDripstoneThickness((LevelReader)pLevel, pCurrentPos, direction, flag);
        return (BlockState)pState.m_61124_(THICKNESS, (Comparable)dripstonethickness);
    }

    public void m_5581_(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        BlockPos blockpos = pHit.m_82425_();
        if (!pLevel.f_46443_ && pProjectile.m_142265_(pLevel, blockpos) && pProjectile instanceof ThrownTrident && pProjectile.m_20184_().m_82553_() > 0.6) {
            pLevel.m_46961_(blockpos, true);
        }
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if (pState.m_61143_((Property)TIP_DIRECTION) == Direction.UP && pState.m_61143_(THICKNESS) == DripstoneThickness.TIP) {
            pEntity.m_142535_(pFallDistance + 2.0f, 2.0f, pLevel.m_269111_().m_269571_());
        } else {
            super.m_142072_(pLevel, pState, pPos, pEntity, pFallDistance);
        }
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        float f;
        if (PointedUltraciteCrystall.canDrip(pState) && !((f = pRandom.m_188501_()) > 0.12f)) {
            PointedUltraciteCrystall.getFluidAboveStalactite(pLevel, pPos, pState).filter(p_154031_ -> f < 0.02f || PointedUltraciteCrystall.canFillCauldron(p_154031_)).ifPresent(p_154220_ -> PointedUltraciteCrystall.spawnDripParticle(pLevel, pPos, pState, p_154220_));
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (PointedUltraciteCrystall.isStalagmite(pState) && !this.m_7898_(pState, (LevelReader)pLevel, pPos)) {
            pLevel.m_46961_(pPos, true);
        } else {
            PointedUltraciteCrystall.spawnFallingStalactite(pState, pLevel, pPos);
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.m_188501_() < 0.011377778f && PointedUltraciteCrystall.isStalactiteStartPos(pState, (LevelReader)pLevel, pPos)) {
            PointedUltraciteCrystall.growStalactiteOrStalagmiteIfPossible(pState, pLevel, pPos, pRandom);
        }
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = pContext.m_43725_();
        Direction direction1 = PointedUltraciteCrystall.calculateTipDirection((LevelReader)levelaccessor, blockpos = pContext.m_8083_(), direction = pContext.m_151260_().m_122424_());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !pContext.m_7078_();
        DripstoneThickness dripstonethickness = PointedUltraciteCrystall.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction1)).m_61124_(THICKNESS, (Comparable)dripstonethickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)pState.m_61143_(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (pState.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = pState.m_60824_(pLevel, pPos);
        return voxelshape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    public boolean m_180643_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return false;
    }

    public BlockBehaviour.OffsetType getOffsetType() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public float m_142740_() {
        return 0.125f;
    }

    public void m_142525_(Level pLevel, BlockPos pPos, FallingBlockEntity pFallingBlock) {
        if (!pFallingBlock.m_20067_()) {
            pLevel.m_46796_(1045, pPos, 0);
        }
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

