/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.blocks.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.nukateam.nukacraft.common.registery.blocks.ModBlocks;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class PowerBlock
extends RotatedPillarBlock {
    public static final EnumProperty<RedstoneSide> UP = EnumProperty.m_61587_((String)"up", RedstoneSide.class);
    public static final EnumProperty<RedstoneSide> DOWN = EnumProperty.m_61587_((String)"down", RedstoneSide.class);
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.f_61383_;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.f_61382_;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.f_61384_;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.f_61385_;
    public static final IntegerProperty POWER = RedStoneWireBlock.f_55500_;
    public static final Vector3f[] COLORS = new Vector3f[16];
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.builder().put((Object)Direction.NORTH, NORTH).put((Object)Direction.EAST, EAST).put((Object)Direction.SOUTH, SOUTH).put((Object)Direction.WEST, WEST).put((Object)Direction.UP, UP).put((Object)Direction.DOWN, DOWN).build());
    private boolean shouldSignal = true;

    public PowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_(NORTH, (Comparable)RedstoneSide.NONE)).m_61124_(EAST, (Comparable)RedstoneSide.NONE)).m_61124_(SOUTH, (Comparable)RedstoneSide.NONE)).m_61124_(WEST, (Comparable)RedstoneSide.NONE)).m_61124_(UP, (Comparable)RedstoneSide.NONE)).m_61124_(DOWN, (Comparable)RedstoneSide.NONE)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(WEST, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.WEST))).m_61124_(EAST, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.EAST))).m_61124_(NORTH, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.NORTH))).m_61124_(SOUTH, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.SOUTH))).m_61124_(UP, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.UP))).m_61124_(DOWN, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.DOWN))).m_61124_((Property)f_55923_, (Comparable)context.m_43719_().m_122434_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.m_61124_((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)this.getSide((BlockGetter)level, currentPos, facing));
    }

    private RedstoneSide getSide(BlockGetter level, BlockPos pos, Direction face) {
        BlockPos blockpos = pos.m_121945_(face);
        BlockState blockstate = level.m_8055_(blockpos);
        return PowerBlock.shouldConnectTo(blockstate, level, blockpos, face) ? RedstoneSide.SIDE : RedstoneSide.NONE;
    }

    protected static boolean shouldConnectTo(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        if (blockState.m_60713_((Block)ModBlocks.POWERBLOCK.get())) {
            return true;
        }
        return blockState.canRedstoneConnectTo(world, pos, side);
    }

    private void updatePowerStrength(Level level, BlockPos pos, BlockState state) {
        int i = this.calculateTargetStrength(level, pos);
        if ((Integer)state.m_61143_((Property)POWER) != i) {
            if (level.m_8055_(pos) == state) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(i)), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (Direction direction : Direction.values()) {
                set.add(pos.m_121945_(direction));
            }
            for (BlockPos blockpos : set) {
                level.m_46672_(blockpos, (Block)this);
            }
        }
    }

    private int calculateTargetStrength(Level world, BlockPos pos) {
        this.shouldSignal = false;
        int i = world.m_277086_(pos);
        this.shouldSignal = true;
        int j = 0;
        if (i < 15) {
            for (Direction direction : Direction.values()) {
                BlockState blockstate = world.m_8055_(pos.m_121945_(direction));
                j = Math.max(j, this.getWireSignal(blockstate));
            }
        }
        return Math.max(i, j - 1);
    }

    private void updateNeighborsOfNeighboringWires(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_((Block)this) || state.m_60713_(Blocks.f_50088_)) {
            level.m_46672_(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                level.m_46672_(pos.m_121945_(direction), (Block)this);
            }
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_()) && !level.f_46443_) {
            this.updatePowerStrength(level, pos, state);
            for (Direction direction : Direction.values()) {
                this.updateNeighborsOfNeighboringWires(level, pos.m_121945_(direction));
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, level, pos, newState, isMoving);
            if (!level.f_46443_) {
                for (Direction direction : Direction.values()) {
                    level.m_46672_(pos.m_121945_(direction), (Block)this);
                }
                this.updatePowerStrength(level, pos, state);
                for (Direction direction : Direction.values()) {
                    this.updateNeighborsOfNeighboringWires(level, pos.m_121945_(direction));
                }
            }
        }
    }

    private int getWireSignal(BlockState neighbor) {
        return neighbor.m_60713_((Block)this) || neighbor.m_60713_(Blocks.f_50088_) ? (Integer)neighbor.m_61143_((Property)POWER) : 0;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            this.updatePowerStrength(level, pos, state);
        }
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.shouldSignal ? blockState.m_60746_(blockAccess, pos, side) : 0;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.shouldSignal ? (Integer)blockState.m_61143_((Property)POWER) : 0;
    }

    public boolean m_7899_(BlockState state) {
        return this.shouldSignal;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        int i = (Integer)stateIn.m_61143_((Property)POWER);
        if (i != 0) {
            double d0 = (double)pos.m_123341_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.8;
            double d1 = (double)pos.m_123342_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.8;
            double d2 = (double)pos.m_123343_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.8;
            Vector3f vec = COLORS[i];
            level.m_7106_((ParticleOptions)new DustParticleOptions(vec, 1.0f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(NORTH)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(EAST)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(NORTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(EAST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)));
            }
        }
        return state;
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return switch (mirrorIn) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(EAST)));
            default -> super.m_6943_(state, mirrorIn);
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, POWER, f_55923_});
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f1 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = Mth.m_14036_((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float f3 = Mth.m_14036_((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            PowerBlock.COLORS[i] = new Vector3f(f1, f2, f3);
        }
    }
}

