/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.blocks.blocks;

import com.nukateam.ntgl.common.foundation.block.RotatedObjectBlock;
import com.nukateam.nukacraft.common.data.utils.VoxelShapeHelper;
import com.nukateam.nukacraft.common.foundation.blocks.blocks.WastelandTeleporter;
import com.nukateam.nukacraft.common.foundation.world.WastelandDimensionsSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ITeleporter;

public class TerminalBlock
extends RotatedObjectBlock {
    private final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public TerminalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private VoxelShape getShape(BlockState state) {
        if (this.SHAPES.containsKey(state)) {
            return this.SHAPES.get(state);
        }
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(TerminalBlock.m_49796_((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)15.9, (double)15.9));
        VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
        this.SHAPES.put(state, shape);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getShape(state);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.m_20159_() || entity.m_20160_() || entity.m_6072_()) {
            // empty if block
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        MinecraftServer server;
        if (!pLevel.m_5776_() && !pPlayer.m_6047_() && (server = pLevel.m_7654_()) != null) {
            if (pLevel.m_46472_() == WastelandDimensionsSettings.WASTELAND_DIMENSION) {
                ServerLevel overWorld = server.m_129880_(Level.f_46428_);
                if (overWorld != null) {
                    pPlayer.changeDimension(overWorld, (ITeleporter)new WastelandTeleporter(pPos, false));
                }
            } else {
                ServerLevel kjDim = server.m_129880_(WastelandDimensionsSettings.WASTELAND_DIMENSION);
                if (kjDim != null) {
                    pPlayer.changeDimension(kjDim, (ITeleporter)new WastelandTeleporter(pPos, true));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }
}

