/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.blocks.blocks;

import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.nukacraft.common.data.utils.VoxelShapeHelper;
import com.nukateam.nukacraft.common.foundation.entities.blocks.WeaponDisplayEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WeaponDisplayBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public WeaponDisplayBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    private VoxelShape getShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (this.SHAPES.containsKey(state)) {
            return this.SHAPES.get(state);
        }
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        switch (direction) {
            case EAST: {
                shapes.add(WeaponDisplayBlock.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                break;
            }
            case WEST: {
                shapes.add(WeaponDisplayBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0));
                break;
            }
            case SOUTH: {
                shapes.add(WeaponDisplayBlock.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0));
                break;
            }
            case NORTH: {
                shapes.add(WeaponDisplayBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0));
            }
        }
        VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
        this.SHAPES.put(state, shape);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new WeaponDisplayEntity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    public void m_6786_(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof WeaponDisplayEntity) {
            WeaponDisplayEntity statueBlockEntity = (WeaponDisplayEntity)blockEntity;
            statueBlockEntity.dropItem();
        }
        super.m_6786_(pLevel, pPos, pState);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WeaponDisplayEntity) {
            WeaponDisplayEntity statueBlockEntity = (WeaponDisplayEntity)blockEntity;
            statueBlockEntity.dropItem();
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public InteractionResult m_6227_(BlockState pState, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WeaponDisplayEntity) {
            WeaponItem gun;
            WeaponDisplayEntity displayBlockEntity = (WeaponDisplayEntity)blockEntity;
            ItemStack stack = player.m_21120_(pHand);
            Item item = stack.m_41720_();
            if (item instanceof WeaponItem && !(gun = (WeaponItem)item).getConfig().getGeneral().getCategory().equals("heavy")) {
                displayBlockEntity.setGun(stack);
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41619_()) {
                displayBlockEntity.dropItem();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }
}

