/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.entities.misc;

import com.nukateam.chassis_core.client.animators.HandAnimator;
import com.nukateam.chassis_core.client.render.renderers.CustomHandRenderer;
import com.nukateam.chassis_core.common.foundation.entity.Chassis;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import com.nukateam.chassis_core.common.foundation.item.ItemStackUtils;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.nukacraft.client.cc.PowerArmorSettings;
import com.nukateam.nukacraft.client.helpers.AnimationHelper;
import com.nukateam.nukacraft.client.helpers.PowerArmorHelper;
import com.nukateam.nukacraft.client.models.PowerArmorModel;
import com.nukateam.nukacraft.client.render.animators.hand.PowerArmorHand;
import com.nukateam.nukacraft.common.data.constants.PowerArmorPrats;
import com.nukateam.nukacraft.common.foundation.container.PowerArmorMenu;
import com.nukateam.nukacraft.common.foundation.container.PowerArmorStationMenu;
import com.nukateam.nukacraft.common.registery.ModSounds;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.model.GeoModel;

public class PowerArmorFrame
extends WearableChassis {
    public static final String TRIGGER_NAME = "baseAnim";
    public static final ResourceLocation ICON = new ResourceLocation("nukacraft", "textures/item/power_armor_frame.png");
    public static final PowerArmorHand HAND = new PowerArmorHand();
    public static final EntityDataAccessor<Boolean> IS_OPEN = SynchedEntityData.m_135353_(PowerArmorFrame.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDimensions STANDING_DIMENSIONS = EntityDimensions.m_20395_((float)1.0f, (float)2.3f);
    public static final EntityDimensions CROUCHING_DIMENSIONS = EntityDimensions.m_20395_((float)1.0f, (float)2.0f);
    public static final String RUN_LEGS = "run_legs";
    public static final String RUN_ARMS = "run_arms";
    public static final int WALK_DURATION = 20;
    public static HashMap<String, Integer> POWER_ARMOR_PART_IDS;
    public final AnimationController<PowerArmorFrame> TRIGGER_CONTROLLER;
    public final AnimationController<PowerArmorFrame> ARM_CONTROLLER;
    public final AnimationController<PowerArmorFrame> LEG_CONTROLLER;
    public RawAnimation armsAnimation = null;
    public RawAnimation legsAnimation = null;
    private int tickCounter = 0;
    private AnimationHelper animationHelper = new AnimationHelper<PowerArmorFrame>(this, (GeoModel)new PowerArmorModel());
    private boolean isSprinting = false;
    private Vec3 currentPos;
    private Vec3 prevPos = this.currentPos = this.m_20182_();
    private int jumpTimer = 0;

    public PowerArmorFrame(EntityType<? extends WearableChassis> type, Level level) {
        super(type, level);
        this.ARM_CONTROLLER = new AnimationController((GeoAnimatable)this, "arm_controller", 0, this.animateArms());
        this.LEG_CONTROLLER = new AnimationController((GeoAnimatable)this, "leg_controller", 0, this.animateLegs()).setSoundKeyframeHandler(this::handleSoundEvent);
        this.TRIGGER_CONTROLLER = new AnimationController((GeoAnimatable)this, TRIGGER_NAME, event -> PlayState.CONTINUE).triggerableAnim("open", RawAnimation.begin().thenPlayAndHold("open")).triggerableAnim("close", RawAnimation.begin().thenPlay("close"));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Chassis.m_21183_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22288_, 0.5).m_22268_(Attributes.f_22278_, 0.8);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.TRIGGER_CONTROLLER});
        controllers.add(new AnimationController[]{this.ARM_CONTROLLER});
        controllers.add(new AnimationController[]{this.LEG_CONTROLLER});
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_OPEN, (Object)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public CustomHandRenderer getHandRenderer() {
        return (CustomHandRenderer)PowerArmorSettings.HAND_RENDERER.get();
    }

    public boolean renderHand() {
        return true;
    }

    public void m_8119_() {
        PowerArmorFrame.doSafe(() -> super.m_8119_());
        if (this.tickCounter >= 20) {
            this.rareTick();
            this.tickCounter = 0;
        } else {
            ++this.tickCounter;
        }
        this.jumpTimer = Math.max(this.jumpTimer - 1, 0);
        if (this.hasPlayerPassenger()) {
            this.isSprinting = this.getPlayerPassenger().m_20142_();
        }
        this.prevPos = this.currentPos;
        this.currentPos = this.m_20182_();
        this.updatePose();
    }

    public EntityDimensions getStandingDimensions() {
        return STANDING_DIMENSIONS;
    }

    public EntityDimensions getCrouchingDimensions() {
        return CROUCHING_DIMENSIONS;
    }

    protected float getCrouchingSpeed() {
        return this.getSpeedAttribute() * 0.7f;
    }

    protected float getSprintingSpeed() {
        return this.getSpeedAttribute() * 1.5f;
    }

    protected void updatePose() {
        super.updatePose();
        if (!this.hasEnergy()) {
            this.m_7910_(this.getMinSpeed());
        }
    }

    public boolean isOpened() {
        return (Boolean)this.f_19804_.m_135370_(IS_OPEN);
    }

    public InteractionResult m_7111_(Player player, Vec3 vector, InteractionHand hand) {
        if (this.isServerSide && !player.m_20159_() && hand == InteractionHand.MAIN_HAND && !this.m_20160_()) {
            if (player.m_6144_()) {
                if (((Boolean)this.f_19804_.m_135370_(IS_OPEN)).booleanValue()) {
                    this.close();
                } else {
                    this.openGUI(player);
                }
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)this.f_19804_.m_135370_(IS_OPEN)).booleanValue()) {
                this.ride((LivingEntity)player);
                this.close();
            } else {
                this.open();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void exitArmor() {
        super.exitArmor();
        this.open();
    }

    public Vec3 m_7688_(LivingEntity p_20123_) {
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        if (damageSource.m_276093_(DamageTypes.f_268671_)) {
            this.damageArmor(damageSource, damage);
            return false;
        }
        return super.m_6469_(damageSource, damage);
    }

    private SoundEvent getFallDamageSound(float pHeight) {
        return pHeight > 4.0f ? this.m_196493_().f_196627_() : this.m_196493_().f_196626_();
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        this.m_5496_(this.getFallDamageSound(pFallDistance), 1.0f, 1.0f);
        int damage = this.m_5639_(pFallDistance, pMultiplier);
        this.damageArmor(pSource, damage);
        return false;
    }

    public ResourceLocation getIcon() {
        return ICON;
    }

    public HandAnimator getHandEntity() {
        return HAND;
    }

    public void jump() {
        if (this.hasEnergy()) {
            if (!this.m_9236_().f_46443_ && this.m_20096_() && this.jumpTimer == 0) {
                this.jumpTimer = 2;
                this.m_5496_((SoundEvent)ModSounds.POWER_ARMOR_JUMP.get(), 0.5f, 1.0f);
            }
            super.jump();
        }
    }

    public MenuProvider getMenuProvider() {
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int id, Inventory menu, Player player) {
                return new PowerArmorMenu(id, (Container)PowerArmorFrame.this.inventory, menu, PowerArmorFrame.this);
            }

            public Component m_5446_() {
                return PowerArmorFrame.this.m_5446_();
            }
        };
    }

    protected MenuProvider getStantionMenuProvider() {
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int id, Inventory menu, Player player) {
                return new PowerArmorStationMenu(id, (Container)PowerArmorFrame.this.inventory, menu, PowerArmorFrame.this);
            }

            public Component m_5446_() {
                return PowerArmorFrame.this.m_5446_();
            }
        };
    }

    @Nullable
    public WeaponItem getPassengerGun() {
        if (this.passengerHaveGun()) {
            return (WeaponItem)this.m_6688_().m_21205_().m_41720_();
        }
        return null;
    }

    public boolean m_6060_() {
        return false;
    }

    public Boolean isWalking() {
        return this.speedometer.getSpeed() > 0.0;
    }

    public boolean passengerHaveGun() {
        return this.hasPassenger() && this.m_6688_().m_21205_().m_41720_() instanceof WeaponItem;
    }

    public ItemStack getFusionCore() {
        return this.getEquipment(PowerArmorPrats.FUSION_CORE);
    }

    public boolean hasFusionCore() {
        return this.hasEquipment(PowerArmorPrats.FUSION_CORE);
    }

    public boolean hasEnergy() {
        return this.hasFusionCore();
    }

    public void open() {
        this.f_19804_.m_135381_(IS_OPEN, (Object)true);
        this.m_216990_((SoundEvent)ModSounds.POWER_ARMOR_OPEN.get());
        this.triggerAnim(TRIGGER_NAME, "open");
    }

    public void close() {
        this.f_19804_.m_135381_(IS_OPEN, (Object)false);
        this.m_216990_((SoundEvent)ModSounds.POWER_ARMOR_CLOSE.get());
        this.triggerAnim(TRIGGER_NAME, "close");
    }

    public static int getId(String chassisPart) {
        return POWER_ARMOR_PART_IDS.get(chassisPart);
    }

    private void rareTick() {
        if (this.isClientSide || !this.hasFusionCore()) {
            return;
        }
        ItemStack core = this.getFusionCore();
        int dmg = core.m_41776_() - core.m_41773_();
        if (dmg <= 0) {
            this.setEquipment(PowerArmorPrats.FUSION_CORE, ItemStack.f_41583_);
        }
        if (this.isWalking().booleanValue()) {
            ItemStackUtils.damageItem((ItemStack)core, (int)1);
        }
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds((SoundEvent)ModSounds.POWER_ARMOR_JUMPDOWN.get(), (SoundEvent)ModSounds.POWER_ARMOR_LAND.get());
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
        if (!this.m_9236_().f_46443_ || PowerArmorHelper.shouldRender(this)) {
            if (this.isSprinting) {
                this.m_5496_((SoundEvent)ModSounds.POWER_ARMOR_RUN.get(), 0.5f, 1.0f);
            } else {
                this.m_5496_((SoundEvent)ModSounds.POWER_ARMOR_WALK.get(), 0.5f, 1.0f);
            }
        }
    }

    protected void handleSoundEvent(SoundKeyframeEvent<PowerArmorFrame> event) {
        String name = event.getKeyframeData().getSound();
        if (name.equals("walk")) {
            PowerArmorHelper.playNukaSound(this.m_20182_(), ModSounds.POWER_ARMOR_WALK, 0.8f, 1, 40);
        } else if (name.equals("run")) {
            PowerArmorHelper.playNukaSound(this.m_20182_(), ModSounds.POWER_ARMOR_RUN, 0.8f, 1, 40);
        }
    }

    private AnimationController.AnimationStateHandler<PowerArmorFrame> animateArms() {
        return event -> {
            AnimationController controller = event.getController();
            controller.setAnimationSpeed(1.0);
            RawAnimation animation = null;
            LivingEntity passenger = this.m_6688_();
            if (passenger == null) {
                animation = RawAnimation.begin().then("idle_empty", Animation.LoopType.LOOP);
            } else if (passenger.f_20921_ > 0.0f) {
                controller.setAnimationSpeed(2.0);
                animation = RawAnimation.begin().then("hit", Animation.LoopType.PLAY_ONCE);
            } else if (this.f_20916_ > 0) {
                animation = RawAnimation.begin().then("hurt", Animation.LoopType.PLAY_ONCE);
            } else if (this.isWalking().booleanValue()) {
                if (this.isSprinting) {
                    animation = RawAnimation.begin().then(RUN_ARMS, Animation.LoopType.LOOP);
                    this.animationHelper.syncAnimation(event, RUN_ARMS, 20);
                } else {
                    animation = RawAnimation.begin().then("walk_arms", Animation.LoopType.LOOP);
                    this.animationHelper.syncAnimation(event, "walk_arms", 20);
                }
            } else {
                animation = RawAnimation.begin().then("walk_arms", Animation.LoopType.LOOP).equals((Object)this.armsAnimation) ? RawAnimation.begin().then("walk_arms", Animation.LoopType.PLAY_ONCE).then("idle", Animation.LoopType.LOOP) : RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
            }
            this.armsAnimation = animation;
            return animation != null ? event.setAndContinue(animation) : PlayState.STOP;
        };
    }

    private AnimationController.AnimationStateHandler<PowerArmorFrame> animateLegs() {
        return event -> {
            AnimationController controller = event.getController();
            controller.setAnimationSpeed(1.0);
            RawAnimation animation = null;
            if (!this.hasPassenger()) {
                return PlayState.STOP;
            }
            LivingEntity passenger = this.m_6688_();
            if (this.isWalking().booleanValue()) {
                if (this.m_6047_()) {
                    animation = RawAnimation.begin().then("sneak_walk", Animation.LoopType.LOOP);
                    controller.setAnimationSpeed(0.5);
                } else if (this.isSprinting) {
                    animation = RawAnimation.begin().then("run_start", Animation.LoopType.PLAY_ONCE).then(RUN_LEGS, Animation.LoopType.LOOP);
                    this.animationHelper.syncAnimation(event, RUN_LEGS, 20);
                } else {
                    animation = RawAnimation.begin().then("walk_legs", Animation.LoopType.LOOP);
                    this.animationHelper.syncAnimation(event, "walk_legs", 20);
                }
            } else if (this.m_6047_()) {
                animation = RawAnimation.begin().then("sneak_start", Animation.LoopType.HOLD_ON_LAST_FRAME);
            } else if (RawAnimation.begin().then("walk_legs", Animation.LoopType.LOOP).equals((Object)this.legsAnimation)) {
                animation = RawAnimation.begin().then("walk_legs", Animation.LoopType.PLAY_ONCE);
            }
            this.legsAnimation = animation;
            return animation != null ? event.setAndContinue(animation) : PlayState.STOP;
        };
    }

    private static void doSafe(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
    }
}

