/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.entities.misc;

import com.nukateam.nukacraft.common.registery.entities.ModEntities;
import com.nukateam.nukacraft.common.registery.items.ModWeapons;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class SpearEntity
extends AbstractArrow
implements GeoAnimatable {
    public static final float DAMAGE = 8.0f;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private ItemStack handmadeSpearItem;
    private boolean dealtDamage;

    public SpearEntity(EntityType<SpearEntity> type, Level level) {
        super(type, level);
        this.handmadeSpearItem = new ItemStack((ItemLike)ModWeapons.HANDMADE_SPEAR.get());
    }

    public SpearEntity(Level pLevel, LivingEntity pShooter, ItemStack stack) {
        super((EntityType)ModEntities.HANDMADE_SPEAR_ENTITY.get(), pShooter, pLevel);
        this.handmadeSpearItem = stack.m_41777_();
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_6123_(Player pEntity) {
        if (this.m_150171_((Entity)pEntity) || this.m_19749_() == null) {
            super.m_6123_(pEntity);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("Handmade Spear", 10)) {
            this.handmadeSpearItem = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Handmade Spear"));
        }
        this.dealtDamage = pCompound.m_128471_("DealtDamage");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("Handmade Spear", (Tag)this.handmadeSpearItem.m_41739_(new CompoundTag()));
        pCompound.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        super.m_8119_();
    }

    protected void m_5790_(EntityHitResult pResult) {
        this.dealtDamage = true;
        Entity target = pResult.m_82443_();
        Entity owner = this.m_19749_();
        DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
        SoundEvent soundEvent = SoundEvents.f_12514_;
        if (target.m_6469_(damageSource, 8.0f)) {
            if (target.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                if (owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingEntity);
                }
                this.m_7761_(livingEntity);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(soundEvent, 1.0f, 1.0f);
    }

    protected ItemStack m_7941_() {
        return this.handmadeSpearItem.m_41777_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.dealtDamage ? null : super.m_6351_(pStartVec, pEndVec);
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return RenderUtils.getCurrentTick();
    }
}

