/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.entities.mobs;

import com.nukateam.nukacraft.client.helpers.AnimationHelper;
import com.nukateam.nukacraft.client.models.entity.DeathclawModel;
import com.nukateam.nukacraft.common.foundation.entities.mobs.Raider;
import com.nukateam.nukacraft.common.foundation.variants.DeathclawVariant;
import com.nukateam.nukacraft.common.registery.ModSounds;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Deathclaw
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> IS_RUNNING = SynchedEntityData.m_135353_(Deathclaw.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Deathclaw.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String SWIM = "swim";
    public static final String SWIM_START = "swim_start";
    public static final String SWIM_END = "swim_end";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final boolean isServerSide;
    private final Lazy<AnimationHelper<Deathclaw>> animationHelper;
    private boolean startAttacking;
    private String[] attackAnims;
    private String attackAnimName;

    public Deathclaw(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.isServerSide = !this.m_9236_().f_46443_;
        this.animationHelper = Lazy.of(() -> new AnimationHelper<Deathclaw>(this, new DeathclawModel()));
        this.startAttacking = false;
        this.attackAnims = new String[]{"attack_right", "attack_left", "attack_both"};
        this.m_20088_().m_135381_(IS_RUNNING, (Object)true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22281_, 30.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{((Object)((Object)this)).getClass()}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, false));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setVariant((DeathclawVariant)((Object)Util.m_214670_((Object[])DeathclawVariant.values(), (RandomSource)this.f_19796_)));
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_RUNNING, (Object)true);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTypeVariant(pCompound.m_128451_("Variant"));
    }

    public void m_6710_(@Nullable LivingEntity pTarget) {
        super.m_6710_(pTarget);
        if (this.isServerSide) {
            this.setIsRunning(pTarget != null);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.DEATHCLAW_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.DEATHCLAW_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.DEATHCLAW_DEATH.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_216990_((SoundEvent)ModSounds.DEATHCLAW_WALK.get());
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerName", 0, this.animateArms())});
    }

    public void setIsRunning(boolean isRunning) {
        this.m_20088_().m_135381_(IS_RUNNING, (Object)isRunning);
        if (isRunning) {
            this.m_7910_(2.0f);
        } else {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
        }
    }

    @NotNull
    private AnimationController.AnimationStateHandler<Deathclaw> animateArms() {
        return event -> {
            AnimationController controller = event.getController();
            RawAnimation animation = RawAnimation.begin();
            controller.setAnimationSpeed(1.0);
            if (this.m_20069_()) {
                animation.then(SWIM_START, Animation.LoopType.PLAY_ONCE).thenLoop(SWIM);
            } else {
                AnimationProcessor.QueuedAnimation currentAnimation = controller.getCurrentAnimation();
                if (currentAnimation != null && currentAnimation.animation().name().equals(SWIM)) {
                    animation.thenPlay(SWIM_END);
                }
                if (this.f_20921_ > 0.0f) {
                    if (!this.startAttacking) {
                        this.startAttacking = true;
                        this.attackAnimName = this.attackAnims[this.f_19796_.m_216339_(0, this.attackAnims.length)];
                    }
                    ((AnimationHelper)this.animationHelper.get()).syncAnimation(event, this.attackAnimName, 20);
                    animation.thenLoop(this.attackAnimName);
                } else if (event.isMoving()) {
                    Boolean isRunning = (Boolean)this.m_20088_().m_135370_(IS_RUNNING);
                    animation = isRunning != false ? animation.thenLoop("run") : animation.thenLoop("walk");
                } else {
                    animation.thenLoop("idle");
                }
            }
            return event.setAndContinue(animation);
        };
    }

    public DeathclawVariant getVariant() {
        return DeathclawVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(DeathclawVariant variant) {
        this.setTypeVariant(variant.getId() & 0xFF);
    }

    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    private void setTypeVariant(int pTypeVariant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)pTypeVariant);
    }
}

