/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.entities.mobs;

import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.nukacraft.NukaCraft;
import com.nukateam.nukacraft.client.helpers.AnimationHelper;
import com.nukateam.nukacraft.client.models.entity.EntityModel;
import com.nukateam.nukacraft.common.data.interfaces.IGunUser;
import com.nukateam.nukacraft.common.foundation.entities.mobs.Raider;
import com.nukateam.nukacraft.common.foundation.goals.GunAttackGoal;
import com.nukateam.nukacraft.common.foundation.goals.SecuritronRangedAttackGoal;
import com.nukateam.nukacraft.common.foundation.variants.SecuritronVariant;
import com.nukateam.nukacraft.common.registery.ModSounds;
import com.nukateam.nukacraft.common.registery.items.MobGuns;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Securitron
extends PathfinderMob
implements GeoEntity,
IGunUser {
    private static final EntityDataAccessor<Boolean> HAS_TARGET = SynchedEntityData.m_135353_(Securitron.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Securitron.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int SHOOTING_START_TIME = 15;
    private final boolean isServerSide;
    private final AnimatableInstanceCache cache;
    private final Lazy<AnimationHelper<Securitron>> animationHelper;

    public Securitron(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.isServerSide = !this.m_9236_().f_46443_;
        this.cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        this.animationHelper = Lazy.of(() -> new AnimationHelper<Securitron>(this, new EntityModel()));
        this.m_20088_().m_135381_(HAS_TARGET, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, new SecuritronRangedAttackGoal<Securitron>(this, 1.0, 20.0f));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{this.getClass()}));
        if (this.getVariant() == SecuritronVariant.BERSERK || this.getVariant() == SecuritronVariant.DAMAGED) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        }
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setVariant((SecuritronVariant)((Object)Util.m_214670_((Object[])SecuritronVariant.values(), (RandomSource)this.f_19796_)));
        this.setupGuns();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTypeVariant(pCompound.m_128451_("Variant"));
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    public float m_6134_() {
        SecuritronVariant variant = this.getVariant();
        return variant.getScale().floatValue();
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        ItemStack item = this.getGun();
        if (!item.m_41619_()) {
            try {
                GunAttackGoal.shoot((LivingEntity)this, InteractionHand.MAIN_HAND);
            }
            catch (Exception e) {
                NukaCraft.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else {
            this.setupGuns();
        }
    }

    @Override
    public ItemStack getGun() {
        return this.m_21205_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_TARGET, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (this.getVariant() == SecuritronVariant.MUGGY) {
            target = null;
        }
        super.m_6710_(target);
        if (this.isServerSide) {
            this.hasTarget(target != null);
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (VARIANT.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isServerSide) {
            this.m_20088_().m_135381_(HAS_TARGET, (Object)(this.m_5448_() != null ? 1 : 0));
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this.animate())});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "armController", 0, this.animateArms())});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "antenaController", 0, this.animateAntena())});
    }

    private void setupGuns() {
        RegistryObject<WeaponItem> gun = this.isUpgraded() ? MobGuns.SECURITRON_LASER : MobGuns.SECURITRON_GUN;
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)gun.get()));
    }

    private AnimationController.AnimationStateHandler<Securitron> animateArms() {
        return event -> {
            AnimationController controller = event.getController();
            RawAnimation animation = RawAnimation.begin();
            controller.setAnimationSpeed(1.0);
            if (this.hasTarget()) {
                String animationName = this.isUpgraded() ? "laser_mode" : "gun_mode";
                animation.thenPlayAndHold(animationName);
                ((AnimationHelper)this.animationHelper.get()).syncAnimation(event, animationName, 15);
            } else if (controller.getCurrentAnimation() != null) {
                String animationName = this.isUpgraded() ? "laser_mode_end" : "gun_mode_end";
                animation.thenPlay(animationName);
                ((AnimationHelper)this.animationHelper.get()).syncAnimation(event, animationName, 15);
            } else {
                return PlayState.STOP;
            }
            return event.setAndContinue(animation);
        };
    }

    @NotNull
    private AnimationController.AnimationStateHandler<Securitron> animate() {
        return event -> {
            AnimationController controller = event.getController();
            RawAnimation animation = RawAnimation.begin();
            controller.setAnimationSpeed(1.0);
            if (event.isMoving()) {
                animation.thenLoop("walk");
                controller.setAnimationSpeed(2.0);
            } else {
                animation.thenLoop("idle");
            }
            return event.setAndContinue(animation);
        };
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SECURITRON_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.SECURITRON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ROBOT_DEATH.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_216990_((SoundEvent)ModSounds.SECURITRON_WALK.get());
    }

    @NotNull
    private AnimationController.AnimationStateHandler<Securitron> animateAntena() {
        return event -> event.setAndContinue(RawAnimation.begin().thenLoop("antena"));
    }

    public void hasTarget(boolean hasTarget) {
        this.m_20088_().m_135381_(HAS_TARGET, (Object)hasTarget);
    }

    public boolean hasTarget() {
        return (Boolean)this.m_20088_().m_135370_(HAS_TARGET);
    }

    public int getAttackDelay() {
        return 15;
    }

    public SecuritronVariant getVariant() {
        return SecuritronVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(SecuritronVariant variant) {
        this.setTypeVariant(variant.ordinal() & 0xFF);
    }

    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setTypeVariant(int pTypeVariant) {
        this.f_19804_.m_135381_(VARIANT, (Object)pTypeVariant);
    }

    private boolean isUpgraded() {
        return this.getVariant().isUpgraded();
    }
}

