/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.goals;

import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import com.nukateam.nukacraft.common.foundation.entities.mobs.Securitron;
import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class SecuritronRangedAttackGoal<T extends Securitron>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T mob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay = 0;
    private int updatePathDelay;
    private int reloadTimer = 0;
    private LivingEntity buffTarget = null;

    public SecuritronRangedAttackGoal(T pMob, double pSpeedModifier, float pAttackRadius) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.attackRadiusSqr = pAttackRadius * pAttackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingGun();
    }

    private boolean isHoldingGun() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof WeaponItem);
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingGun();
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        ((Securitron)this.mob).m_6710_(null);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean flag2;
        boolean seen;
        LivingEntity target = this.mob.m_5448_();
        if (this.buffTarget == null && target != null) {
            this.attackDelay = ((Securitron)this.mob).getAttackDelay();
        }
        this.buffTarget = target;
        if (this.buffTarget == null) {
            return;
        }
        boolean hasLineOfSight = this.mob.m_21574_().m_148306_((Entity)this.buffTarget);
        boolean bl = seen = this.seeTime > 0;
        if (hasLineOfSight != seen) {
            this.seeTime = 0;
        }
        this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
        double distance = this.mob.m_20280_((Entity)this.buffTarget);
        boolean bl2 = flag2 = (distance > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
        if (flag2) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                this.mob.m_21573_().m_5624_((Entity)this.buffTarget, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
            }
        } else {
            this.updatePathDelay = 0;
            this.mob.m_21573_().m_26573_();
        }
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        ItemStack gunStack = ((Securitron)this.mob).getGun();
        WeaponItem gun = (WeaponItem)((Securitron)this.mob).getGun().m_41720_();
        WeaponData gunData = new WeaponData(gunStack, this.mob);
        if (WeaponStateHelper.hasAmmo((ItemStack)((Securitron)this.mob).getGun())) {
            if (this.attackDelay == 0) {
                ((Securitron)this.mob).m_6504_(target, 1.0f);
            }
        } else if (this.reloadTimer == -1) {
            this.reloadTimer = gun.getConfig().getGeneral().getReloadTime();
        } else if (this.reloadTimer > 0) {
            this.reloadTimer = Math.max(this.reloadTimer - 1, 0);
        } else if (this.reloadTimer == 0) {
            WeaponStateHelper.fillAmmo((WeaponData)gunData);
            this.reloadTimer = -1;
        }
        if (this.attackDelay > 0) {
            --this.attackDelay;
        }
    }

    private boolean canRun() {
        return true;
    }
}

