/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.items.armor;

import com.nukateam.chassis_core.common.foundation.item.StackUtils;
import com.nukateam.geo.interfaces.IResourceProvider;
import com.nukateam.nukacraft.client.render.renderers.armor.ArmorRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GeoArmorItem
extends ArmorItem
implements GeoItem,
IResourceProvider {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Lazy<ResourceLocation> id = Lazy.of(() -> ForgeRegistries.ITEMS.getKey((Object)this));

    public GeoArmorItem(ArmorMaterial materialIn, ArmorItem.Type slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    public ResourceLocation getId() {
        return (ResourceLocation)this.id.get();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private ArmorRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new ArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, list, isAdvanced);
        String variant = StackUtils.getVariant((ItemStack)stack);
        if (variant.equals("default")) {
            list.add((Component)Component.m_237115_((String)"skin.clear"));
        } else {
            list.add((Component)Component.m_237115_((String)("skin." + variant)));
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

