/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.items.consumables;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.nukateam.nukacraft.common.foundation.items.consumables.RadItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EffectRadItem
extends RadItem {
    private final List<Supplier<MobEffectInstance>> effectSuppliers = new ArrayList<Supplier<MobEffectInstance>>();
    private List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();

    public EffectRadItem(float radiation, Supplier<MobEffectInstance> effect, Item.Properties properties) {
        super(radiation, properties);
        if (effect != null) {
            this.effectSuppliers.add(effect);
        }
    }

    public EffectRadItem(float radiation, Supplier<MobEffectInstance> effect, Item.Properties properties, Boolean cold) {
        super(radiation, properties);
        if (effect != null) {
            this.effectSuppliers.add(effect);
        }
    }

    public EffectRadItem(float radiation, List<Supplier<MobEffectInstance>> effects, Item.Properties properties) {
        super(radiation, properties);
        if (effects != null) {
            this.effectSuppliers.addAll(effects);
        }
    }

    public static void addPotionTooltip(List<Component> pTooltips, List<Supplier<MobEffectInstance>> effects) {
        ArrayList list = Lists.newArrayList();
        for (Supplier<MobEffectInstance> supplier : effects) {
            MobEffectInstance effect = supplier.get();
            if (effect == null) continue;
            Map map = effect.m_19544_().m_19485_();
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_19544_().m_7048_(effect.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                    list.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                }
            }
            MutableComponent mutablecomponent = Component.m_237115_((String)effect.m_19576_());
            if (effect.m_19564_() > 0) {
                mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + effect.m_19564_()))});
            }
            if (effect.m_19557_() > 20) {
                mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)effect, (float)1.0f)});
            }
            pTooltips.add((Component)mutablecomponent.m_130940_(effect.m_19544_().m_19483_().m_19497_()));
        }
        if (!list.isEmpty()) {
            pTooltips.add((Component)Component.m_237113_((String)""));
            pTooltips.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list) {
                AttributeModifier attributeModifier = (AttributeModifier)pair.getSecond();
                double d0 = attributeModifier.m_22218_();
                double d1 = attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributeModifier.m_22218_() : attributeModifier.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    pTooltips.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                pTooltips.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    @Override
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        for (Supplier<MobEffectInstance> supp : this.effectSuppliers) {
            MobEffectInstance effect = supp.get();
            this.effects.clear();
            this.effects.add(effect);
            entity.m_7292_(effect);
        }
        return super.m_5922_(stack, level, entity);
    }

    @Override
    public void m_7373_(ItemStack item, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(item, level, list, flag);
        EffectRadItem.addPotionTooltip(list, this.effectSuppliers);
    }
}

