/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.foundation.world;

import com.mojang.serialization.DataResult;
import com.nukateam.nukacraft.common.data.utils.Resources;
import com.nukateam.nukacraft.common.foundation.world.WastelandBiomeBuilder;
import com.nukateam.nukacraft.common.foundation.world.WastelandNoiseRouterData;
import com.nukateam.nukacraft.common.foundation.world.WastelandSurfaceRule;
import com.nukateam.nukacraft.common.registery.fluid.ModFluids;
import java.util.OptionalLong;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class WastelandDimensionsSettings {
    public static final ResourceLocation WASTELAND = Resources.nukaResource("fallout_wasteland");
    public static final ResourceKey<Level> WASTELAND_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)WASTELAND);
    public static final ResourceKey<DimensionType> WASTELAND_DIM_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)WASTELAND);
    static final NoiseSettings WASTELAND_NOISE_SETTINGS = WastelandDimensionsSettings.create(-64, 384, 1, 2);
    public static final ResourceKey<NoiseGeneratorSettings> WASTELAND_NOISE_GEN = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)Resources.nukaResource("fallout_wasteland_noise"));

    public static void bootstrapNoise(BootstapContext<NoiseGeneratorSettings> context) {
        context.m_255272_(WASTELAND_NOISE_GEN, (Object)WastelandDimensionsSettings.falloutNoise(context));
    }

    public static void bootstrapType(BootstapContext<DimensionType> context) {
        context.m_255272_(WASTELAND_DIM_TYPE, (Object)WastelandDimensionsSettings.falloutDimensionType());
    }

    public static NoiseGeneratorSettings falloutNoise(BootstapContext<NoiseGeneratorSettings> context) {
        NoiseRouter falloutNoise = WastelandNoiseRouterData.falloutNoise((HolderGetter<DensityFunction>)context.m_255420_(Registries.f_257040_), (HolderGetter<NormalNoise.NoiseParameters>)context.m_255420_(Registries.f_256865_), false, false);
        return new NoiseGeneratorSettings(WASTELAND_NOISE_SETTINGS, Blocks.f_50440_.m_49966_(), ((LiquidBlock)ModFluids.DIRTY_WATER_BLOCK.get()).m_49966_(), falloutNoise, WastelandSurfaceRule.fallout(), new WastelandBiomeBuilder().spawnTarget(), 4, false, true, false, false);
    }

    private static DimensionType falloutDimensionType() {
        return new DimensionType(OptionalLong.empty(), true, false, false, true, 1.0, true, false, -64, 384, 384, BlockTags.f_13058_, BuiltinDimensionTypes.f_223542_, 0.0f, new DimensionType.MonsterSettings(false, true, (IntProvider)UniformInt.m_146622_((int)0, (int)7), 7));
    }

    private static DataResult<NoiseSettings> guardY(NoiseSettings p_158721_) {
        if (p_158721_.f_158688_() + p_158721_.f_64508_() > DimensionType.f_156652_ + 1) {
            return DataResult.error(() -> "min_y + height cannot be higher than: " + (DimensionType.f_156652_ + 1));
        }
        if (p_158721_.f_64508_() % 16 != 0) {
            return DataResult.error(() -> "height has to be a multiple of 16");
        }
        return p_158721_.f_158688_() % 16 != 0 ? DataResult.error(() -> "min_y has to be a multiple of 16") : DataResult.success((Object)p_158721_);
    }

    public static NoiseSettings create(int p_224526_, int p_224527_, int p_224528_, int p_224529_) {
        NoiseSettings noisesettings = new NoiseSettings(p_224526_, p_224527_, p_224528_, p_224529_);
        WastelandDimensionsSettings.guardY(noisesettings).error().ifPresent(p_158719_ -> {
            throw new IllegalStateException(p_158719_.message());
        });
        return noisesettings;
    }
}

