/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.registery;

import com.nukateam.ntgl.common.util.helpers.RegistrationHelper;
import com.nukateam.nukacraft.common.data.enums.PowerArmorPart;
import com.nukateam.nukacraft.common.registery.blocks.ModBlocks;
import com.nukateam.nukacraft.common.registery.items.ModArmorItems;
import com.nukateam.nukacraft.common.registery.items.ModBlockItems;
import com.nukateam.nukacraft.common.registery.items.ModFood;
import com.nukateam.nukacraft.common.registery.items.ModItems;
import com.nukateam.nukacraft.common.registery.items.ModWeapons;
import com.nukateam.nukacraft.common.registery.items.PlantItems;
import com.nukateam.nukacraft.common.registery.items.PowerArmorItems;
import com.nukateam.nukacraft.common.registery.items.SpawnEggs;
import com.nukateam.nukacraft.common.registery.items.WeaponAttachments;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModItemTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"nukacraft");
    public static final RegistryObject<CreativeModeTab> NUKA_MATERIAL = ModItemTabs.createTab("nuka_material", () -> ModItems.ADVMAG.get(), (params, output) -> ModItemTabs.registerItems(output, ModItems.ITEMS));
    public static final RegistryObject<CreativeModeTab> NUKA_BLOCKS = ModItemTabs.createTab("nuka_blocks", () -> ModBlocks.BLUE_TILE.get(), (params, output) -> ModItemTabs.registerItems(output, ModBlockItems.ITEMS));
    public static final RegistryObject<CreativeModeTab> NUKA_PLANTS = ModItemTabs.createTab("nuka_plants", () -> PlantItems.BLOODLEAF_BUSH.get(), (params, output) -> ModItemTabs.registerItems(output, PlantItems.ITEMS));
    public static final RegistryObject<CreativeModeTab> NUKA_FOOD = ModItemTabs.createTab("nuka_foods", () -> ModFood.NUKA_COLA.get(), (params, output) -> ModItemTabs.registerItems(output, ModFood.ITEMS));
    public static final RegistryObject<CreativeModeTab> NUKA_WEAPONS = ModItemTabs.createTab("nuka_equip", () -> ModWeapons.ROUND10MM.get(), ModItemTabs::getWeaponTab);
    public static final RegistryObject<CreativeModeTab> NUKA_ARMOR = ModItemTabs.createTab("nuka_armor", () -> ((RegistryObject)((RegistryObject)PowerArmorItems.T45_SET.get((Object)PowerArmorPart.HELMET))).get(), ModItemTabs::getArmorTab);
    public static final RegistryObject<CreativeModeTab> NUKA_MOBS = ModItemTabs.createTab("nuka_mobs", () -> SpawnEggs.BRAHMIN_SPAWN_EGG.get(), ModItemTabs::getMobTab);

    private static void getArmorTab(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        ModItemTabs.registerItems(output, PowerArmorItems.ITEMS);
        ModItemTabs.registerItems(output, ModArmorItems.ITEMS);
    }

    private static void getWeaponTab(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        ModItemTabs.registerGuns(output, ModWeapons.ITEMS);
        ModItemTabs.registerItems(output, WeaponAttachments.ITEMS);
    }

    private static void getMobTab(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        ModItemTabs.registerItems(output, SpawnEggs.ITEMS);
    }

    private static void registerItems(CreativeModeTab.Output output, DeferredRegister<Item> register) {
        for (RegistryObject entry : register.getEntries()) {
            output.m_246326_((ItemLike)entry.get());
        }
    }

    private static void registerGuns(CreativeModeTab.Output output, DeferredRegister<Item> register) {
        for (RegistryObject entry : register.getEntries()) {
            RegistrationHelper.registerGunOrDefault((CreativeModeTab.Output)output, (Item)((Item)entry.get()));
        }
    }

    private static RegistryObject<CreativeModeTab> createTab(String name, Supplier<ItemLike> icon, BiConsumer<CreativeModeTab.ItemDisplayParameters, CreativeModeTab.Output> getItems) {
        return CREATIVE_MODE_TABS.register(name, () -> CreativeModeTab.builder().m_257737_(() -> ModItemTabs.lambda$createTab$4((Supplier)icon)).m_257941_((Component)Component.m_237115_((String)("itemGroup." + name))).m_257501_(getItems::accept).m_257652_());
    }

    public static void register(IEventBus eventBus) {
        CREATIVE_MODE_TABS.register(eventBus);
    }

    private static /* synthetic */ ItemStack lambda$createTab$4(Supplier icon) {
        return new ItemStack((ItemLike)icon.get());
    }
}

