/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.registery.fluid;

import com.nukateam.nukacraft.common.foundation.blocks.fluids.AcidFluidBlock;
import com.nukateam.nukacraft.common.foundation.blocks.fluids.RadWaterBlock;
import com.nukateam.nukacraft.common.registery.blocks.ModBlocks;
import com.nukateam.nukacraft.common.registery.fluid.ModFluidTypes;
import com.nukateam.nukacraft.common.registery.items.ModItems;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import oshi.util.tuples.Pair;

public class ModFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"nukacraft");
    public static final RegistryObject<FlowingFluid> ACID_FLUID = FLUIDS.register("acid_fluid", () -> new ForgeFlowingFluid.Source(ACID_PROPERTIES));
    public static final RegistryObject<FlowingFluid> ACID_FLOWING = FLUIDS.register("acid_flowing", () -> new ForgeFlowingFluid.Flowing(ACID_PROPERTIES));
    public static final RegistryObject<FlowingFluid> DIRTY_WATER_FLUID = FLUIDS.register("dirty_water_still", () -> new ForgeFlowingFluid.Source(DIRTY_WATER_PROPERTIES));
    public static final RegistryObject<FlowingFluid> DIRTY_WATER_FLOWING = FLUIDS.register("dirty_water_flowing", () -> new ForgeFlowingFluid.Flowing(DIRTY_WATER_PROPERTIES));
    public static final RegistryObject<FlowingFluid> POISONOUS_WATER_FLUID = FLUIDS.register("poisonous_water_still", () -> new ForgeFlowingFluid.Source(POISONOUS_WATER_PROPERTIES));
    public static final RegistryObject<FlowingFluid> POISONOUS_WATER_FLOWING = FLUIDS.register("poisonous_water_flowing", () -> new ForgeFlowingFluid.Flowing(POISONOUS_WATER_PROPERTIES));
    public static final RegistryObject<LiquidBlock> ACID_BLOCK = ModBlocks.BLOCKS.register("acid", () -> new AcidFluidBlock(ACID_FLUID, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
    public static final RegistryObject<LiquidBlock> DIRTY_WATER_BLOCK = ModBlocks.BLOCKS.register("dirty_water", () -> new RadWaterBlock((Supplier<? extends FlowingFluid>)DIRTY_WATER_FLUID, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
    public static final RegistryObject<LiquidBlock> POISONOUS_WATER_BLOCK = ModBlocks.BLOCKS.register("poisonous_water", () -> new RadWaterBlock((Supplier<? extends FlowingFluid>)POISONOUS_WATER_FLUID, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
    public static final ForgeFlowingFluid.Properties ACID_PROPERTIES = new ForgeFlowingFluid.Properties(ModFluidTypes.ACID_FLUID_TYPE, ACID_FLUID, ACID_FLOWING).slopeFindDistance(2).levelDecreasePerBlock(2).block(() -> (LiquidBlock)ACID_BLOCK.get()).bucket(() -> (Item)ModItems.ACID_BUCKET.get());
    public static final ForgeFlowingFluid.Properties DIRTY_WATER_PROPERTIES = new ForgeFlowingFluid.Properties(ModFluidTypes.DIRTY_WATER_FLUID_TYPE, DIRTY_WATER_FLUID, DIRTY_WATER_FLOWING).slopeFindDistance(2).levelDecreasePerBlock(2).block(() -> (LiquidBlock)DIRTY_WATER_BLOCK.get()).bucket(() -> (Item)ModItems.DIRTY_WATER_BUCKET.get());
    public static final ForgeFlowingFluid.Properties POISONOUS_WATER_PROPERTIES = new ForgeFlowingFluid.Properties(ModFluidTypes.POISONOUS_WATER_FLUID_TYPE, POISONOUS_WATER_FLUID, POISONOUS_WATER_FLOWING).slopeFindDistance(2).levelDecreasePerBlock(2).block(() -> (LiquidBlock)POISONOUS_WATER_BLOCK.get()).bucket(() -> (Item)ModItems.POISONOUS_WATER_BUCKET.get());

    @Nullable
    public static Pair<Block, Block> getLavaInteraction(FluidState fluidState) {
        Fluid fluid = fluidState.m_76152_();
        if (fluid.m_6212_((Fluid)ACID_FLUID.get())) {
            return new Pair((Object)Blocks.f_50723_, (Object)Blocks.f_152496_);
        }
        return null;
    }

    public static void register(IEventBus eventBus) {
        FLUIDS.register(eventBus);
    }
}

