/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.nukacraft.common.registery.items;

import com.mojang.datafixers.util.Pair;
import com.nukateam.nukacraft.common.data.utils.ArmorStorage;
import com.nukateam.nukacraft.common.datagen.utils.annotations.ItemModelGen;
import com.nukateam.nukacraft.common.foundation.items.armor.GeoArmorItem;
import com.nukateam.nukacraft.common.foundation.items.misc.PipBoyItem;
import com.nukateam.nukacraft.common.foundation.materials.ModArmorMaterials;
import java.util.List;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModArmorItems {
    public static final List<Pair<ArmorItem.Type, String>> ARMOR_SLOTS = List.of(Pair.of((Object)ArmorItem.Type.HELMET, (Object)"helmet"), Pair.of((Object)ArmorItem.Type.CHESTPLATE, (Object)"chest"), Pair.of((Object)ArmorItem.Type.LEGGINGS, (Object)"leggins"), Pair.of((Object)ArmorItem.Type.BOOTS, (Object)"boots"));
    public static final List<Pair<ArmorItem.Type, String>> CLOTH_SLOTS = List.of(Pair.of((Object)ArmorItem.Type.CHESTPLATE, (Object)"chest"), Pair.of((Object)ArmorItem.Type.LEGGINGS, (Object)"leggins"), Pair.of((Object)ArmorItem.Type.BOOTS, (Object)"boots"));
    public static final List<Pair<ArmorItem.Type, String>> CLOTH_WITHOUT_BOOTS = List.of(Pair.of((Object)ArmorItem.Type.CHESTPLATE, (Object)"chest"), Pair.of((Object)ArmorItem.Type.LEGGINGS, (Object)"leggins"));
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"nukacraft");
    @ItemModelGen(path="armor")
    public static final ArmorStorage WOODEN_SET = ModArmorItems.registerArmorSet("wooden", ModArmorMaterials.WOOD);
    @ItemModelGen(path="armor")
    public static final ArmorStorage LEATHER_SET = ModArmorItems.registerArmorSet("leather", ModArmorMaterials.HARDLEATHER);
    @ItemModelGen(path="armor")
    public static final ArmorStorage VAULT_DWELLER_SET = ModArmorItems.registerClothSet("vault_dweller", ModArmorMaterials.CLOTH);
    @ItemModelGen(path="armor")
    public static final ArmorStorage VAULT_SCIENTIST_SET = ModArmorItems.registerClothSetWithoutBoots("vault_science", ModArmorMaterials.CLOTH);
    @ItemModelGen(path="armor")
    public static final ArmorStorage RAIDER_SET = ModArmorItems.registerArmorSet("raiders", ModArmorMaterials.RAIDER);
    @ItemModelGen(path="armor")
    public static final ArmorStorage METAL_SET = ModArmorItems.registerArmorSet("metal", ModArmorMaterials.METAL);
    @ItemModelGen(path="armor")
    public static final ArmorStorage TRAPPER_SET = ModArmorItems.registerArmorSet("trapper", ModArmorMaterials.TRAPPER);
    @ItemModelGen(path="armor")
    public static final ArmorStorage SCOUT_SET = ModArmorItems.registerArmorSet("scout", ModArmorMaterials.SCOUT);
    @ItemModelGen(path="armor")
    public static final ArmorStorage VAULT_SECURITY_SET = ModArmorItems.registerArmorSet("vault_security", ModArmorMaterials.SCOUT);
    @ItemModelGen(path="armor")
    public static final ArmorStorage COMBAT_SET = ModArmorItems.registerArmorSet("combat", ModArmorMaterials.COMBAT);
    @ItemModelGen(path="armor")
    public static final ArmorStorage ROBOT_SET = ModArmorItems.registerArmorSet("robot", ModArmorMaterials.ROBOT);
    public static final RegistryObject<Item> PIP_BOY_D = ITEMS.register("pipboy", () -> new PipBoyItem("default", new Item.Properties().m_41487_(1)));

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }

    private static ArmorStorage registerArmorSet(String name, ArmorMaterial material) {
        return ModArmorItems.registerSet(name, material, ARMOR_SLOTS);
    }

    private static ArmorStorage registerClothSet(String name, ArmorMaterial material) {
        return ModArmorItems.registerSet(name, material, CLOTH_SLOTS);
    }

    private static ArmorStorage registerClothSetWithoutBoots(String name, ArmorMaterial material) {
        return ModArmorItems.registerSet(name, material, CLOTH_WITHOUT_BOOTS);
    }

    private static ArmorStorage registerSet(String name, ArmorMaterial material, List<Pair<ArmorItem.Type, String>> slots) {
        ArmorStorage armorSet = new ArmorStorage();
        for (Pair<ArmorItem.Type, String> slot : slots) {
            RegistryObject<Item> item = ModArmorItems.registerArmor(name + "_" + (String)slot.getSecond(), material, (ArmorItem.Type)slot.getFirst());
            armorSet.put((ArmorItem.Type)slot.getFirst(), item);
        }
        return armorSet;
    }

    private static RegistryObject<Item> registerArmor(String registryName, ArmorMaterial material, ArmorItem.Type slot) {
        return ITEMS.register(registryName, () -> new GeoArmorItem(material, slot, new Item.Properties()));
    }
}

